package jp.co.sra.jun.goodies.multimedia;

import java.awt.*;
import java.io.*;
import jp.co.sra.smalltalk.*;
import jp.co.sra.jun.goodies.dump.JunDumpModel;
import jp.co.sra.jun.system.framework.JunApplicationModel;

/**
 * JunMultiMediaTextModel class
 * 
 *  @author    nisinaka
 *  @created   2003/03/18 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun490 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunMultiMediaTextModel.java,v 8.11 2008/02/20 06:31:50 nisinaka Exp $
 */
public class JunMultiMediaTextModel extends JunApplicationModel implements JunMultiMediaViewable {

	protected static final int DefaultCheckingSize = 1024;

	protected StValueHolder textHolder;

	/**
	 * Create a new instance of <code>JunMultiMediaTextModel</code> and initialize it.
	 * 
	 * @category Instance creation
	 */
	public JunMultiMediaTextModel() {
		super();
	}

	/**
	 * Create a new instance of <code>JunMultiMediaTextModel</code> and initialize it.
	 * 
	 * @param aFile java.io.File
	 * @category Instance creation
	 */
	public JunMultiMediaTextModel(File aFile) {
		this(aFile, 0);
	}

	/**
	 * Create a new instance of <code>JunMultiMediaTextModel</code> and initialize it.
	 * 
	 * @param aFile java.io.File
	 * @param limitSize long
	 * @category Instance creation
	 */
	public JunMultiMediaTextModel(File aFile, long limitSize) {
		this();

		String aString;
		if (aFile.exists()) {
			long fileSize = aFile.length();
			if (CanReadAsText_(aFile) && (limitSize <= 0 || fileSize <= limitSize)) {
				BufferedReader reader = null;
				BufferedWriter writer = null;
				try {
					StringWriter sw = new StringWriter();
					writer = new BufferedWriter(sw);
					reader = new BufferedReader(new FileReader(aFile));
					int ch;
					while ((ch = reader.read()) >= 0) {
						writer.write(ch);
					}
					writer.flush();
					aString = sw.toString();
				} catch (FileNotFoundException e) {
					aString = e.toString();
				} catch (IOException e) {
					aString = e.toString();
				} finally {
					try {
						if (reader != null) {
							reader.close();
						}
						if (writer != null) {
							writer.flush();
							writer.close();
						}
					} catch (IOException e) {
					}
				}
			} else {
				JunDumpModel dumpModel = new JunDumpModel(aFile, 0, DefaultCheckingSize);
				aString = (String) dumpModel.textModel().value();
				if (fileSize > DefaultCheckingSize) {
					aString += "...";
				}
			}
		} else {
			aString = "Unexpected text file";
		}

		this.textHolder_(new StValueHolder(aString));
	}

	/**
	 * Answer true if the file can be read as a text file, otherwise false.
	 *
	 * @return boolean
	 * @param aFile java.io.File
	 * @category boolean
	 */
	public static boolean CanReadAsText_(File aFile) {
		if (aFile.exists() == false) {
			return false;
		}
		if (aFile.canRead() == false) {
			return false;
		}

		InputStream in = null;
		try {
			in = new BufferedInputStream(new FileInputStream(aFile));
			int howMany = DefaultCheckingSize;
			int ch;
			while ((ch = in.read()) >= 0 && howMany > 0) {
				if (ch == 0 || Character.isDefined((char) ch) == false) {
					return false;
				}
				howMany = howMany - 1;
			}
		} catch (FileNotFoundException e) {
			return false;
		} catch (IOException e) {
			return false;
		} finally {
			try {
				if (in != null) {
					in.close();
				}
			} catch (IOException e) {
			}
		}

		return true;
	}

	/**
	 * Make be invisible.
	 * 
	 * @see jp.co.sra.jun.goodies.multimedia.JunMultiMediaViewable#beInvisible()
	 * @category accessing
	 */
	public void beInvisible() {
		Object[] dependents = this.dependents();
		for (int i = 0; i < dependents.length; i++) {
			if (dependents[i] instanceof JunMultiMediaTextView) {
				((JunMultiMediaTextView) dependents[i]).toComponent().setVisible(false);
			}
		}
	}

	/**
	 * Make be visible.
	 * 
	 * @see jp.co.sra.jun.goodies.multimedia.JunMultiMediaViewable#beVisible()
	 * @category accessing
	 */
	public void beVisible() {
		Object[] dependents = this.dependents();
		for (int i = 0; i < dependents.length; i++) {
			if (dependents[i] instanceof JunMultiMediaTextView) {
				((JunMultiMediaTextView) dependents[i]).toComponent().setVisible(true);
			}
		}
	}

	/**
	 * Answer a default view.
	 * 
	 * @return jp.co.sra.smalltalk.StView
	 * @see jp.co.sra.smalltalk.StApplicationModel#defaultView()
	 * @category Interface opening
	 */
	public jp.co.sra.smalltalk.StView defaultView() {
		if (GetDefaultViewMode() == VIEW_AWT) {
			return new JunMultiMediaTextViewAwt(this);
		} else {
			return new JunMultiMediaTextViewSwing(this);
		}
	}

	/**
	 * Answer true if the imag model is embedded, otherwise false.
	 *
	 * @return boolean
	 * @category testing
	 */
	public boolean isEmbedded() {
		StView aView = this.getView();
		if (aView != null && aView.toComponent().getParent() instanceof Window) {
			return false;
		}

		return true;
	}

	/**
	 * Answer my current text holder.
	 *
	 * @return jp.co.sra.smalltalk.StValueHolder
	 * @category aspects
	 */
	public StValueHolder textHolder() {
		if (textHolder == null) {
			textHolder = new StValueHolder(new String());
		}
		return textHolder;
	}

	/**
	 * Set my new text holder.
	 *
	 * @param newTextHolder jp.co.sra.smalltalk.StValueHolder
	 * @category aspects
	 */
	public void textHolder_(StValueHolder newTextHolder) {
		textHolder = newTextHolder;
	}

	/**
	 * Initialize the ApplicationModel when created.
	 * 
	 * @see jp.co.sra.smalltalk.StApplicationModel#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();
		textHolder = null;
	}

	/**
	 * Set the size for the view.
	 * 
	 * @param extent java.awt.Dimension
	 * @see jp.co.sra.jun.system.framework.JunApplicationModel#setSize_(java.awt.Dimension)
	 * @category bounds accessing
	 */
	protected void setSize_(Dimension extent) {
		if (this.isEmbedded()) {
			return;
		}

		super.setSize_(extent);
	}

	/**
	 * Answer a window title.
	 * 
	 * @return java.lang.String
	 * @see jp.co.sra.smalltalk.StApplicationModel#windowTitle()
	 * @category Interface opening
	 */
	protected String windowTitle() {
		return $String("Text");
	}
}
