package jp.co.sra.jun.goodies.multimedia;

import jp.co.sra.jun.goodies.movie.framework.JunMovieHandle;
import jp.co.sra.jun.goodies.movie.framework.JunMoviePlayer;
import jp.co.sra.jun.goodies.movie.framework.JunMovieView;
import jp.co.sra.jun.goodies.movie.framework.JunMovieViewAwt;
import jp.co.sra.jun.system.framework.JunAbstractViewPanel;

/**
 * JunMultiMediaMovieViewAwt class
 * 
 *  @author    nisinaka
 *  @created   2003/03/24 (by nisinaka)
 *  @updated   2004/09/22 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun490 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunMultiMediaMovieViewAwt.java,v 8.11 2008/02/20 06:31:50 nisinaka Exp $
 */
public class JunMultiMediaMovieViewAwt extends JunAbstractViewPanel implements JunMultiMediaMovieView {

	protected JunMovieViewAwt movieView;

	/**
	 * Create a new instance of <code>JunMultiMediaMovieViewAwt</code> and initialize it.
	 * 
	 * @param aMovieModel jp.co.sra.jun.goodies.multimedia.JunMultiMediaMovieModel
	 * @category Instance creation
	 */
	public JunMultiMediaMovieViewAwt(JunMultiMediaMovieModel aMovieModel) {
		super(aMovieModel);
	}

	/**
	 * Answer my model as a JunMoviePlayer.
	 * 
	 * @return jp.co.sra.jun.goodies.movie.framework.JunMoviePlayer
	 * @see jp.co.sra.jun.goodies.movie.framework.JunMovieView#getMoviePlayer()
	 * @category model accessing
	 */
	public JunMoviePlayer getMoviePlayer() {
		return (JunMoviePlayer) this.model();
	}

	/**
	 * Answer my movie view as JunMovieView.
	 *
	 * @return jp.co.sra.jun.goodies.movie.framework.JunMovieView
	 * @see jp.co.sra.jun.goodies.multimedia.JunMultiMediaMovieView#getMovieView()
	 * @category user interface
	 */
	public JunMovieView getMovieView() {
		return (JunMovieView) this.movieView();
	}

	/**
	 * Ansewr true if the view has a movie, otherwise false.
	 * 
	 * @return boolean
	 * @see jp.co.sra.jun.goodies.movie.framework.JunMovieView#hasMovie()
	 * @category testing
	 */
	public boolean hasMovie() {
		return this.movieView().hasMovie();
	}

	/**
	 * Ansewr true if the view has a tracker, otherwise false.
	 * 
	 * @return boolean
	 * @see jp.co.sra.jun.goodies.movie.framework.JunMovieView#hasTracker()
	 * @category testing
	 */
	public boolean hasTracker() {
		return this.movieView().hasTracker();
	}

	/**
	 * Ansewr true if the view has a second tracker, otherwise false.
	 * 
	 * @return boolean
	 * @see jp.co.sra.jun.goodies.movie.framework.JunMovieView#hasTracker2()
	 * @category testing
	 */
	public boolean hasTracker2() {
		return this.movieView().hasTracker2();
	}

	/**
	 * Answer my movie handle.
	 * 
	 * @return jp.co.sra.jun.goodies.JunMovieHandle
	 * @see jp.co.sra.jun.goodies.movie.framework.JunMovieView#movieHandle()
	 * @category accessing
	 */
	public JunMovieHandle movieHandle() {
		return this.movieView().movieHandle();
	}

	/**
	 * Answer my movie view.
	 *
	 * @return jp.co.sra.jun.goodies.movie.framework.JunMovieViewAwt
	 * @category user interface
	 */
	public JunMovieViewAwt movieView() {
		if (movieView == null) {
			movieView = new JunMovieViewAwt(this.getMoviePlayer());
		}

		return movieView;
	}

	/**
	 * Set the bounds of myself and my components.
	 *
	 * @param x int
	 * @param y int
	 * @param width int
	 * @param height int
	 * @see java.awt.Component#setBounds(int, int, int, int)
	 * @category bounds accessing
	 */
	public void setBounds(int x, int y, int width, int height) {
		super.setBounds(x, y, width, height);

		this.movieView().setBounds(1, 1, width - 1 - 1, height - 39 - 1);
		this.movieView().sliderView().setBounds(77, height - 19, width - 77 - 77, 18);
		this.movieView().sliderView2().setBounds(1, height - 38, width - 1 - 1, 18);
		this.movieView().firstButtonView().setBounds(1, height - 19, 18, 18);
		this.movieView().lastButtonView().setBounds(20, height - 19, 18, 18);
		this.movieView().previousButtonView().setBounds(39, height - 19, 18, 18);
		this.movieView().nextButtonView().setBounds(58, height - 19, 18, 18);
		this.movieView().loopButtonView().setBounds(width - 76, height - 19, 18, 18);
		this.movieView().playButtonView().setBounds(width - 57, height - 19, 18, 18);
		this.movieView().firstMarkerButtonView().setBounds(width - 38, height - 19, 18, 18);
		this.movieView().lastMarkerButtonView().setBounds(width - 19, height - 19, 18, 18);
	}

	/**
	 * Set the movie view.
	 * 
	 * @see jp.co.sra.jun.goodies.movie.framework.JunMovieView#setMovieView()
	 * @category private
	 */
	public void setMovieView() {
		this.movieView().setMovieView();
	}

	/**
	 * Build this component.
	 * 
	 * @see jp.co.sra.smalltalk.StViewPanel#buildComponent()
	 * @category initialize-release
	 */
	protected void buildComponent() {
		this.setLayout(null);
		this.add(this.movieView());
		this.add(this.movieView().sliderView());
		this.add(this.movieView().sliderView2());
		this.add(this.movieView().firstButtonView());
		this.add(this.movieView().lastButtonView());
		this.add(this.movieView().previousButtonView());
		this.add(this.movieView().nextButtonView());
		this.add(this.movieView().loopButtonView());
		this.add(this.movieView().playButtonView());
		this.add(this.movieView().firstMarkerButtonView());
		this.add(this.movieView().lastMarkerButtonView());
		this.setSize(260, 180);
	}

}
