package jp.co.sra.jun.goodies.multimedia;

import java.awt.Dimension;

import jp.co.sra.smalltalk.StController;
import jp.co.sra.smalltalk.WindowSpecLayout;

import jp.co.sra.jun.goodies.button.JunButtonViewSwing;
import jp.co.sra.jun.goodies.wheels.JunThumbWheelViewSwing;
import jp.co.sra.jun.opengl.display.JunOpenGLDisplayViewSwing;

/**
 * JunMultiMediaBodyViewSwing class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2007/03/14 (by m-asada)
 *  @updated   2007/08/24 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun646 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunMultiMediaBodyViewSwing.java,v 8.9 2008/02/20 06:31:50 nisinaka Exp $
 */
public class JunMultiMediaBodyViewSwing extends JunOpenGLDisplayViewSwing implements JunMultiMediaBodyView {

	/**
	 * Create a new instance of <code>JunMultiMediaBodyViewSwing</code> and initialize it.
	 * 
	 * @param aMultiMediaBodyModel jp.co.sra.jun.goodies.multimedia.JunMultiMediaBodyModel
	 * @category Instance creation
	 */
	public JunMultiMediaBodyViewSwing(JunMultiMediaBodyModel aMultiMediaBodyModel) {
		super(aMultiMediaBodyModel);
	}

	/**
	 * Build this component.
	 * 
	 * @see jp.co.sra.smalltalk.StViewJPanel#buildComponent()
	 * @category initialize-release
	 */
	protected void buildComponent() {
		this.setLayout(new WindowSpecLayout());
		this.add(this.createOpenGLDrawableOnBorderedPanel(), WindowSpecLayout.Position(0f, 1, 0f, 1, 1f, -20, 1f, -1));
		this.add(new JunButtonViewSwing(this.getOpenGLDisplayModel().pickButton()), WindowSpecLayout.Position(1f, -19, 0f, 1, 1f, -1, 0f, 19));
		this.add(new JunButtonViewSwing(this.getOpenGLDisplayModel().grabButton()), WindowSpecLayout.Position(1f, -19, 0f, 20, 1f, -1, 0f, 38));
		this.add(new JunButtonViewSwing(this.getOpenGLDisplayModel().dragButton()), WindowSpecLayout.Position(1f, -19, 0f, 39, 1f, -1, 0f, 57));
		this.add(new JunThumbWheelViewSwing(this.getOpenGLDisplayModel().zThumbWheel()), WindowSpecLayout.Position(1f, -19, 0.5f, -61, 1f, -1, 0.5f, 61));
		this.add(new JunButtonViewSwing(this.getOpenGLDisplayModel().focusButton()), WindowSpecLayout.Position(1f, -19, 0.5f, -80, 1f, -1, 0.5f, -62));
		this.add(new JunButtonViewSwing(this.getOpenGLDisplayModel().dollyButton()), WindowSpecLayout.Position(1f, -19, 0.5f, 62, 1f, -1, 0.5f, 80));
		this.setPreferredSize(new Dimension(300, 300));
	}

	/**
	 * Answer the receiver's default controller.
	 * 
	 * @return jp.co.sra.smalltalk.StController
	 * @see jp.co.sra.smalltalk.StViewJPanel#defaultController()
	 * @category controller accessing
	 */
	protected StController defaultController() {
		return new JunMultiMediaBodyController();
	}

}
