package jp.co.sra.jun.goodies.movie.support;

import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;

import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StImage;

import jp.co.sra.jun.goodies.animation.JunCartoonMovie;
import jp.co.sra.jun.system.support.JunSystem;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunImagesToGifAnimationTestExamples class
 * 
 *  @author    nisinaka
 *  @created   2007/10/04 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun695 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunImagesToGifAnimationTestExamples.java,v 8.2 2008/02/20 06:31:50 nisinaka Exp $
 */
public class JunImagesToGifAnimationTestExamples extends JunTestExamples {

	/**
	 * Example1:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		final Rectangle aRectangle = new Rectangle(0, 0, 320, 240);
		final Point aPoint = new Point(4, 3);
		final int tick = 20;
		File aFile = new File("Screen.gif");

		JunImagesToGifAnimation.File_extent_do_(aFile, aRectangle.getSize(), new StBlockClosure() {
			public Object value_(Object anObject) {
				JunImagesToGifAnimation imagesToGifAnimation = (JunImagesToGifAnimation) anObject;

				Rectangle screenBounds = JunSystem.ScreenBoundingBox();
				while (screenBounds.contains(aRectangle)) {
					System.out.println(aRectangle);
					StImage anImage = StImage._OfArea(aRectangle);
					imagesToGifAnimation.add_milliseconds_(anImage, tick);
					aRectangle.translate(aPoint.x, aPoint.y);
				}

				return null;
			}
		});

		JunCartoonMovie.ShowFile_(aFile);

		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(String[] args) {
		new JunImagesToGifAnimationTestExamples();
	}

}
