package jp.co.sra.jun.goodies.movie.support;

import java.awt.Dimension;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StImage;

import jp.co.sra.jun.goodies.cursors.JunCursors;
import jp.co.sra.jun.goodies.image.streams.JunGifAnimationStream;
import jp.co.sra.jun.system.framework.JunAbstractObject;

/**
 * JunImagesToGifAnimation class
 * 
 *  @author    nisinaka
 *  @created   2007/10/04 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun697 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunImagesToGifAnimation.java,v 8.3 2008/02/20 06:31:49 nisinaka Exp $
 */
public class JunImagesToGifAnimation extends JunAbstractObject {

	protected File file;
	protected JunGifAnimationStream stream;

	/**
	 * Create a new instance of JunImagesToGifAnimation and evaluate the block.
	 * 
	 * @param aFile java.io.File
	 * @param aDimension java.awt.Dimension
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * @return jp.co.sra.jun.goodies.movie.support.JunImagesToGifAnimation
	 * @category Instance creation
	 */
	public static JunImagesToGifAnimation File_extent_do_(File aFile, Dimension aDimension, StBlockClosure aBlock) {
		JunImagesToGifAnimation imagesToGifAnimation = new JunImagesToGifAnimation(aFile, aDimension);
		try {
			imagesToGifAnimation.do_(aBlock);
		} catch (IOException e) {
			e.printStackTrace();
		}
		return imagesToGifAnimation;
	}

	/**
	 * Create a new instance of JunImagesToGifAnimation and initialize it.
	 *
	 * @param aFile java.io.File
	 * @param aDimension java.awt.Dimension
	 * @category Instance creation
	 */
	public JunImagesToGifAnimation(File aFile, Dimension aDimension) {
		super();
		this.file_(aFile);
		this.extent_(aDimension);
	}

	/**
	 * Initialize the receiver.
	 * 
	 * @see jp.co.sra.jun.system.framework.JunAbstractObject#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();
		file = null;
		stream = null;
	}

	/**
	 * Answer my current file.
	 * 
	 * @return java.io.File
	 * @category accessing
	 */
	public File file() {
		return file;
	}

	/**
	 * Set my new file.
	 * 
	 * @param aFile java.io.File
	 * @category accessing
	 */
	public void file_(File aFile) {
		file = aFile;
	}

	/**
	 * Set my new dimension.
	 * 
	 * @param aDimension java.awt.Dimension
	 * @category accessing
	 */
	public void extent_(Dimension aDimension) {
		//
	}

	/**
	 * Add the image with the default millisecond duration time.
	 * 
	 * @param anImage jp.co.sra.smalltalk.StImage
	 * @category adding
	 */
	public void add_(StImage anImage) {
		this.add_milliseconds_(anImage, 125);
	}

	/**
	 * Add the image with the millisecond duration time.
	 * 
	 * @param anImage jp.co.sra.smalltalk.StImage
	 * @param durationTime int
	 * @category adding
	 */
	public void add_duration_(StImage anImage, int durationTime) {
		if (stream == null) {
			return;
		}

		stream.tick_(durationTime);
		try {
			stream.nextPutImage_(anImage);
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	/**
	 * Add the image with the millisecond duration time.
	 * 
	 * @param anImage jp.co.sra.smalltalk.StImage
	 * @param millisecondValue int
	 * @category adding
	 */
	public void add_milliseconds_(StImage anImage, int millisecondValue) {
		this.add_duration_(anImage, millisecondValue);
	}

	/**
	 * Add the image with the default millisecond duration time.
	 * 
	 * @param anImage jp.co.sra.smalltalk.StImage
	 * @category adding
	 */
	public void addImage_(StImage anImage) {
		this.add_(anImage);
	}

	/**
	 * Add the image with the specified frame ratio.
	 * 
	 * @param anImage jp.co.sra.smalltalk.StImage
	 * @param aNumber int
	 * @category adding
	 */
	public void addImage_framesPerSeconds_(StImage anImage, int aNumber) {
		this.addImage_keepTime_(anImage, 1000 / Math.min(Math.max(1, aNumber), 1000));
	}

	/**
	 * Add the image with the specified keeping time.
	 * 
	 * @param anImage jp.co.sra.smalltalk.StImage
	 * @param millisecondClockValue int
	 * @category adding
	 */
	public void addImage_keepTime_(StImage anImage, int millisecondClockValue) {
		this.add_milliseconds_(anImage, millisecondClockValue);
	}

	/**
	 * Enumerate the images and evaluate the block.
	 * 
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * @return java.lang.Object
	 * @throws java.io.IOException
	 * @category enumerating
	 */
	public Object do_(StBlockClosure aBlock) throws IOException {
		if (file == null) {
			return null;
		}

		try {
			stream = (JunGifAnimationStream) JunGifAnimationStream.On_(new FileOutputStream(file));
			stream.loop_(0);

			JunCursors cursor = new JunCursors(JunCursors.WriteCursor());
			try {
				cursor._show();

				if (aBlock.numArgs() == 0) {
					aBlock.value();
				} else {
					aBlock.value_(this);
				}
			} finally {
				cursor._restore();
			}
		} finally {
			if (stream != null) {
				stream.close();
				stream = null;
			}
		}
		return null;
	}
}
