package jp.co.sra.jun.goodies.misc;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;

import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StColorValue;
import jp.co.sra.smalltalk.StImage;
import jp.co.sra.smalltalk.SystemResourceSupport;

import jp.co.sra.jun.geometry.abstracts.JunGeometry;
import jp.co.sra.jun.geometry.abstracts.JunSurface;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.boundaries.Jun2dBoundingBox;
import jp.co.sra.jun.geometry.surfaces.Jun2dCircle;
import jp.co.sra.jun.geometry.surfaces.Jun2dPolygon;
import jp.co.sra.jun.geometry.surfaces.Jun2dTriangle;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;

/**
 * JunSampleTriangle class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2004/10/15 (by Mitsuhiro Asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun500 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunSampleTriangle.java,v 8.12 2008/02/20 06:31:49 nisinaka Exp $
 */
public class JunSampleTriangle extends JunSurface {
	protected Jun2dPoint firstPoint;
	protected Jun2dPoint secondPoint;
	protected Jun2dPoint thirdPoint;

	/**
	 * Answer the example image Aoki.
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Examples
	 */
	public static StImage Aoki() {
		double aScaleAmount = 10.0;
		Jun2dPoint aTranslateAmount = new Jun2dPoint(100, 100);

		// Hair&Beard
		Jun2dCircle aHairAndBeard = new Jun2dCircle(new Jun2dPoint(0, 0), 4.5);
		aHairAndBeard = aHairAndBeard.scaledBy_(aScaleAmount);
		aHairAndBeard = aHairAndBeard.translatedBy_(aTranslateAmount);
		// Face
		Jun2dCircle aFace = new Jun2dCircle(new Jun2dPoint(0, 0), 4);
		aFace = aFace.scaledBy_(aScaleAmount);
		aFace = aFace.translatedBy_(aTranslateAmount);
		// Ear
		JunSampleTriangle aRightEar = new JunSampleTriangle(new Jun2dPoint(0, 0), new Jun2dPoint(0, 2), new Jun2dPoint(-1, 0));
		aRightEar = aRightEar.translatedBy_(new Jun2dPoint(-4, 0));
		JunSampleTriangle aLeftEar = aRightEar.scaledBy_(new Jun2dPoint(-1, 1));
		aLeftEar = aLeftEar.scaledBy_(aScaleAmount);
		aRightEar = aRightEar.scaledBy_(aScaleAmount);
		aLeftEar = aLeftEar.translatedBy_(aTranslateAmount);
		aRightEar = aRightEar.translatedBy_(aTranslateAmount);
		// Eyebrow
		JunSampleTriangle aRightEyebrow = new JunSampleTriangle(new Jun2dPoint(0, 0), new Jun2dPoint(2, 0), new Jun2dPoint(0, 1));
		aRightEyebrow = aRightEyebrow.translatedBy_(new Jun2dPoint(-3, -2));
		JunSampleTriangle aLeftEyebrow = aRightEyebrow.scaledBy_(new Jun2dPoint(-1, 1));
		aLeftEyebrow = aLeftEyebrow.scaledBy_(aScaleAmount);
		aRightEyebrow = aRightEyebrow.scaledBy_(aScaleAmount);
		aLeftEyebrow = aLeftEyebrow.translatedBy_(aTranslateAmount);
		aRightEyebrow = aRightEyebrow.translatedBy_(aTranslateAmount);
		// Eye
		Jun2dCircle aRightEye = new Jun2dCircle(new Jun2dPoint(0, 0), 0.75);
		Jun2dCircle aRightEyeShine = new Jun2dCircle(new Jun2dPoint(0, 0), 0.25);
		aRightEye = aRightEye.translatedBy_(new Jun2dPoint(-2, 0));
		aRightEyeShine = aRightEyeShine.translatedBy_(new Jun2dPoint(-2, -0.25));
		Jun2dCircle aLeftEye = aRightEye.scaledBy_(new Jun2dPoint(-1, 1));
		Jun2dCircle aLeftEyeShine = aRightEyeShine.scaledBy_(new Jun2dPoint(-1, 1));
		aRightEye = aRightEye.scaledBy_(aScaleAmount);
		aRightEye = aRightEye.translatedBy_(aTranslateAmount);
		aLeftEye = aLeftEye.scaledBy_(aScaleAmount);
		aLeftEye = aLeftEye.translatedBy_(aTranslateAmount);
		aRightEyeShine = aRightEyeShine.scaledBy_(aScaleAmount);
		aRightEyeShine = aRightEyeShine.translatedBy_(aTranslateAmount);
		aLeftEyeShine = aLeftEyeShine.scaledBy_(aScaleAmount);
		aLeftEyeShine = aLeftEyeShine.translatedBy_(aTranslateAmount);
		// Nose
		JunSampleTriangle aNose = new JunSampleTriangle(new Jun2dPoint(0, 0), new Jun2dPoint(1, 2), new Jun2dPoint(-1, 2));
		aNose = aNose.scaledBy_(aScaleAmount);
		aNose = aNose.translatedBy_(aTranslateAmount);
		// Mustache
		JunSampleTriangle aMustache = new JunSampleTriangle(new Jun2dPoint(0, -0.5), new Jun2dPoint(2, 1), new Jun2dPoint(-2, 1));
		aMustache = aMustache.translatedBy_(new Jun2dPoint(0, 2));
		aMustache = aMustache.scaledBy_(aScaleAmount);
		aMustache = aMustache.translatedBy_(aTranslateAmount);
		// Mouth
		Jun2dCircle aMouth = new Jun2dCircle(new Jun2dPoint(0, 0), 1);
		aMouth = aMouth.translatedBy_(new Jun2dPoint(0, 3));
		aMouth = aMouth.scaledBy_(aScaleAmount);
		aMouth = aMouth.translatedBy_(aTranslateAmount);
		// Mole
		Jun2dCircle aMole1 = new Jun2dCircle(new Jun2dPoint(0, 0), 0.05);
		Jun2dCircle aMole2 = aMole1.translatedBy_(new Jun2dPoint(2, 2));
		aMole2 = aMole2.scaledBy_(aScaleAmount);
		aMole2 = aMole2.translatedBy_(aTranslateAmount);
		aMole1 = aMole1.translatedBy_(new Jun2dPoint(-0.15, 1));
		aMole1 = aMole1.scaledBy_(aScaleAmount);
		aMole1 = aMole1.translatedBy_(aTranslateAmount);
		// Back
		Jun2dBoundingBox aRectangle = new Jun2dPoint(-5, -5).corner_(new Jun2dPoint(5, 5));
		aRectangle = aRectangle.scaledBy_(aScaleAmount + 1);
		aRectangle = aRectangle.translatedBy_(aTranslateAmount);

		final Boolean asFiller = Boolean.TRUE;
		final Boolean asStroker = Boolean.FALSE;

		StImage aCompositePart = new StImage((int) Math.ceil(aRectangle.width()), (int) Math.ceil(aRectangle.height()));
		final Graphics2D aGraphics = (Graphics2D) aCompositePart.image().getGraphics();
		try {
			aGraphics.translate(-aRectangle.origin().x(), -aRectangle.origin().y());

			StBlockClosure aBlock = new StBlockClosure() {
				public Object value_value_value_(Object obj1, Object obj2, Object obj3) {
					JunGeometry aGeometry = (JunGeometry) obj1;
					boolean isFiller = obj2 == asFiller;
					Color colorValue = (Color) obj3;

					Shape aShape = null;
					if (aGeometry.isBoundingBox()) {
						Jun2dBoundingBox box = (Jun2dBoundingBox) aGeometry;
						aShape = new Rectangle2D.Double(box.origin().x(), box.origin().y(), box.extent().x(), box.extent().y());
					} else if (aGeometry.isCircle()) {
						Jun2dCircle circle = (Jun2dCircle) aGeometry;
						aShape = new Ellipse2D.Double(circle.center().x() - circle.radius(), circle.center().y() - circle.radius(), Math.max(2, circle.radius() * 2), Math.max(2, circle.radius() * 2));
					} else if (aGeometry instanceof JunSampleTriangle) {
						JunSampleTriangle triangle = (JunSampleTriangle) aGeometry;
						GeneralPath aPath = new GeneralPath();
						aPath.moveTo((float) triangle.first().x(), (float) triangle.first().y());
						aPath.lineTo((float) triangle.second().x(), (float) triangle.second().y());
						aPath.lineTo((float) triangle.third().x(), (float) triangle.third().y());
						aPath.lineTo((float) triangle.first().x(), (float) triangle.first().y());
						aShape = aPath;
					}
					if (aShape != null) {
						aGraphics.setColor(colorValue);
						if (isFiller) {
							aGraphics.fill(aShape);
						} else {
							aGraphics.draw(aShape);
						}
					}
					return null;
				}
			};

			aBlock.value_value_value_(aRectangle, asFiller, Color.blue);
			aBlock.value_value_value_(aHairAndBeard, asFiller, Color.black);
			aBlock.value_value_value_(aFace, asFiller, StColorValue.Orange);
			aBlock.value_value_value_(aLeftEar, asFiller, StColorValue.Orange);
			aBlock.value_value_value_(aRightEar, asFiller, StColorValue.Orange);
			aBlock.value_value_value_(aLeftEyebrow, asFiller, Color.black);
			aBlock.value_value_value_(aRightEyebrow, asFiller, Color.black);
			aBlock.value_value_value_(aLeftEye, asFiller, Color.black);
			aBlock.value_value_value_(aRightEye, asFiller, Color.black);
			aBlock.value_value_value_(aLeftEyeShine, asFiller, Color.white);
			aBlock.value_value_value_(aRightEyeShine, asFiller, Color.white);
			aBlock.value_value_value_(aMouth, asFiller, Color.red);
			aBlock.value_value_value_(aMustache, asFiller, Color.black);
			aBlock.value_value_value_(aNose, asFiller, StColorValue.Orange);
			aBlock.value_value_value_(aNose, asStroker, Color.black);
			aBlock.value_value_value_(aMole1, asFiller, Color.black);
			aBlock.value_value_value_(aMole2, asFiller, Color.black);
		} finally {
			if (aGraphics != null) {
				aGraphics.dispose();
			}
		}
		return aCompositePart;
	}

	/**
	 * Answer the example image Mickey.
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Examples
	 */
	public static StImage Mickey() {
		return new StImage(SystemResourceSupport.createImage("/jp/co/sra/jun/goodies/misc/ExampleMickey.gif"));
	}

	/**
	 * Answer the bounding rectangle for points.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.Jun2dBoundingBox
	 * @category Geometric functions
	 */
	public static Jun2dBoundingBox BoundingRectangleForPoints_(Jun2dPoint[] arrayOfPoints) {
		Jun2dPoint origin = arrayOfPoints[0];
		Jun2dPoint corner = arrayOfPoints[0];
		for (int i = 1; i < arrayOfPoints.length; i++) {
			Jun2dPoint v = arrayOfPoints[i];
			origin = origin.min_(v);
			corner = corner.max_(v);
		}
		return Jun2dBoundingBox.Origin_corner_(origin, corner);
	}

	/**
	 * Create a new instance of JunSampleTriangle and initialize it.
	 * 
	 * @param aPoint1 jp.co.sra.jun.geometry.basic.Jun2dPoint
	 * @param aPoint2 jp.co.sra.jun.geometry.basic.Jun2dPoint
	 * @param aPoint3 jp.co.sra.jun.geometry.basic.Jun2dPoint
	 * @category Instance creation
	 */
	public JunSampleTriangle(Jun2dPoint aPoint1, Jun2dPoint aPoint2, Jun2dPoint aPoint3) {
		super();
		this.setFirst_setSecond_setThird_(aPoint1, aPoint2, aPoint3);
	}

	/**
	 * Create a new instance of JunSampleTriangle and initialize it.
	 * 
	 * @return jp.co.sra.jun.goodies.misc.JunSampleTriangle
	 * @param aPoint1 jp.co.sra.jun.geometry.basic.Jun2dPoint
	 * @param aPoint2 jp.co.sra.jun.geometry.basic.Jun2dPoint
	 * @param aPoint3 jp.co.sra.jun.geometry.basic.Jun2dPoint
	 * @deprecated use the constructor
	 * @category Instance creation
	 */
	public static JunSampleTriangle First_second_third_(Jun2dPoint aPoint1, Jun2dPoint aPoint2, Jun2dPoint aPoint3) {
		return new JunSampleTriangle(aPoint1, aPoint2, aPoint3);
	}

	/**
	 * Answer the size of area
	 * 
	 * @return double
	 * @see jp.co.sra.jun.geometry.abstracts.JunGeometry#area()
	 * @category accessing
	 */
	public double area() {
		return Math.abs(this.areaWithSign());
	}

	/**
	 * Answer the size of area with sign.
	 * 
	 * @return double
	 * @category accessing
	 */
	public double areaWithSign() {
		double areaWithSign = 0.0d;
		areaWithSign += (this.first().x() - this.second().x()) * (this.first().y() + this.second().y());
		areaWithSign += (this.second().x() - this.third().x()) * (this.second().y() + this.third().y());
		areaWithSign += (this.third().x() - this.first().x()) * (this.third().y() + this.first().y());
		areaWithSign = areaWithSign / 2;
		return areaWithSign;
	}

	/**
	 * Answer the size of area
	 * 
	 * @return jp.co.sra.jun.geometry.basic.Jun2dBoundingBox
	 * @category accessing
	 */
	public Jun2dBoundingBox bounds() {
		return BoundingRectangleForPoints_(this.asPointArray());
	}

	/**
	 * Get the first point.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.Jun2dPoint
	 * @category accessing
	 */
	public Jun2dPoint first() {
		return firstPoint;
	}

	/**
	 * Get the second point.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.Jun2dPoint
	 * @category accessing
	 */
	public Jun2dPoint second() {
		return secondPoint;
	}

	/**
	 * Get the third point.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.Jun2dPoint
	 * @category accessing
	 */
	public Jun2dPoint third() {
		return thirdPoint;
	}

	/**
	 * Answer <code>true</code> if the receiver is equal to the object while concerning an accuracy.
	 * 
	 * @param anObject java.lang.Object
	 * @return boolean
	 * @see jp.co.sra.jun.geometry.abstracts.JunGeometry#equal_(java.lang.Object)
	 * @category comparing
	 */
	public boolean equal_(Object anObject) {
		if (anObject == null || this.getClass() != anObject.getClass()) {
			return false;
		}

		JunSampleTriangle aTriangle = (JunSampleTriangle) anObject;
		return this.first().equal_(aTriangle.first()) && this.second().equal_(aTriangle.second()) && this.third().equal_(aTriangle.third());
	}

	/**
	 * Answer <code>true</code> if the receiver is equal to the object.
	 * 
	 * @return boolean
	 * @param anObject java.lang.Object
	 * @see java.lang.Object#equals(java.lang.Object)
	 * @category comparing
	 */
	public boolean equals(Object anObject) {
		if (anObject == null || this.getClass() != anObject.getClass()) {
			return false;
		}

		JunSampleTriangle aTriangle = (JunSampleTriangle) anObject;
		return this.first().equals(aTriangle.first()) && this.second().equals(aTriangle.second()) && this.third().equals(aTriangle.third());
	}

	/**
	 * Convert to a JunOpenGL3dObject.
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @see jp.co.sra.jun.geometry.abstracts.JunGeometry#asJunOpenGL3dObject()
	 * @category converting
	 */
	public JunOpenGL3dObject asJunOpenGL3dObject() {
		return new Jun2dTriangle(this.first(), this.second(), this.third()).asJunOpenGL3dObject();
	}

	/**
	 * Answer the array of this points.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.Jun2dPoint[4]
	 * @category converting
	 */
	public Jun2dPoint[] asPointArray() {
		Jun2dPoint[] anArray = new Jun2dPoint[4];
		anArray[0] = this.first();
		anArray[1] = this.second();
		anArray[2] = this.third();
		anArray[3] = this.first();
		return anArray;
	}

	/**
	 * Converting the aJun3dPolygon, and answer it.
	 * 
	 * @return jp.co.sra.jun.geometry.surfaces.Jun3dPolygon
	 * @category converting
	 */
	public Jun2dPolygon asPolyline() {
		return new Jun2dPolygon(this.asPointArray());
	}

	/**
	 * Display filled this triangle.
	 * 
	 * @param aGraphicsContext
	 * @category displaying
	 */
	public void displayFilledOn_(Graphics aGraphicsContext) {
		Jun2dPoint[] points = this.asPointArray();
		int nPoints = points.length;
		int xPoints[] = new int[nPoints];
		int yPoints[] = new int[nPoints];
		for (int i = 0; i < nPoints; i++) {
			xPoints[i] = (int) Math.round(points[i].x());
			yPoints[i] = (int) Math.round(points[i].y());
		}
		aGraphicsContext.fillPolygon(xPoints, yPoints, nPoints);
	}

	/**
	 * Display stroked this triangle.
	 * 
	 * @param aGraphicsContext
	 * @category displaying
	 */
	public void displayStrokedOn_(Graphics aGraphicsContext) {
		Jun2dPoint[] points = this.asPointArray();
		int nPoints = points.length;
		int xPoints[] = new int[nPoints];
		int yPoints[] = new int[nPoints];
		for (int i = 0; i < nPoints; i++) {
			xPoints[i] = (int) Math.round(points[i].x());
			yPoints[i] = (int) Math.round(points[i].y());
		}
		aGraphicsContext.drawPolyline(xPoints, yPoints, nPoints);
	}

	/**
	 * Answer the new JunSampleTriangle which is scaled by argument, amount.
	 * 
	 * @param amount double
	 * @return jp.co.sra.jun.goodies.misc.JunSampleTriangle
	 * @category transforming
	 */
	public JunSampleTriangle scaledBy_(double amount) {
		return new JunSampleTriangle(this.first().scaledBy_(amount), this.second().scaledBy_(amount), this.third().scaledBy_(amount));
	}

	/**
	 * Answer the new JunSampleTriangle which is scaled by argument, amount.
	 * 
	 * @param amount jp.co.sra.jun.geometry.basic.Jun2dPoint
	 * @return jp.co.sra.jun.goodies.misc.JunSampleTriangle
	 * @category transforming
	 */
	public JunSampleTriangle scaledBy_(Jun2dPoint amount) {
		return new JunSampleTriangle(this.first().scaledBy_(amount), this.second().scaledBy_(amount), this.third().scaledBy_(amount));
	}

	/**
	 * Answer the new JunSampleTriangle which is translated by argument, amount.
	 * 
	 * @param amount double
	 * @return jp.co.sra.jun.goodies.misc.JunSampleTriangle
	 * @category transforming
	 */
	public JunSampleTriangle translatedBy_(double amount) {
		return new JunSampleTriangle(this.first().translatedBy_(amount), this.second().translatedBy_(amount), this.third().translatedBy_(amount));
	}

	/**
	 * Answer the new JunSampleTriangle which is translated by argument, amount.
	 * 
	 * @param amount jp.co.sra.jun.geometry.basic.Jun2dPoint
	 * @return jp.co.sra.jun.goodies.misc.JunSampleTriangle
	 * @category transforming
	 */
	public JunSampleTriangle translatedBy_(Jun2dPoint amount) {
		return new JunSampleTriangle(this.first().translatedBy_(amount), this.second().translatedBy_(amount), this.third().translatedBy_(amount));
	}

	/**
	 * Set the my points.
	 * 
	 * @param aPoint1 jp.co.sra.jun.geometry.basic.Jun2dPoint
	 * @param aPoint2 jp.co.sra.jun.geometry.basic.Jun2dPoint
	 * @param aPoint3 jp.co.sra.jun.geometry.basic.Jun2dPoint
	 * @category private
	 */
	protected void setFirst_setSecond_setThird_(Jun2dPoint aPoint1, Jun2dPoint aPoint2, Jun2dPoint aPoint3) {
		firstPoint = aPoint1;
		secondPoint = aPoint2;
		thirdPoint = aPoint3;
	}
}
