package jp.co.sra.jun.goodies.milliseconds;

import java.awt.Point;
import java.awt.event.MouseEvent;
import jp.co.sra.smalltalk.StRectangle;
import jp.co.sra.smalltalk.StSymbol;
import jp.co.sra.jun.system.framework.JunAbstractController;
import jp.co.sra.jun.system.framework.JunDialog;
import jp.co.sra.jun.system.support.JunSystem;

/**
 * JunMillisecondController class
 * 
 *  @author    nisinaka
 *  @created   2003/05/28 (by nisinaka)
 *  @updated   2004/09/21 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun473 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunMillisecondController.java,v 8.11 2008/02/20 06:31:49 nisinaka Exp $
 */
public class JunMillisecondController extends JunAbstractController {

	protected boolean _mousePressed;

	/**
	 * Answer my model as JunMillisecondModel.
	 *
	 * @return jp.co.sra.jun.goodies.milliseconds.JunMillisecondModel
	 * @category model accessing
	 */
	public JunMillisecondModel getMillisecondModel() {
		return (JunMillisecondModel) this.model();
	}

	/**
	 * Answer my view as JunMillisecondView.
	 *
	 * @return jp.co.sra.jun.goodies.milliseconds.JunMillisecondView
	 * @category view accessing
	 */
	public JunMillisecondView getMillisecondView() {
		return (JunMillisecondView) this.view();
	}

	/**
	 * Invoked when a mouse button has been pressed on a component.
	 * 
	 * @param e java.awt.event.MouseEvent
	 * @see jp.co.sra.smalltalk.StController#mousePressed(java.awt.event.MouseEvent)
	 * @category mouse events
	 */
	public void mousePressed(MouseEvent e) {
		if (e.isMetaDown()) {
			// yellow button activity
			this.view()._showPopupMenu(e.getX(), e.getY());
		} else {
			// red button activity
			this.frameActivity();
		}
	}

	/**
	 * Invoked when a mouse button has been released on a component.
	 * 
	 * @param e java.awt.event.MouseEvent
	 * @see jp.co.sra.smalltalk.StController#mouseReleased(java.awt.event.MouseEvent)
	 * @category mouse events
	 */
	public void mouseReleased(MouseEvent e) {
		_mousePressed = false;
		synchronized (this) {
			this.notify(); // to stop the thread for auto repeating.
		}
	}

	/**
	 * Activity for a button.
	 *
	 * @param aFrameInfo jp.co.sra.jun.goodies.milliseconds.JunMillisecondView.FrameInfo
	 * @category activities
	 */
	protected void buttonActivity_(JunMillisecondView.FrameInfo aFrameInfo) {
		StSymbol subkey = aFrameInfo.subkey();
		if (subkey == $("hourDown")) {
			this.getMillisecondModel().hourDown();
		} else if (subkey == $("hourUp")) {
			this.getMillisecondModel().hourUp();
		} else if (subkey == $("minuteDown")) {
			this.getMillisecondModel().minuteDown();
		} else if (subkey == $("minuteUp")) {
			this.getMillisecondModel().minuteUp();
		} else if (subkey == $("secondDown")) {
			this.getMillisecondModel().secondDown();
		} else if (subkey == $("secondUp")) {
			this.getMillisecondModel().secondUp();
		} else if (subkey == $("msecDown")) {
			this.getMillisecondModel().msecDown();
		} else if (subkey == $("msecUp")) {
			this.getMillisecondModel().msecUp();
		}
	}

	/**
	 * Activity for the frame.
	 * 
	 * @category activities
	 */
	protected void frameActivity() {
		Point point = this.cursorPoint();
		JunMillisecondView.FrameInfo[] info = this.getMillisecondView().frames();
		for (int i = 0; i < info.length; i++) {
			StRectangle box = info[i].box();
			if (box.containsPoint_(point)) {
				StSymbol key = info[i].key();
				if (key == $("hours")) {
					this.hoursActivity_(info[i]);
				} else if (key == $("minutes")) {
					this.minutesActivity_(info[i]);
				} else if (key == $("seconds")) {
					this.secondsActivity_(info[i]);
				} else if (key == $("msecs")) {
					this.msecsActivity_(info[i]);
				} else if (key == $("label")) {
					this.labelActivity_(info[i]);
				} else if (key == $("button")) {
					this.buttonActivity_(info[i]);

					_mousePressed = true;
					final JunMillisecondController this_ = this;
					final JunMillisecondView.FrameInfo info_ = info[i];
					(new Thread() {
						public void run() {
							try {
								synchronized (this_) {
									this_.wait(1000);
								}
								while (_mousePressed) {
									this_.buttonActivity_(info_);
									Thread.sleep(50);
								}
							} catch (InterruptedException e) {
							}
						}
					}).start();
				}
			}
		}
	}

	/**
	 * Activity for the hours.
	 *
	 * @param aFrameInfo jp.co.sra.jun.goodies.milliseconds.JunMillisecondView.FrameInfo
	 * @category activities
	 */
	protected void hoursActivity_(JunMillisecondView.FrameInfo aFrameInfo) {
		String aString = JunDialog.Request_(JunSystem.$String("Hours?"), String.valueOf(this.getMillisecondModel().hours()));
		if (aString.length() == 0) {
			return;
		}

		StringBuffer digits = new StringBuffer();
		for (int i = 0; i < aString.length(); i++) {
			char c = aString.charAt(i);
			if (Character.isDigit(c)) {
				digits.append(c);
			}
		}
		aString = digits.toString();
		if (aString.length() == 0) {
			return;
		}

		this.getMillisecondModel().hours_(Integer.parseInt(aString));
	}

	/**
	 * Activity for a label.
	 *
	 * @param aFrameInfo jp.co.sra.jun.goodies.milliseconds.JunMillisecondView.FrameInfo
	 * @category activities
	 */
	protected void labelActivity_(JunMillisecondView.FrameInfo aFrameInfo) {
		// Nothing to do.
	}

	/**
	 * Activity for the minutes.
	 *
	 * @param aFrameInfo jp.co.sra.jun.goodies.milliseconds.JunMillisecondView.FrameInfo
	 * @category activities
	 */
	protected void minutesActivity_(JunMillisecondView.FrameInfo aFrameInfo) {
		String aString = JunDialog.Request_(JunSystem.$String("Minutes?"), String.valueOf(this.getMillisecondModel().minutes()));
		if (aString.length() == 0) {
			return;
		}

		StringBuffer digits = new StringBuffer();
		for (int i = 0; i < aString.length(); i++) {
			char c = aString.charAt(i);
			if (Character.isDigit(c)) {
				digits.append(c);
			}
		}
		aString = digits.toString();
		if (aString.length() == 0) {
			return;
		}

		this.getMillisecondModel().minutes_(Integer.parseInt(aString));
	}

	/**
	 * Activity for the msecs.
	 *
	 * @param aFrameInfo jp.co.sra.jun.goodies.milliseconds.JunMillisecondView.FrameInfo
	 * @category activities
	 */
	protected void msecsActivity_(JunMillisecondView.FrameInfo aFrameInfo) {
		String aString = JunDialog.Request_(JunSystem.$String("Milliseconds?"), String.valueOf(this.getMillisecondModel().msecs()));
		if (aString.length() == 0) {
			return;
		}

		StringBuffer digits = new StringBuffer();
		for (int i = 0; i < aString.length(); i++) {
			char c = aString.charAt(i);
			if (Character.isDigit(c)) {
				digits.append(c);
			}
		}
		aString = digits.toString();
		if (aString.length() == 0) {
			return;
		}

		this.getMillisecondModel().msecs_(Integer.parseInt(aString));
	}

	/**
	 * Activity for the seconds.
	 *
	 * @param aFrameInfo jp.co.sra.jun.goodies.milliseconds.JunMillisecondView.FrameInfo
	 * @category activities
	 */
	protected void secondsActivity_(JunMillisecondView.FrameInfo aFrameInfo) {
		String aString = JunDialog.Request_(JunSystem.$String("Seconds?"), String.valueOf(this.getMillisecondModel().seconds()));
		if (aString.length() == 0) {
			return;
		}

		StringBuffer digits = new StringBuffer();
		for (int i = 0; i < aString.length(); i++) {
			char c = aString.charAt(i);
			if (Character.isDigit(c)) {
				digits.append(c);
			}
		}
		aString = digits.toString();
		if (aString.length() == 0) {
			return;
		}

		this.getMillisecondModel().seconds_(Integer.parseInt(aString));
	}

}
