package jp.co.sra.jun.goodies.meter;

import java.util.ArrayList;
import java.util.Collection;

import jp.co.sra.smalltalk.StView;

import jp.co.sra.jun.goodies.gauge.JunLevelGaugeModel;
import jp.co.sra.jun.system.support.JunSystem;

/**
 * JunLevelGaugeMeter class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2007/04/04 (by m-asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun652 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunLevelGaugeMeter.java,v 8.6 2008/02/20 06:31:49 nisinaka Exp $
 */
public class JunLevelGaugeMeter extends JunAbstractGaugeMeter {
	protected Collection levelGauges;

	/**
	 * Create a new instance of <code>JunLevelGaugeMeter</code> and initialize it.
	 * 
	 * @param numberOfGauges int
	 * @category Instance creation
	 */
	public JunLevelGaugeMeter(int numberOfGauges) {
		super(numberOfGauges);
	}

	/**
	 * Create a new instance of <code>JunLevelGaugeMeter</code> and initialize it.
	 * 
	 * @param numberOfGauges int
	 * @param value double
	 * @param maximum double
	 * @param minimum double
	 * @category Instance creation
	 */
	public JunLevelGaugeMeter(int numberOfGauges, double value, double maximum, double minimum) {
		super(numberOfGauges, value, maximum, minimum);
	}

	/**
	 * Create a new instance of <code>JunLevelGaugeMeter</code> and initialize it.
	 * 
	 * @param numberOfGauges int
	 * @param valueCollection double[]
	 * @param maximumCollection double[]
	 * @param minimumCollection double[]
	 * @category Instance creation
	 */
	public JunLevelGaugeMeter(int numberOfGauges, double[] valueCollection, double[] maximumCollection, double[] minimumCollection) {
		super(numberOfGauges, valueCollection, maximumCollection, minimumCollection);
	}

	/**
	 * Initialize the receiver with the specified values.
	 * 
	 * @param numberOfGauges int
	 * @param valueCollection double[]
	 * @param maximumCollection double[]
	 * @param minimumCollection double[]
	 * @see jp.co.sra.jun.goodies.meter.JunAbstractGaugeMeter#initialize_values_maximumx_minimums_(int, double[], double[], double[])
	 * @category initialize-release
	 */
	protected void initialize_values_maximumx_minimums_(int numberOfGauges, double[] valueCollection, double[] maximumCollection, double[] minimumCollection) {
		int howMany = Math.max(0, Math.min(numberOfGauges, MaximumNumberOfGauges));
		levelGauges = new ArrayList(howMany);
		for (int i = 0; i < howMany; i++) {
			try {
				Object[] arguments = new Object[] { new Double(valueCollection[i]), new Double(maximumCollection[i]), new Double(minimumCollection[i]) };
				JunLevelGaugeModel levelGauge = (JunLevelGaugeModel) _PerformWithArguments(this.defaultLevelGaugeClass(), "Value_maximum_minimum_", arguments);
				levelGauges.add(levelGauge);
			} catch (NoSuchMethodException e) {
				System.out.println(e.getMessage());
			}
		}
	}

	/**
	 * Answer the receiver's gauges
	 * 
	 * @return jp.co.sra.jun.goodies.gauge.JunLevelGaugeModel[]
	 * @see jp.co.sra.jun.goodies.meter.JunAbstractGaugeMeter#gauges()
	 * @category accessing
	 */
	public JunLevelGaugeModel[] gauges() {
		return (JunLevelGaugeModel[]) levelGauges.toArray(new JunLevelGaugeModel[levelGauges.size()]);
	}

	/**
	 * Answer a default view.
	 * 
	 * @return jp.co.sra.smalltalk.StView
	 * @see jp.co.sra.smalltalk.StApplicationModel#defaultView()
	 * @category defaults
	 */
	public StView defaultView() {
		if (GetDefaultViewMode() == VIEW_AWT) {
			return new JunLevelGaugeMeterViewAwt(this);
		} else {
			return new JunLevelGaugeMeterViewSwing(this);
		}
	}

	/**
	 * Answer a window title.
	 *
	 * @return java.lang.String
	 * @see jp.co.sra.smalltalk.StApplicationModel#windowTitle()
	 * @category interface opening
	 */
	protected String windowTitle() {
		return JunSystem.$String("Level Gauge Meter");
	}
}
