package jp.co.sra.jun.goodies.meter;

import java.awt.Component;

import javax.swing.JPanel;

import jp.co.sra.smalltalk.WindowSpecLayout;

import jp.co.sra.jun.goodies.gauge.JunLevelGaugeModel;
import jp.co.sra.jun.goodies.gauge.JunLevelGaugeViewSwing;
import jp.co.sra.jun.system.framework.JunAbstractViewJPanel;

/**
 * JunAbstractGaugeMeterViewSwing class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2007/04/04 (by m-asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun652 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunAbstractGaugeMeterViewSwing.java,v 8.6 2008/02/20 06:31:49 nisinaka Exp $
 */
public abstract class JunAbstractGaugeMeterViewSwing extends JunAbstractViewJPanel implements JunAbstractGaugeMeterView {
	/**
	 * Create a new instance of <code>JunAbstractGaugeMeterViewSwing</code> and initialize it.
	 * 
	 * @category Instance creation
	 */
	public JunAbstractGaugeMeterViewSwing() {
		super();
	}

	/**
	 * Create a new instance of <code>JunAbstractGaugeMeterViewSwing</code> and initialize it.
	 * 
	 * @param aMeter jp.co.sra.jun.goodies.meter.JunAbstractGaugeMeter
	 * @category Instance creation
	 */
	public JunAbstractGaugeMeterViewSwing(JunAbstractGaugeMeter aMeter) {
		super(aMeter);
	}

	/**
	 * Answer the meter view with the specified gauges.
	 * 
	 * @param gauges jp.co.sra.jun.goodies.gauge.JunLevelGaugeModel[]
	 * @return java.awt.Component
	 * @category interface opening
	 */
	protected Component meterView_(JunLevelGaugeModel[] gauges) {
		JPanel meterView = new JPanel();
		meterView.setLayout(new WindowSpecLayout());

		boolean verticalGauge = gauges[0].verticalGauge();
		float deltaPosition = 1.0f / gauges.length;
		for (int i = 0; i < gauges.length; i++) {
			JunLevelGaugeViewSwing gaugeView = new JunLevelGaugeViewSwing(gauges[i]);
			if (verticalGauge) {
				meterView.add(gaugeView, WindowSpecLayout.Position(deltaPosition * i, 0, 0f, 0, deltaPosition * (i + 1), 0, 1f, 0));
			} else {
				meterView.add(gaugeView, WindowSpecLayout.Position(0f, 0, deltaPosition * i, 0, 1f, 0, deltaPosition * (i + 1), 0));
			}
		}
		return meterView;
	}

	/**
	 * Answer the receiver's model as JunAbstractGaugeMeter
	 * 
	 * @return jp.co.sra.jun.goodies.meter.JunAbstractGaugeMeter
	 * @see jp.co.sra.jun.goodies.meter.JunAbstractGaugeMeterView#getModel()
	 * @category model accessing
	 */
	public JunAbstractGaugeMeter getModel() {
		return (JunAbstractGaugeMeter) this.model();
	}
}
