package jp.co.sra.jun.goodies.lisp;

import java.util.Comparator;
import java.util.HashMap;
import java.util.TreeSet;

import jp.co.sra.smalltalk.SmalltalkException;

import jp.co.sra.jun.system.framework.JunAbstractObject;

/**
 * JunLispTable class
 * 
 *  @author    ASTI Beijing
 *  @created   1998/12/09 (by ASTI Beijing)
 *  @updated   2007/06/28 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun697 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunLispTable.java,v 8.13 2008/02/20 06:31:49 nisinaka Exp $
 */
public class JunLispTable extends JunAbstractObject {

	/** The hashtable which holds the properties. */
	protected HashMap properties;

	/**
	 * Create a new instance of JunLispTable.
	 * 
	 * @category Instance creation
	 */
	public JunLispTable() {
		super();
	}

	/**
	 * Initialize the receiver.
	 * 
	 * @see jp.co.sra.jun.system.framework.JunAbstractObject#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();
		properties = new HashMap();
	}

	/**
	 * Answer the property which corresponds to the object.
	 * 
	 * @param symbol jp.co.sra.smalltalk.StSymbol
	 * @return java.lang.Object
	 * @category accessing
	 */
	public Object at_(Object symbol) {
		return this.getprop_key_(symbol, $("apval"));
	}

	/**
	 * Set the value as a property which is specified with the symbol.
	 * 
	 * @param symbol java.lang.Object
	 * @param value java.lang.Object
	 * @return java.lang.Object
	 * @category accessing
	 */
	public Object at_put_(Object symbol, Object value) {
		this.intern_(symbol);
		return this.putprop_key_value_(symbol, $("apval"), value);
	}

	/**
	 * Answer the array of all identifiers.
	 * 
	 * @return java.lang.Object[]
	 * @category accessing
	 */
	public Object[] identifiers() {
		TreeSet aTreeSet = new TreeSet(new Comparator() {
			public int compare(Object arg0, Object arg1) {
				return arg0.toString().compareTo(arg1.toString());
			}
		});
		aTreeSet.add(properties.keySet());
		return aTreeSet.toArray();
	}

	/**
	 * Create a new property which is specified with the symbol.
	 * 
	 * @param symbol java.lang.Object
	 * @category adding
	 */
	public void add_(Object symbol) {
		this.intern_(symbol);
	}

	/**
	 * Remove the property which is specified with the symbol.
	 * 
	 * @param symbol java.lang.Object
	 * @return java.lang.Object
	 * @category removing
	 */
	public Object remove_(Object symbol) {
		return properties.remove(symbol);
	}

	/**
	 * Answer the property which is specified with the identifier and the key.
	 * 
	 * @param identifier java.lang.Object
	 * @param key java.lang.Object
	 * @return java.lang.Object
	 * @category property access
	 */
	public Object getprop_key_(Object identifier, Object key) {
		HashMap property = (HashMap) properties.get(identifier);
		if (property == null) {
			this.errorSymbolNotFound();
			return null;
		}

		return property.get(key);
	}

	/**
	 * Set the property which is specified with the identifier and the key.
	 * 
	 * @param identifier java.lang.Object
	 * @param key java.lang.Object
	 * @param value java.lang.Object
	 * @return java.lang.Object
	 * @category property access
	 */
	public Object putprop_key_value_(Object identifier, Object key, Object value) {
		HashMap property = (HashMap) properties.get(identifier);
		if (property == null) {
			this.errorSymbolNotFound();
			return null;
		}

		return property.put(key, value);
	}

	/**
	 * Remove the property which is specified with the identifier and the key.
	 * 
	 * @param identifier java.lang.Object
	 * @param key java.lang.Object
	 * @return java.lang.Object
	 * @category property access
	 */
	public Object remprop_key_(Object identifier, Object key) {
		HashMap property = (HashMap) properties.get(identifier);
		if (property == null) {
			this.errorSymbolNotFound();
			return null;
		}

		return property.remove(key);
	}

	/**
	 * Throw a runtime exception to nofity an error.
	 * 
	 * @category private
	 */
	protected void errorSymbolNotFound() {
		throw SmalltalkException.Error("symbol not found");
	}

	/**
	 * Register the symbol as an intern.
	 * 
	 * @param symbol java.lang.Object
	 * @return java.lang.Object
	 * @category private
	 */
	protected Object intern_(Object symbol) {
		if (properties.containsKey(symbol) == false) {
			properties.put(symbol, new HashMap());
		}
		return symbol;
	}

}
