package jp.co.sra.jun.goodies.lisp;

import jp.co.sra.smalltalk.*;

/**
 * JunLispScannerTable class
 * 
 *  @author    ASTI Beijing
 *  @created   1998/12/09 (by ASTI Beijing)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunLispScannerTable.java,v 8.10 2008/02/20 06:31:49 nisinaka Exp $
 */
public class JunLispScannerTable extends StObject {

	/** The single instance of JunLispScannerTable. */
	protected static JunLispScannerTable ScanningTable;

	/** The array which holds the scanner table. */
	protected static StSymbol[] _ScanningTable = null;

	/**
	 * Initialize the scanner table.
	 * 
	 * @return jp.co.sra.jun.goodies.lisp.JunLispScannerTable
	 */
	public static JunLispScannerTable ScannerTable() {
		if (_ScanningTable == null) {
			_ScanningTable = new StSymbol[257];
			for (int index = 1; index <= 256; index++) {
				_ScanningTable[index] = $("xBinary");
			}
			_ScanningTable[9] = $("xDelimiter");
			_ScanningTable[10] = $("xDelimiter");
			_ScanningTable[11] = $("xDelimiter");
			_ScanningTable[12] = $("xDelimiter");
			_ScanningTable[13] = $("xDelimiter");
			_ScanningTable[32] = $("xDelimiter");
			for (int index = '0'; index <= '9'; index++) {
				_ScanningTable[index] = $("xDigit");
			}
			for (int index = 'A'; index <= 'Z'; index++) {
				_ScanningTable[index] = $("xSymbol");
			}
			for (int index = 'a'; index <= 'z'; index++) {
				_ScanningTable[index] = $("xSymbol");
			}
			for (int index = 128; index <= 256; index++) {
				_ScanningTable[index] = $("xSymbol");
			}
			_ScanningTable['\''] = $("quote");
			_ScanningTable['"'] = $("xDoubleQuote");
			_ScanningTable['{'] = $("xBrace");
			_ScanningTable['+'] = $("xSign");
			_ScanningTable['-'] = $("xSign");
			_ScanningTable['<'] = $("xSymbol");
			_ScanningTable['>'] = $("xSymbol");
			_ScanningTable['='] = $("xSymbol");
			_ScanningTable['~'] = $("xSymbol");
			_ScanningTable['*'] = $("xSymbol");
			_ScanningTable['/'] = $("xSymbol");
			_ScanningTable['_'] = $("xSymbol");
			_ScanningTable[':'] = $("xSymbol");
			_ScanningTable[','] = $("xSymbol");
			_ScanningTable['\\'] = $("xSymbol");
			_ScanningTable['%'] = $("xComment");
			_ScanningTable['('] = $("leftParenthesis");
			_ScanningTable[')'] = $("rightParenthesis");
			_ScanningTable['['] = $("leftParenthesis");
			_ScanningTable[']'] = $("rightParenthesis");
			_ScanningTable['.'] = $("period");
			_ScanningTable['`'] = $("quote");
			_ScanningTable['!'] = $("eof");
		}

		if (ScanningTable == null) {
			ScanningTable = new JunLispScannerTable();
		}

		return ScanningTable;
	}

	/**
	 * Return the symbol which correpsonds to a character.
	 * 
	 * @param index int
	 * 
	 * @return jp.co.sra.smalltalk.StSymbol
	 */
	public StSymbol at_(int index) {
		if ((257 <= index) && (index <= 65536)) {
			if (Character.isLetter((char) (index - 1))) {
				return $("xSymbol");
			} else {
				return $("xBinary");
			}
		} else {
			return _ScanningTable[index];
		}
	}
}
