package jp.co.sra.jun.goodies.lisp;

import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunLispParserTestExamples class
 * 
 *  @author    ASTI Beijing
 *  @created   1998/12/09 (by ASTI Beijing)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunLispParserTestExamples.java,v 8.10 2008/02/20 06:31:49 nisinaka Exp $
 */
public class JunLispParserTestExamples extends JunTestExamples {

	/**
	 * Example_LongNumber: parse a long numbmer.
	 * 
	 * @return boolean
	 */
	public static boolean Example_LongNumber() {
		JunLispCons list = (JunLispCons) JunLispParser.Parse_("(2002112612345600000)");
		System.out.println(list.printString());

		return (list.head() instanceof Long && ((Long) list.head()).longValue() == 2002112612345600000L);
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return boolean
	 */
	public static boolean Example1() {
		JunLispCons list = (JunLispCons) JunLispParser.Parse_("(1 2 3 4 (5 6 7 8 9) 10)11 12");
		System.out.println(list.printString());

		return list.printString().equals("(1 2 3 4 (5 6 7 8 9) 10)");
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return boolean
	 */
	public static boolean Example2() {
		JunLispCons list = (JunLispCons) JunLispParser.Parse_("\n(10 (1 2)\n20 (3 4 . 100)\n30 (5 6) . 200)\n");
		System.out.println(list.printString());

		return list.printString().equals("(10 (1 2) 20 (3 4 . 100) 30 (5 6) . 200)");
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return boolean
	 */
	public static boolean Example3() {
			JunLispCons list =
				(
					JunLispCons) JunLispParser
						.Parse_(
							"    \n"
							+ "(PetriNet JunAoki          \n"
							+ "	(Place                  \n"
							+ "		(p1 . {100@100})    \n"
							+ "		(p2 . {200@200})    \n"
							+ "		(p3 . {300@300})    \n"
							+ "		(p4 . {400@400})    \n"
							+ "		(p5 . {500@500}))   \n"
							+ "	(Transition             \n"
							+ "		(t1 . {100@100})    \n"
							+ "		(t2 . {200@200})    \n"
							+ "		(t3 . {300@300})    \n"
							+ "		(t4 . {400@400})    \n"
							+ "		(t5 . {500@500}))   \n"
							+ "	(InputFunction          \n"
							+ "		(t1 p1 p2 p3 p4 p5) \n"
							+ "		(t2 . p4)           \n"
							+ "		(t3 . p5))          \n"
							+ "	(OutputFunction         \n"
							+ "		(t1 p1 p2 p3 p4 p5) \n"
							+ "		(t2 . p4)           \n"
							+ "		(t3 . p5))          \n"
		+ // JunLispSmallCompiler does not handle this.
		//					"	(Marking {#(1 2 3 4 5)})) ");
	") ");
		System.out.println(list.saveString());
		list = (JunLispCons) JunLispParser.Parse_(list.saveString());

		return true;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return boolean
	 */
	public static boolean Example4() {
		JunLispCons list = (JunLispCons) JunLispParser.Parse_("(1 2 3 4 (5 6 7 ~ 8 9) 10)");
		System.out.println(list.printString());

		return list.printString().equals("(1 2 3 4 (5 6 7 ~ 8 9) 10)");
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return boolean
	 */
	public static boolean Example5() {
		try {
			JunLispCons list = (JunLispCons) JunLispParser.Parse_("(1 2 3 4 (5 6 7 {100@100 8 9) 10)");

			//this should be an error example
			System.out.println(list.printString());
			return false;
		} catch (Exception e) {
			return true;
		}
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return boolean
	 */
	public static boolean Example6() {
		JunLispCons list = (JunLispCons) JunLispParser.Parse_("(1 2 3 4 (5 6 7 'aaaaa 8 9) 10)");
		System.out.println(list.printString());

		return list.printString().equals("(1 2 3 4 (5 6 7 (quote aaaaa) 8 9) 10)");
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return boolean
	 */
	public static boolean Example7() {
		JunLispCons list = (JunLispCons) JunLispParser.Parse_(" `(`(1 2 `3) . `4) ");
		System.out.println(list.printString());

		return list.printString().equals("(quote ((quote (1 2 (quote 3))) quote 4))");
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 */
	public static void main(String[] args) {
		new JunLispParserTestExamples();
	}
}
