package jp.co.sra.jun.goodies.lisp;

import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunLispConsTestExamples class
 * 
 *  @author    ASTI Beijing
 *  @created   1998/12/09 (by ASTI Beijing)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunLispConsTestExamples.java,v 8.11 2008/02/20 06:31:49 nisinaka Exp $
 */
public class JunLispConsTestExamples extends JunTestExamples {
	/**
	 * Example.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		int[] values = { 1, 2, 3, 4, 5, 6, 7, 8, 9, 10 };
		JunLispList list = JunLispCons.List_(values);
		System.out.println(list.printString());

		return list.printString().equals("(1 2 3 4 5 6 7 8 9 10)");
	}

	/**
	 * Example.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example10() {
		if (JunLispNil.NullList().equals(JunLispNil.NullList())) {
			System.out.println("nil equals nil");
		} else {
			System.out.println("nil not equals nil ");
		}

		int[] valuesx = { 1, 2, 3 };
		int[] valuesy = { 1, 2, 3, 4 };

		if (JunLispCons.List_(valuesx).equals(JunLispCons.List_(valuesx))) {
			System.out.println("\'(1 2 3) equals \'(1 2 3)");
		} else {
			System.out.println("\'(1 2 3) not equals \'(1 2 3)");
		}

		if (JunLispCons.List_(valuesx).equals(JunLispCons.List_(valuesy))) {
			System.out.println("\'(1 2 3) equals \'(1 2 3 4)");
		} else {
			System.out.println("\'(1 2 3) not equals \'(1 2 3 4)");
		}

		if (JunLispCons.List_(valuesx).equals(new Integer(3))) {
			System.out.println("\'(1 2 3) equals object");
		} else {
			System.out.println("\'(1 2 3) not equals object");
		}

		Integer[] anArray = new Integer[3];
		anArray[0] = new Integer(1);
		anArray[1] = new Integer(2);
		anArray[2] = new Integer(3);

		if (JunLispCons.List_(valuesx).equals(JunLispCons.List_(anArray))) {
			System.out.println("\'(1 2 3) equals ArrayCons");
		} else {
			System.out.println("\'(1 2 3) not equals ArrayCons");
		}

		return true;
	}

	/**
	 * Example.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example2() {
		JunLispList nullList = JunLispCons.NullList();
		int[] values = { 1, 2 };
		JunLispCons list = (JunLispCons) JunLispCons.List_(values);
		list = new JunLispCons(list, nullList);
		list = new JunLispCons(list, nullList);
		System.out.println(list.printString());

		return list.printString().equals("(((1 2))))");
	}

	/**
	 * Example.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example3() {
		int[] arrayX = { 1, 2, 3 };
		int[] arrayY = { 4, 5, 6 };
		int[] arrayZ = { 1, 2, 3, 4, 5, 6 };
		JunLispCons x = (JunLispCons) JunLispCons.List_(arrayX);
		JunLispCons y = (JunLispCons) JunLispCons.List_(arrayY);
		JunLispCons z = (JunLispCons) JunLispCons.List_(arrayZ);
		System.out.println("(setq x '(1 2 3))=>" + x.printString());
		if (x.printString().equals("(1 2 3)") == false) {
			return false;
		}

		System.out.println("(setq y '(4 5 6))=>" + y.printString());
		if (y.printString().equals("(4 5 6)") == false) {
			return false;
		}

		System.out.println("(setq z '(1 2 3 4 5 6))=>" + z.printString());
		if (z.printString().equals("(1 2 3 4 5 6)") == false) {
			return false;
		}

		System.out.println("(append x y)=>" + x.append_(y).printString());
		if (x.append_(y).printString().equals("(1 2 3 4 5 6)") == false) {
			return false;
		}

		System.out.println("(length z)=>" + z.length());
		if (z.length() != 6) {
			return false;
		}

		System.out.println("(member 3 z)=>" + ((JunLispCons) z.member_(new Integer(3))).printString());
		int[] arrayZ2 = { 3, 4, 5, 6 };
		if (z.member_(new Integer(3)).equals(JunLispCons.List_(arrayZ2)) == false) {
			return false;
		}

		System.out.println("(nth 4 z)=>" + z.nth_(4).toString());
		if (((Number) z.nth_(4)).intValue() != 4) {
			return false;
		}

		return true;
	}

	/**
	 * Example.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example4() {
		int[] arrayX = { 1, 2 };
		int[] arrayY = { 3, 4 };
		int[] arrayZ = { 5, 6 };
		JunLispList list = JunLispCons.List_(arrayX);
		list = new JunLispCons(list, JunLispCons.List_(arrayY));
		list = new JunLispCons(list, JunLispCons.List_(arrayZ));
		System.out.println(list.saveString());

		return true;
	}

	/**
	 * Example.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example9() {
		System.out.println("the NullList is : " + JunLispCons.NullList().toString());
		System.out.println("the Cell is : " + JunLispCons.Cell().toString());
		System.out.println("the New_(5) is : " + JunLispCons.New_(5).toString());
		System.out.println(JunLispCons.Head_tail_(new Integer(10), JunLispCons.Head_tail_(new Integer(20), JunLispCons.NullList())).toString());

		Integer[] anArray = new Integer[2];
		anArray[0] = new Integer(10);
		anArray[1] = new Integer(20);
		System.out.println(JunLispCons.List_(anArray).toString());
		System.out.println("the head is : " + ((JunLispCons) (JunLispCons.List_(anArray))).head().toString());
		System.out.println("the tail is : " + ((JunLispCons) (JunLispCons.List_(anArray))).tail().toString());

		Integer[] seArray = new Integer[2];
		seArray[0] = new Integer(30);
		seArray[1] = new Integer(40);
		System.out.println("the (10,20) append (30,20) is : " + ((JunLispCons) (JunLispCons.List_(anArray))).append_(JunLispCons.List_(seArray)).ppString());
		System.out.println("the last is : " + ((JunLispCons) (((JunLispCons) (JunLispCons.List_(anArray))).last())).ppString());
		System.out.println("the length is : " + ((JunLispCons) (JunLispCons.List_(anArray))).length());
		System.out.println("the 2nd is : " + ((JunLispCons) (JunLispCons.List_(anArray))).nth_(2).toString());

		/*
		StBlockClosure anAction = new StBlockClosure() {
			public Object value_(Object obj) {
				System.out.println("doing...:" + obj.toString());

				return null;
			}
		};
		JunLispCons.List_(anArray).do_(anAction);
		*/
		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(String[] args) {
		new JunLispConsTestExamples();
	}
}
