package jp.co.sra.jun.goodies.itemlist;

import java.awt.Point;
import java.awt.Rectangle;
import jp.co.sra.jun.system.framework.JunAbstractView;

/**
 * JunOrderListView interface
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2003/12/09 (by Mitsuhiro Asada)
 *  @updated   2004/09/21 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun465 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOrderListView.java,v 8.10 2008/02/20 06:31:35 nisinaka Exp $
 */
public interface JunOrderListView extends JunAbstractView {

	/**
	 * Answer the model as JunOrderListModel.
	 * 
	 * @return jp.co.sra.jun.goodies.itemlist.JunOrderListModel
	 * @category model accessing
	 */
	public JunOrderListModel getModel();

	/**
	 * Answer my controller as a JunOrderListController.
	 * 
	 * @return jp.co.sra.jun.goodies.itemlist.JunOrderListController
	 * @category controller accessing
	 */
	public JunOrderListController getController();

	/**
	 * Return the item object at the specified index in model's item object list.
	 * 
	 * @return jp.co.sra.jun.goodies.itemlist.JunOrderListObject
	 * @param anIndex
	 * @category accessing
	 */
	public JunOrderListObject itemObjectAt_(int anIndex);

	/**
	 * Returns the rectangle at the specified position in this item row rectangles.
	 * 
	 * @return java.awt.Rectangle
	 * @param anIndex int
	 * @category bounds accessing
	 */
	public Rectangle rowBoundsAt_(int anIndex);

	/**
	 * Answer the index position specified item rows at the point.
	 * 
	 * @return int
	 * @param aPoint java.awt.Point
	 * @category selecting
	 */
	public int whichOfItemRowsAt_(Point aPoint);

}
