package jp.co.sra.jun.goodies.itemlist;

import java.util.*;
import jp.co.sra.smalltalk.StColorValue;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunOrderListTestExamples class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2003/12/09 (by Mitsuhiro Asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun465 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOrderListTestExamples.java,v 8.10 2008/02/20 06:31:35 nisinaka Exp $
 */
public class JunOrderListTestExamples extends JunTestExamples {
	public static String[] _StringArray = new String[] { "abc", "def", "ghi", "jkl", "mno" };
	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(String[] args) {
		new JunOrderListTestExamples();
	}

	/**
	 * Example1 : test for a JunOrderListObject.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		JunOrderListObject orderObject = new JunOrderListObject("color");
		System.out.println(orderObject.toString());
		return true;
	}

	/**
	 * Example2 : test for a JunOrderListModel.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example2() {
		JunOrderListModel itemList = new JunOrderListModel(_StringArray);
		itemList.lineGrid_(20);
		itemList.open();
		return true;
	}

	/**
	 * Example3 : test for a JunOrderListModel.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example3() {
		Vector colorNames = StColorValue.ConstantNames();
		String[] stringArray = new String[colorNames.size()];
		for (int i = 0; i < stringArray.length; i++) {
			stringArray[i] = colorNames.get(i).toString();
		}
		Arrays.sort(stringArray);
		JunOrderListModel itemList = new JunOrderListModel(stringArray);
		itemList.lineGrid_(20);
		itemList.open();
		return true;
	}
}
