package jp.co.sra.jun.goodies.itemlist;

import java.awt.Point;

/**
 * JunItemListView interface
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2003/12/12 (by Mitsuhiro Asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun465 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunItemListView.java,v 8.10 2008/02/20 06:31:35 nisinaka Exp $
 */
public interface JunItemListView extends JunOrderListView {
	/**
	 * Answer my model as a JunItemListModel.
	 * 
	 * @return jp.co.sra.jun.goodies.itemlist.JunItemListModel
	 * @category model accessing
	 */
	public JunItemListModel getItemListModel();

	/**
	 * Answer the index position which item object rectangle contains a point.
	 * 
	 * @return int
	 * @param aPoint java.awt.Point
	 * @category selecting
	 */
	public int whichOfCheckMarksAt_(Point aPoint);
}
