package jp.co.sra.jun.goodies.itemlist;

import java.util.*;
import jp.co.sra.smalltalk.StColorValue;

/**
 * JunItemListTestExamples class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2003/12/12 (by Mitsuhiro Asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun465 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunItemListTestExamples.java,v 8.10 2008/02/20 06:31:35 nisinaka Exp $
 */
public class JunItemListTestExamples extends JunOrderListTestExamples {
	static public boolean[] _CheckArray = new boolean[] { true, false, true, false, true };
	static public boolean[] _LockArray = new boolean[] { true, true, false, false, false };

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(String[] args) {
		new JunItemListTestExamples();
	}

	/**
	 * Example1 : test for a JunItemListObject.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		JunItemListObject orderObject = new JunItemListObject("color", true, false);
		System.out.println(orderObject.toString());
		return true;
	}

	/**
	 * Example2 : test for a JunItemListModel.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example2() {
		JunItemListModel itemList = new JunItemListModel(_StringArray, _CheckArray);
		itemList.lineGrid_(20);
		itemList.open();
		return true;
	}

	/**
	 * Example3 : test for a JunItemListModel.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example3() {
		Vector colorNames = StColorValue.ConstantNames();
		String[] stringArray = new String[colorNames.size()];
		boolean[] booleanArray = new boolean[colorNames.size()];
		for (int i = 0; i < stringArray.length; i++) {
			stringArray[i] = colorNames.get(i).toString();
			booleanArray[i] = true;
		}
		Arrays.sort(stringArray);
		JunItemListModel itemList = new JunItemListModel(stringArray, booleanArray);
		itemList.lineGrid_(20);
		itemList.open();
		return true;
	}

	/**
	 * Example4 : test for a JunItemListModel.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example4() {
		JunItemListModel itemList = new JunItemListModel(_StringArray, _CheckArray, _LockArray);
		itemList.lineGrid_(20);
		itemList.open();
		return true;
	}
}
