package jp.co.sra.jun.goodies.itemlist;

import java.awt.Dimension;
import javax.swing.JScrollPane;
import jp.co.sra.smalltalk.StView;
import jp.co.sra.smalltalk.StViewJPanel;
import jp.co.sra.smalltalk.WindowSpecLayout;

/**
 * JunChoiceListViewSwing class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2003/12/15 (by Mitsuhiro Asada)
 *  @updated   2004/09/21 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun465 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunChoiceListViewSwing.java,v 8.10 2008/02/20 06:31:35 nisinaka Exp $
 */
public class JunChoiceListViewSwing extends JunItemListViewSwing implements JunChoiceListView {

	/**
	 * Create a new instance of JunChoiceListViewSwing.
	 * 
	 * @param newModel jp.co.sra.jun.goodies.itemlist.JunChoiceListModel
	 * @category Instance creation
	 */
	public JunChoiceListViewSwing(JunChoiceListModel newModel) {
		super(newModel);
	}

	/**
	 * Create a new view for the JunChoiceListViewSwing.
	 * The view consists of a JunChoiceListViewSwing on a ScrollPane.
	 * The view having up/down buttons.
	 * 
	 * @return jp.co.sra.smalltalk.StView
	 * @param newModel jp.co.sra.jun.goodies.itemlist.JunChoiceListModel
	 * @category Instance creation
	 */
	public static StView OnScrollPaneWithButtons(JunChoiceListModel newModel) {
		return new StViewJPanel(newModel) {
			protected JunChoiceListViewSwing itemListView;

			protected void buildComponent() {
				itemListView = new JunChoiceListViewSwing((JunChoiceListModel) this.model());
				JScrollPane scrollPane = new JScrollPane(itemListView, JScrollPane.VERTICAL_SCROLLBAR_ALWAYS, JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS) {
					public void setBounds(int x, int y, int width, int height) {
						super.setBounds(x, y, width, height);
						this.doLayout();
						itemListView.setBounds(0, 0, this.getViewport().getExtentSize().width, this.getViewport().getExtentSize().height);
					}
				};

				this.setLayout(new WindowSpecLayout());
				this.add(scrollPane, WindowSpecLayout.Position(0f, 1, 0f, 1, 1f, -20, 1f, -1));
				this.add(itemListView.checkOnButtonView(), WindowSpecLayout.Position(1f, -19, 0.5f, -19, 1f, -1, 0.5f, -1));
				this.add(itemListView.checkOffButtonView(), WindowSpecLayout.Position(1f, -19, 0.5f, 1, 1f, -1, 0.5f, 19));
				this.setPreferredSize(new Dimension(150, 150));
			}
		};
	}
}
