package jp.co.sra.jun.goodies.itemlist;

import java.util.*;
import jp.co.sra.smalltalk.StColorValue;

/**
 * JunChoiceListTestExamples class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2003/12/15 (by Mitsuhiro Asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun465 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunChoiceListTestExamples.java,v 8.10 2008/02/20 06:31:35 nisinaka Exp $
 */
public class JunChoiceListTestExamples extends JunItemListTestExamples {
	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(String[] args) {
		new JunChoiceListTestExamples();
	}

	/**
	 * Example1 : test for a JunChoiceListModel.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		JunChoiceListModel choiceList = new JunChoiceListModel(_StringArray, _CheckArray);
		choiceList.lineGrid_(20);
		choiceList.open();
		return true;
	}

	/**
	 * Example2 : test for a JunChoiceListModel.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example2() {
		Vector colorNames = StColorValue.ConstantNames();
		String[] stringArray = new String[colorNames.size()];
		boolean[] booleanArray = new boolean[colorNames.size()];
		for (int i = 0; i < stringArray.length; i++) {
			stringArray[i] = colorNames.get(i).toString();
			booleanArray[i] = true;
		}
		Arrays.sort(stringArray);
		JunChoiceListModel choiceList = new JunChoiceListModel(stringArray, booleanArray);
		choiceList.lineGrid_(20);
		choiceList.open();
		return true;
	}

	/**
	 * Example3 : test for a JunChoiceListModel.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example3() {
		JunChoiceListModel choiceList = new JunChoiceListModel(_StringArray, _CheckArray, _LockArray);
		choiceList.lineGrid_(20);
		choiceList.open();
		return true;
	}
}
