package jp.co.sra.jun.goodies.image.support;

import java.awt.Dimension;
import java.awt.Image;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

import jp.co.sra.smalltalk.SmalltalkException;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StImage;
import jp.co.sra.smalltalk.StValueHolder;

import jp.co.sra.jun.goodies.files.JunFileModel;
import jp.co.sra.jun.goodies.image.streams.JunImageStream;
import jp.co.sra.jun.goodies.image.streams.JunJpegImageStream;
import jp.co.sra.jun.goodies.progress.JunProgress;
import jp.co.sra.jun.graphics.navigator.JunFileRequesterDialog;
import jp.co.sra.jun.system.support.JunSystem;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunImageAdjusterTestExamples class
 * 
 *  @author    nisinaka
 *  @created   2001/04/05 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun632 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunImageAdjusterTestExamples.java,v 8.12 2008/02/20 06:31:35 nisinaka Exp $
 */
public class JunImageAdjusterTestExamples extends JunTestExamples {

	/**
	 * Example: Adjust an image.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		try {
			StImage anImage = TestImage();
			JunImageAdjuster anAdjuster = new JunImageAdjuster();
			anImage = anAdjuster.adjust_extent_(anImage, new Dimension(128, 96));
			JunImageAdjuster.Show_(anImage);

			return true;
		} catch (Exception e) {
			e.printStackTrace();

			return false;
		}
	}

	/**
	 * Example: Adjust an image while showing a progress bar.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example2() {
		try {
			final JunImageAdjuster anAdjuster = new JunImageAdjuster();
			final JunProgress aProgress = new JunProgress();
			anAdjuster.compute_(new StBlockClosure() {
				public Object value_(Object anObject) {
					aProgress.value_(((Number) anObject).floatValue());

					return null;
				}
			});

			final StValueHolder imageHolder = new StValueHolder(TestImage());
			aProgress.message_(JunSystem.$String("adusting image..."));
			aProgress.do_(new StBlockClosure() {
				public Object value() {
					StImage anImage = (StImage) imageHolder.value();
					anImage = anAdjuster.adjust_extent_(anImage, new Dimension(128, 96));
					imageHolder.value_(anImage);

					return null;
				}
			});
			JunImageAdjuster.Show_((StImage) imageHolder.value());

			return true;
		} catch (Exception e) {
			e.printStackTrace();

			return false;
		}
	}

	/**
	 * Test: AdjustImage_extent_keepAspect_()
	 * 
	 * @return booelean
	 * @category Testing
	 */
	public static boolean Test$AdjustImage_extent_keepAspect_$1() {
		StImage anImage = JunImageAdjuster.AdjustImage_extent_keepAspect_(StImage._FromUser(), new Dimension(128, 128), true);
		JunImageAdjuster.Show_(anImage);

		return true;
	}

	/**
	 * Test: AdjustImage_extent_keepAspect_()
	 * 
	 * @return booelean
	 * @category Testing
	 */
	public static boolean Test$AdjustImage_extent_keepAspect_$2() {
		StImage anImage = JunImageAdjuster.AdjustImage_extent_keepAspect_(StImage._OfWholeScreen(), new Dimension(128, 96), true);
		JunImageAdjuster.Show_(anImage);

		return true;
	}

	/**
	 * Test: AdjustImage_extent_keepAspect_alignmentSymbol_()
	 * 
	 * @return booelean
	 * @category Testing
	 */
	public static boolean Test$AdjustImage_extent_keepAspect_alignmentSymbol_() {
		StImage anImage = JunImageAdjuster.AdjustImage_extent_keepAspect_alignmentSymbol_(StImage._OfWholeScreen(), new Dimension(300, 100), true, $("center"));
		JunImageAdjuster.Show_(anImage);

		return true;
	}

	/**
	 * Test: computeIntervals_divisionSize_()
	 * 
	 * @return boolean
	 * @category Testing
	 */
	public static boolean Test$computeIntervals_divisionSize_$1() {
		(new JunImageAdjuster()).computeIntervals_divisionSize_(1000, 10);

		return true;
	}

	/**
	 * Test: computeIntervals_divisionSize_()
	 * 
	 * @return boolean
	 * @category Testing
	 */
	public static boolean Test$computeIntervals_divisionSize_$2() {
		(new JunImageAdjuster()).computeIntervals_divisionSize_(1005, 10);

		return true;
	}

	/**
	 * Example: ImageAdjuster by java.awt.Image#getScaledInstance()
	 * 
	 * @return boolean
	 * @category Testing
	 */
	public static boolean Test$Image$SCALE_AVERAGE() {
		try {
			StImage anImage = TestImage();
			Image scaledImage = anImage.image().getScaledInstance(128, 96, Image.SCALE_AREA_AVERAGING);
			JunImageAdjuster.Show_(new StImage(scaledImage));

			return true;
		} catch (Exception e) {
			e.printStackTrace();

			return false;
		}
	}

	/**
	 * Example: ImageAdjuster by java.awt.Image#getScaledInstance()
	 * 
	 * @return boolean
	 * @category Testing
	 */
	public static boolean Test$Image$SCALE_DEFAULT() {
		try {
			StImage anImage = TestImage();
			Image scaledImage = anImage.image().getScaledInstance(128, 96, Image.SCALE_DEFAULT);
			JunImageAdjuster.Show_(new StImage(scaledImage));

			return true;
		} catch (Exception e) {
			e.printStackTrace();

			return false;
		}
	}

	/**
	 * Example: ImageAdjuster by java.awt.Image#getScaledInstance()
	 * 
	 * @return boolean
	 * @category Testing
	 */
	public static boolean Test$Image$SCALE_FAST() {
		try {
			StImage anImage = TestImage();
			Image scaledImage = anImage.image().getScaledInstance(128, 96, Image.SCALE_FAST);
			JunImageAdjuster.Show_(new StImage(scaledImage));

			return true;
		} catch (Exception e) {
			e.printStackTrace();

			return false;
		}
	}

	/**
	 * Example: ImageAdjuster by java.awt.Image#getScaledInstance()
	 * 
	 * @return boolean
	 * @category Testing
	 */
	public static boolean Test$Image$SCALE_REPLICATE() {
		try {
			StImage anImage = TestImage();
			Image scaledImage = anImage.image().getScaledInstance(128, 96, Image.SCALE_REPLICATE);
			JunImageAdjuster.Show_(new StImage(scaledImage));

			return true;
		} catch (Exception e) {
			e.printStackTrace();

			return false;
		}
	}

	/**
	 * Example: ImageAdjuster by java.awt.Image#getScaledInstance()
	 * 
	 * @return boolean
	 * @category Testing
	 */
	public static boolean Test$Image$SCALE_SMOOTH() {
		try {
			StImage anImage = TestImage();
			Image scaledImage = anImage.image().getScaledInstance(128, 96, Image.SCALE_SMOOTH);
			JunImageAdjuster.Show_(new StImage(scaledImage));

			return true;
		} catch (Exception e) {
			e.printStackTrace();

			return false;
		}
	}

	/**
	 * Choose an image for test.
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @exception java.io.IOException
	 * @category Private
	 */
	private static StImage TestImage() throws IOException {
		JunFileModel.FileType[] fileTypes = new JunFileModel.FileType[] { new JunFileModel.FileType(JunSystem.$String("<1p> files", null, "JPEG"), new String[] { "*.jpg", "*.JPG" }) };
		File file = JunFileRequesterDialog.RequestFile(JunSystem.$String("Select a <1p> file.", null, "JPEG"), fileTypes, fileTypes[0]);
		if (file == null) {
			throw new SmalltalkException("cancel");
		}

		StImage image = null;
		JunImageStream stream = null;
		try {
			stream = JunJpegImageStream.On_(new FileInputStream(file));
			image = stream.nextImage();
		} finally {
			if (stream != null) {
				stream.close();
			}
		}
		return image;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args an array of command-line arguments
	 * @category Main
	 */
	public static void main(java.lang.String[] args) {
		new JunImageAdjusterTestExamples();
	}

}
