package jp.co.sra.jun.goodies.image.streams;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import jp.co.sra.smalltalk.StImage;

/**
 * JunJava2JpegImageStream class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2000/11/22 (by Mitsuhiro Asada)
 *  @updated   2005/08/15 (by Mitsuhiro Asada)
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunJava2JpegImageStream.java,v 8.11 2008/02/20 06:31:35 nisinaka Exp $
 */
public class JunJava2JpegImageStream extends JunJpegImageStream {
	/**
	 * Constructor with an input stream.
	 * 
	 * @return jp.co.sra.jun.goodies.image.streams.JunImageStream
	 * @param stream java.io.InputStream
	 * @exception java.io.IOException
	 * @category Instance creation
	 */
	public static JunImageStream On_(InputStream stream) throws IOException {
		return On_(new JunJava2JpegImageStream(), stream);
	}

	/**
	 * Constructor with an output stream.
	 * 
	 * @return jp.co.sra.jun.goodies.image.streams.JunImageStream
	 * @param stream java.io.OutputStream
	 * @exception java.io.IOException
	 * @category Instance creation
	 */
	public static JunImageStream On_(OutputStream stream) throws IOException {
		return On_(new JunJava2JpegImageStream(), stream);
	}

	/**
	 * Read the image from the input stream. (used Java2 core API)
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @exception java.io.IOException
	 * @category accessing
	 */
	public StImage nextImage() throws IOException {
		if (inStream != null) {
			JPEGImageDecoder imageDecoder = JPEGCodec.createJPEGDecoder(inStream);
			imageObject = new StImage(imageDecoder.decodeAsBufferedImage());
		}
		return imageObject;
	}

	/**
	 * Write the image on output stream. (used Java2 core API)
	 * 
	 * @param newImage jp.co.sra.smalltalk.StImage
	 * @exception java.io.IOException
	 * @category accessing
	 */
	public void nextPutImage_(StImage newImage) throws IOException {
		if (outStream != null) {
			BufferedImage anImage = new BufferedImage(newImage.width(), newImage.height(), BufferedImage.TYPE_3BYTE_BGR);
			anImage.setRGB(0, 0, newImage.width(), newImage.height(), newImage.getPixels(), 0, newImage.width());
			JPEGImageEncoder imageEncoder = JPEGCodec.createJPEGEncoder(outStream);
			imageEncoder.encode(anImage);
		}
	}
}
