package jp.co.sra.jun.goodies.image.streams;

import com.sun.media.jai.codec.*;
import java.awt.image.*;
import java.awt.image.renderable.*;
import java.io.*;
import javax.media.jai.*;
import jp.co.sra.smalltalk.*;

/**
 * JunJaiPngImageStream class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2000/11/16 (by Mitsuhiro Asada)
 *  @updated   2005/08/15 (by Mitsuhiro Asada)
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunJaiPngImageStream.java,v 8.11 2008/02/20 06:31:35 nisinaka Exp $
 */
public class JunJaiPngImageStream extends JunPngImageStream {
	/**
	 * Constructor with an input stream.
	 * 
	 * @return jp.co.sra.jun.goodies.image.streams.JunImageStream
	 * @param stream java.io.InputStream
	 * @exception java.io.IOException
	 * @category Instance creation
	 */
	public static JunImageStream On_(InputStream stream) throws IOException {
		return On_(new JunJaiPngImageStream(), stream);
	}

	/**
	 * Constructor with an output stream.
	 * 
	 * @return jp.co.sra.jun.goodies.image.streams.JunImageStream
	 * @param stream java.io.OutputStream
	 * @exception java.io.IOException
	 * @category Instance creation
	 */
	public static JunImageStream On_(OutputStream stream) throws IOException {
		return On_(new JunJaiPngImageStream(), stream);
	}

	/**
	 * Read the image from the input stream. (used Java Advanced Imaging API)
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @exception java.io.IOException
	 * @category accessing
	 */
	public StImage nextImage() throws IOException {
		if (inStream != null) {
			ImageDecoder imageDecoder = ImageCodec.createImageDecoder("PNG", inStream, null);
			RenderedImage renderedImage = imageDecoder.decodeAsRenderedImage();
			WritableRaster writableRaster = renderedImage.getData().createCompatibleWritableRaster();
			BufferedImage anImage = new BufferedImage(renderedImage.getColorModel(), renderedImage.copyData(writableRaster), false, null);
			imageObject = new StImage(anImage);
		}
		return imageObject;
	}

	/**
	 * Write the image on output stream. (used Java Advanced Imaging API)
	 * 
	 * @param newImage jp.co.sra.smalltalk.StImage
	 * @exception java.io.IOException
	 * @category accessing
	 */
	public void nextPutImage_(StImage newImage) throws IOException {
		if (outStream != null) {
			imageObject = newImage;
			ParameterBlock pb = new ParameterBlock();
			pb.add(newImage.image());
			RenderedOp renderedOp = JAI.create("awtImage", pb);
			ImageEncoder imageEncoder = ImageCodec.createImageEncoder("PNG", outStream, null);
			imageEncoder.encode(renderedOp);
		}
	}
}
