package jp.co.sra.jun.goodies.image.framework;

import java.awt.Component;
import java.awt.Rectangle;

import jp.co.sra.jun.system.framework.JunAbstractView;

/**
 * JunImageDisplayView interface
 * 
 *  @author    m-asada
 *  @created   2006/04/06 (by m-asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun632 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunImageDisplayView.java,v 8.10 2008/02/20 06:31:35 nisinaka Exp $
 */
public interface JunImageDisplayView extends JunAbstractView {
	/**
	 * Answer the receiver's model as JunImageDisplayModel.
	 * 
	 * @return jp.co.sra.jun.goodies.image.framework.JunImageDisplayModel
	 * @category model accessing
	 */
	public JunImageDisplayModel getModel();

	/**
	 * Set whether the view is opened with scrollbars or not.
	 *
	 * @param aBoolean boolean
	 * @category accessing
	 */
	public void _scrollable(boolean aBoolean);
	
	/**
	 * Answer the viewport bounds at the recevier's scroll pane.
	 * 
	 * @return java.awt.Rectangle
	 * @category bounds accessing
	 */
	public Rectangle _getViewportBounds();

	/**
	 * Answer the receiver's canvas as Component.
	 * 
	 * @return java.awt.Component
	 * @category user interface
	 */
	public Component _canvasComponent();
}
