package jp.co.sra.jun.goodies.image.framework;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;

import jp.co.sra.smalltalk.DependentListener;
import jp.co.sra.smalltalk.StApplicationModel;
import jp.co.sra.smalltalk.StDisplayable;
import jp.co.sra.smalltalk.StImage;
import jp.co.sra.smalltalk.StView;
import jp.co.sra.smalltalk.menu.MenuPerformer;
import jp.co.sra.smalltalk.menu.StMenuItem;
import jp.co.sra.smalltalk.menu.StPopupMenu;

import jp.co.sra.jun.system.framework.JunApplicationModel;

/**
 * JunImageDisplayModel class
 * 
 *  @author    m-asada
 *  @created   2006/04/06 (by m-asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun696 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunImageDisplayModel.java,v 8.17 2008/02/20 06:31:35 nisinaka Exp $
 */
public class JunImageDisplayModel extends JunApplicationModel {
	protected StDisplayable displayImage;
	protected transient StPopupMenu _popupMenu;

	/**
	 * Open the new application window with the specified image.
	 * 
	 * @param anImage java.awt.Image
	 * @return jp.co.sra.jun.goodies.image.framework.JunImageDisplayModel
	 * @category Utilities
	 */
	public static JunImageDisplayModel Show_(Image anImage) {
		return Show_(new StImage(anImage));
	}

	/**
	 * Open the new application window with the specified image.
	 * 
	 * @param anImage jp.co.sra.smalltalk.StDisplayable
	 * @return jp.co.sra.jun.goodies.image.framework.JunImageDisplayModel
	 * @category Utilities
	 */
	public static JunImageDisplayModel Show_(StDisplayable anImage) {
		JunImageDisplayModel aModel = new JunImageDisplayModel(anImage);
		aModel.open();
		return aModel;
	}

	/**
	 * Open the new application window with the specified image at the specified point.
	 * 
	 * @param anImage java.awt.Image
	 * @param aPoint java.awt.Point
	 * @return jp.co.sra.jun.goodies.image.framework.JunImageDisplayModel
	 * @category Utilities
	 */
	public static JunImageDisplayModel Show_at_(Image anImage, Point aPoint) {
		return Show_at_(new StImage(anImage), aPoint);
	}

	/**
	 * Open the new application window with the specified image at the specified point.
	 * 
	 * @param anImage jp.co.sra.smalltalk.StDisplayable
	 * @param aPoint java.awt.Point
	 * @return jp.co.sra.jun.goodies.image.framework.JunImageDisplayModel
	 * @category Utilities
	 */
	public static JunImageDisplayModel Show_at_(StDisplayable anImage, Point aPoint) {
		JunImageDisplayModel aModel = new JunImageDisplayModel(anImage);
		aModel.openAt_(aPoint);
		return aModel;
	}

	/**
	 * Open the new application window with the specified image in the specified area.
	 * 
	 * @param anImage java.awt.Image
	 * @param aRectangle java.awt.Rectangle
	 * @return jp.co.sra.jun.goodies.image.framework.JunImageDisplayModel
	 * @category Utilities
	 */
	public static JunImageDisplayModel Show_in_(Image anImage, Rectangle aRectangle) {
		return Show_in_(new StImage(anImage), aRectangle);
	}

	/**
	 * Open the new application window with the specified image in the specified area.
	 * 
	 * @param anImage jp.co.sra.smalltalk.StDisplayable
	 * @param aRectangle java.awt.Rectangle
	 * @return jp.co.sra.jun.goodies.image.framework.JunImageDisplayModel
	 * @category Utilities
	 */
	public static JunImageDisplayModel Show_in_(StDisplayable anImage, Rectangle aRectangle) {
		JunImageDisplayModel aModel = new JunImageDisplayModel(anImage);
		aModel.openIn_(aRectangle);
		return aModel;
	}

	/**
	 * Open the new application window with the specified image and label.
	 * 
	 * @param anImage java.awt.Image
	 * @param aString java.lang.String
	 * @return jp.co.sra.jun.goodies.image.framework.JunImageDisplayModel
	 * @category Utilities
	 */
	public static JunImageDisplayModel Show_label_(Image anImage, String aString) {
		return Show_label_(new StImage(anImage), aString);
	}

	/**
	 * Open the new application window with the specified image and label.
	 * 
	 * @param anImage jp.co.sra.smalltalk.StDisplayable
	 * @param aString java.lang.String
	 * @return jp.co.sra.jun.goodies.image.framework.JunImageDisplayModel
	 * @category Utilities
	 */
	public static JunImageDisplayModel Show_label_(StDisplayable anImage, String aString) {
		JunImageDisplayModel aModel = JunImageDisplayModel.Show_(anImage);
		((Frame) aModel.getWindow()).setTitle(aString);
		return aModel;
	}

	/**
	 * Open the new application window with the specified image and label at the specified point.
	 * 
	 * @param anImage jp.co.sra.smalltalk.StDisplayable
	 * @param aString java.lang.String
	 * @param aPoint java.awt.Point
	 * @return jp.co.sra.jun.goodies.image.framework.JunImageDisplayModel
	 * @category Utilities
	 */
	public static JunImageDisplayModel Show_label_at_(StDisplayable anImage, final String aString, Point aPoint) {
		JunImageDisplayModel aModel = JunImageDisplayModel.Show_at_(anImage, aPoint);
		((Frame) aModel.getWindow()).setTitle(aString);
		return aModel;
	}

	/**
	 * Open the new application window with the specified image and label in the specified area.
	 * 
	 * @param anImage jp.co.sra.smalltalk.StDisplayable
	 * @param aString java.lang.String
	 * @param aRectangle java.awt.Rectangle
	 * @return jp.co.sra.jun.goodies.image.framework.JunImageDisplayModel
	 * @category Utilities
	 */
	public static JunImageDisplayModel Show_label_in_(StDisplayable anImage, String aString, Rectangle aRectangle) {
		JunImageDisplayModel aModel = JunImageDisplayModel.Show_in_(anImage, aRectangle);
		((Frame) aModel.getWindow()).setTitle(aString);
		return aModel;
	}

	/**
	 * Create a new instance of <code>JunImageDisplayModel</code> and initialize it.
	 * 
	 * @category Instance creation
	 */
	public JunImageDisplayModel() {
		super();
	}

	/**
	 * Create a new instance of <code>JunImageDisplayModel</code> and initialize it.
	 * 
	 * @param anImage jp.co.sra.smalltalk.StDisplayable
	 * @category Instance creation
	 */
	public JunImageDisplayModel(StDisplayable anImage) {
		super();
		this.image_(anImage);
	}

	/**
	 * Create a new instance of <code>JunImageDisplayModel</code> and initialize it.
	 * 
	 * @param anImage java.awt.Image
	 * @category Instance creation
	 */
	public JunImageDisplayModel(Image anImage) {
		super();
		this.image_(anImage);
	}

	/**
	 * Initialize the receiver.
	 * 
	 * @see jp.co.sra.smalltalk.StApplicationModel#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();
		displayImage = null;
		_popupMenu = null;
	}

	/**
	 * Answer the receiver's display bounds.
	 * 
	 * @return java.awt.Rectangle
	 * @category accessing
	 */
	public Rectangle bounds() {
		return (this.image() == null) ? new Rectangle(0, 0, 0, 0) : this.image().bounds();
	}

	/**
	 * Answer the receiver's display image.
	 * 
	 * @return jp.co.sra.smalltalk.StDisplayable
	 * @category accessing
	 */
	public StDisplayable image() {
		return displayImage;
	}

	/**
	 * Set the receiver's display image.
	 * 
	 * @param anImage jp.co.sra.smalltalk.StDisplayable
	 * @category accessing
	 */
	public void image_(StDisplayable anImage) {
		displayImage = anImage;
	}

	/**
	 * Set the receiver's display image.
	 * 
	 * @param anImage java.awt.Image
	 * @category accessing
	 */
	public void image_(Image anImage) {
		if (anImage == null) {
			displayImage = null;
		} else {
			displayImage = new StImage(anImage);
		}
	}

	/**
	 * Convert the receiver to an image as StImage.
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @see jp.co.sra.jun.system.framework.JunApplicationModel#asImage()
	 * @category converting
	 */
	public StImage asImage() {
		return this.image().asImage();
	}

	/**
	 * Answer the default view of the model.
	 * 
	 * @return jp.co.sra.smalltalk.StView
	 * @see jp.co.sra.smalltalk.StApplicationModel#defaultView()
	 * @category defaults
	 */
	public StView defaultView() {
		if (GetDefaultViewMode() == VIEW_AWT) {
			return new JunImageDisplayViewAwt(this);
		} else {
			return new JunImageDisplayViewSwing(this);
		}
	}

	/**
	 * Repaint the receiver's view.
	 * 
	 * @category displaying
	 */
	public void redisplay() {
		this.changed_($("redisplay"));
	}

	/**
	 * Open a Frame for a default view and open it at the center of the display.
	 * 
	 * @return java.awt.Frame
	 * @see jp.co.sra.smalltalk.StApplicationModel#open()
	 * @category interface opening
	 */
	public Frame open() {
		Frame aFrame = super.open();
		StApplicationModel._ShowAtCenterPoint(aFrame);
		return aFrame;
	}

	/**
	 * Open a Frame for a default view and open it in the specified area.
	 *
	 * @param aRectangle java.awt.Rectangle
	 * @return java.awt.Frame
	 * @see jp.co.sra.jun.system.framework.JunApplicationModel#openIn_(java.awt.Rectangle)
	 * @category interface opening
	 */
	public Frame openIn_(Rectangle aRectangle) {
		Frame aFrame = super.openIn_(aRectangle);
		Component rootComponent = aFrame.getComponent(0);
		Dimension preferredSize = this.getImageDisplayView().toComponent().getPreferredSize();
		if (preferredSize.width > rootComponent.getWidth() || preferredSize.height > rootComponent.getHeight()) {
			this.getImageDisplayView()._scrollable(true);
		}
		return aFrame;
	}

	/**
	 * Answer the receiver's window title.
	 * 
	 * @return java.lang.String
	 * @see jp.co.sra.smalltalk.StApplicationModel#windowTitle()
	 * @category interface opening
	 */
	protected String windowTitle() {
		if (this.image() == null) {
			return this._className().toString();
		}
		String aString = this.image().toString();
		int index = aString.lastIndexOf('.');
		aString = (index == -1) ? aString : aString.substring(index + 1);
		return aString + " " + this.image().bounds().width + "x" + this.image().bounds().height;
	}

	/**
	 * Answer my popup menu.
	 * 
	 * @return jp.co.sra.smalltalk.menu.StPopupMenu
	 * @see jp.co.sra.smalltalk.StApplicationModel#_popupMenu()
	 * @category resources
	 */
	public StPopupMenu _popupMenu() {
		if (_popupMenu == null) {
			_popupMenu = new StPopupMenu();
			_popupMenu.add(new StMenuItem($String("Save as image..."), $("saveAsImage"), new MenuPerformer(this, "saveAsImage")));
		}
		return _popupMenu;
	}

	/**
	 * Answer the receiver's display image.
	 * 
	 * @return jp.co.sra.smalltalk.StDisplayable
	 * @category private
	 */
	protected StDisplayable displayImage() {
		return displayImage;
	}

	/**
	 * Answer the receiver's view as StView.
	 * 
	 * @return jp.co.sra.smalltalk.StView
	 * @see jp.co.sra.jun.system.framework.JunApplicationModel#getView()
	 * @category private
	 */
	public StView getView() {
		DependentListener[] dependents = this.dependents();
		for (int i = 0; i < dependents.length; i++) {
			Object each = dependents[i];
			if (each instanceof JunImageDisplayView && ((JunImageDisplayView) each).model() == this) {
				return (JunImageDisplayView) each;
			}
		}
		return null;
	}

	/**
	 * Answer the receiver's view as JunImageDisplayView.
	 * 
	 * @return jp.co.sra.jun.goodies.image.framework.JunImageDisplayView
	 * @category private
	 */
	protected JunImageDisplayView getImageDisplayView() {
		return (JunImageDisplayView) this.getView();
	}
}
