package jp.co.sra.jun.goodies.icon;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;

import jp.co.sra.smalltalk.StImage;
import jp.co.sra.smalltalk.StObject;
import jp.co.sra.smalltalk.StOpaqueImage;
import jp.co.sra.smalltalk.SystemResourceSupport;

import jp.co.sra.jun.goodies.image.support.JunImageProcessor;

/**
 * JunOpaqueImageIcons class
 * 
 *  @author    nisinaka
 *  @created   2004/01/14 (by nisinaka)
 *  @updated   2007/03/19 (by m-asada)
 *  @version   699 (with StPL8.9) based on Jun653 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOpaqueImageIcons.java,v 8.12 2008/02/20 06:31:34 nisinaka Exp $
 */
public class JunOpaqueImageIcons extends StObject {

	protected static StOpaqueImage Drive16x16;
	protected static StOpaqueImage Drive32x32;
	protected static StOpaqueImage Drive64x64;
	protected static StOpaqueImage Empty16x16;
	protected static StOpaqueImage Empty32x32;
	protected static StOpaqueImage Empty64x64;
	protected static StOpaqueImage FolderClose16x16;
	protected static StOpaqueImage FolderClose32x32;
	protected static StOpaqueImage FolderClose64x64;
	protected static StOpaqueImage FolderOpen16x16;
	protected static StOpaqueImage FolderOpen32x32;
	protected static StOpaqueImage FolderOpen64x64;
	protected static StOpaqueImage Image16x16;
	protected static StOpaqueImage Image32x32;
	protected static StOpaqueImage Image64x64;
	protected static StOpaqueImage Movie16x16;
	protected static StOpaqueImage Movie32x32;
	protected static StOpaqueImage Movie64x64;
	protected static StOpaqueImage Sound16x16;
	protected static StOpaqueImage Sound32x32;
	protected static StOpaqueImage Sound64x64;
	protected static StOpaqueImage Text16x16;
	protected static StOpaqueImage Text32x32;
	protected static StOpaqueImage Text64x64;
	protected static StOpaqueImage Body16x16;
	protected static StOpaqueImage Body32x32;
	protected static StOpaqueImage Body64x64;
	protected static StOpaqueImage Other16x16;
	protected static StOpaqueImage Other32x32;
	protected static StOpaqueImage Other64x64;
	protected static StOpaqueImage Triangle16x16;
	protected static StOpaqueImage ConcentricArrangement32x32;
	protected static StOpaqueImage OriginalArrangement32x32;
	protected static StOpaqueImage TreeArrangement32x32;
	protected static StOpaqueImage DictionaryBlack32x32;
	protected static StOpaqueImage DictionaryWhite32x32;
	protected static StOpaqueImage PencilBold32x32;
	protected static StOpaqueImage PencilBlack32x32;
	protected static StOpaqueImage PencilWhite32x32;
	protected static StOpaqueImage Freehand32x32;
	protected static StOpaqueImage TextAcceptThumbUp32x32;
	protected static StOpaqueImage TextAcceptOK32x32;

	/**
	 * Drive 16x16 image
	 * 
	 * @return jp.co.sra.smalltalk.StOpaqueImage
	 * @category Drive icons
	 */
	public static StOpaqueImage Drive16x16() {
		if (Drive16x16 == null) {
			Drive16x16 = new StOpaqueImage(DriveFigure16x16(), DriveShape16x16());
		}
		return Drive16x16;
	}

	/**
	 * DriveFigure 16x16 image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Drive icons
	 */
	public static StImage DriveFigure16x16() {
		return new StImage(SystemResourceSupport.createImage("/jp/co/sra/jun/goodies/icon/DriveFigure16x16.png"));
	}

	/**
	 * DriveShape 16x16 image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Drive icons
	 */
	public static StImage DriveShape16x16() {
		return MakeShape_seedColor_(DriveFigure16x16(), Color.red);
	}

	/**
	 * Drive 32x32 image
	 * 
	 * @return jp.co.sra.smalltalk.StOpaqueImage
	 * @category Drive icons
	 */
	public static StOpaqueImage Drive32x32() {
		if (Drive32x32 == null) {
			Drive32x32 = new StOpaqueImage(DriveFigure32x32(), DriveShape32x32());
		}
		return Drive32x32;
	}

	/**
	 * DriveFigure 32x32 image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Drive icons
	 */
	public static StImage DriveFigure32x32() {
		return new StImage(SystemResourceSupport.createImage("/jp/co/sra/jun/goodies/icon/DriveFigure32x32.png"));
	}

	/**
	 * DriveShape 32x32 image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Drive icons
	 */
	public static StImage DriveShape32x32() {
		return MakeShape_seedColor_(DriveFigure32x32(), Color.red);
	}

	/**
	 * Drive 64x64 image
	 * 
	 * @return jp.co.sra.smalltalk.StOpaqueImage
	 * @category Drive icons
	 */
	public static StOpaqueImage Drive64x64() {
		if (Drive64x64 == null) {
			Drive64x64 = new StOpaqueImage(DriveFigure64x64(), DriveShape64x64());
		}
		return Drive64x64;
	}

	/**
	 * DriveFigure 64x64 image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Drive icons
	 */
	public static StImage DriveFigure64x64() {
		return new StImage(SystemResourceSupport.createImage("/jp/co/sra/jun/goodies/icon/DriveFigure64x64.png"));
	}

	/**
	 * DriveShape 64x64 image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Drive icons
	 */
	public static StImage DriveShape64x64() {
		return MakeShape_seedColor_(DriveFigure64x64(), Color.red);
	}

	/**
	 * FolderClose 16x16 image
	 * 
	 * @return jp.co.sra.smalltalk.StOpaqueImage
	 * @category Folder icons
	 */
	public static StOpaqueImage FolderClose16x16() {
		if (FolderClose16x16 == null) {
			FolderClose16x16 = new StOpaqueImage(FolderCloseFigure16x16(), FolderCloseShape16x16());
		}
		return FolderClose16x16;

	}

	/**
	 * FolderCloseFigure 16x16 image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Folder icons
	 */
	public static StImage FolderCloseFigure16x16() {
		return new StImage(SystemResourceSupport.createImage("/jp/co/sra/jun/goodies/icon/FolderCloseFigure16x16.png"));
	}

	/**
	 * FolderCloseShape 16x16 image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Folder icons
	 */
	public static StImage FolderCloseShape16x16() {
		return MakeShape_seedColor_(FolderCloseFigure16x16(), Color.red);
	}

	/**
	 * FolderClose 32x32 image
	 * 
	 * @return jp.co.sra.smalltalk.StOpaqueImage
	 * @category Folder icons
	 */
	public static StOpaqueImage FolderClose32x32() {
		if (FolderClose32x32 == null) {
			FolderClose32x32 = new StOpaqueImage(FolderCloseFigure32x32(), FolderCloseShape32x32());
		}
		return FolderClose32x32;

	}

	/**
	 * FolderCloseFigure 32x32 image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Folder icons
	 */
	public static StImage FolderCloseFigure32x32() {
		return new StImage(SystemResourceSupport.createImage("/jp/co/sra/jun/goodies/icon/FolderCloseFigure32x32.png"));
	}

	/**
	 * FolderCloseShape 32x32 image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Folder icons
	 */
	public static StImage FolderCloseShape32x32() {
		return MakeShape_seedColor_(FolderCloseFigure32x32(), Color.red);
	}

	/**
	 * FolderClose 64x64 image
	 * 
	 * @return jp.co.sra.smalltalk.StOpaqueImage
	 * @category Folder icons
	 */
	public static StOpaqueImage FolderClose64x64() {
		if (FolderClose64x64 == null) {
			FolderClose64x64 = new StOpaqueImage(FolderCloseFigure64x64(), FolderCloseShape64x64());
		}
		return FolderClose64x64;

	}

	/**
	 * FolderCloseFigure 64x64 image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Folder icons
	 */
	public static StImage FolderCloseFigure64x64() {
		return new StImage(SystemResourceSupport.createImage("/jp/co/sra/jun/goodies/icon/FolderCloseFigure64x64.png"));
	}

	/**
	 * FolderCloseShape 64x64 image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Folder icons
	 */
	public static StImage FolderCloseShape64x64() {
		return MakeShape_seedColor_(FolderCloseFigure64x64(), Color.red);
	}

	/**
	 * FolderOpen 16x16 image
	 * 
	 * @return jp.co.sra.smalltalk.StOpaqueImage
	 * @category Folder icons
	 */
	public static StOpaqueImage FolderOpen16x16() {
		if (FolderOpen16x16 == null) {
			FolderOpen16x16 = new StOpaqueImage(FolderOpenFigure16x16(), FolderOpenShape16x16());
		}
		return FolderOpen16x16;

	}

	/**
	 * FolderOpenFigure 16x16 image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Folder icons
	 */
	public static StImage FolderOpenFigure16x16() {
		return new StImage(SystemResourceSupport.createImage("/jp/co/sra/jun/goodies/icon/FolderOpenFigure16x16.png"));
	}

	/**
	 * FolderOpenShape 16x16 image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Folder icons
	 */
	public static StImage FolderOpenShape16x16() {
		return MakeShape_seedColor_(FolderOpenFigure16x16(), Color.red);
	}

	/**
	 * FolderOpen 32x32 image
	 * 
	 * @return jp.co.sra.smalltalk.StOpaqueImage
	 * @category Folder icons
	 */
	public static StOpaqueImage FolderOpen32x32() {
		if (FolderOpen32x32 == null) {
			FolderOpen32x32 = new StOpaqueImage(FolderOpenFigure32x32(), FolderOpenShape32x32());
		}
		return FolderOpen32x32;

	}

	/**
	 * FolderOpenFigure 32x32 image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Folder icons
	 */
	public static StImage FolderOpenFigure32x32() {
		return new StImage(SystemResourceSupport.createImage("/jp/co/sra/jun/goodies/icon/FolderOpenFigure32x32.png"));
	}

	/**
	 * FolderOpenShape 32x32 image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Folder icons
	 */
	public static StImage FolderOpenShape32x32() {
		return MakeShape_seedColor_(FolderOpenFigure32x32(), Color.red);
	}

	/**
	 * FolderOpen 64x64 image
	 * 
	 * @return jp.co.sra.smalltalk.StOpaqueImage
	 * @category Folder icons
	 */
	public static StOpaqueImage FolderOpen64x64() {
		if (FolderOpen64x64 == null) {
			FolderOpen64x64 = new StOpaqueImage(FolderOpenFigure64x64(), FolderOpenShape64x64());
		}
		return FolderOpen64x64;

	}

	/**
	 * FolderOpenFigure 64x64 image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Folder icons
	 */
	public static StImage FolderOpenFigure64x64() {
		return new StImage(SystemResourceSupport.createImage("/jp/co/sra/jun/goodies/icon/FolderOpenFigure64x64.png"));
	}

	/**
	 * FolderOpenShape 64x64 image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Folder icons
	 */
	public static StImage FolderOpenShape64x64() {
		return MakeShape_seedColor_(FolderOpenFigure64x64(), Color.red);
	}

	/**
	 * Image 16x16 image
	 * 
	 * @return jp.co.sra.smalltalk.StOpaqueImage
	 * @category Image icons
	 */
	public static StOpaqueImage Image16x16() {
		if (Image16x16 == null) {
			Image16x16 = new StOpaqueImage(ImageFigure16x16(), ImageShape16x16());
		}
		return Image16x16;
	}

	/**
	 * ImageFigure 16x16 image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Image icons
	 */
	public static StImage ImageFigure16x16() {
		return new StImage(SystemResourceSupport.createImage("/jp/co/sra/jun/goodies/icon/ImageFigure16x16.png"));
	}

	/**
	 * ImageShape 16x16 image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Image icons
	 */
	public static StImage ImageShape16x16() {
		return MakeShape_seedColor_(ImageFigure16x16(), Color.red);
	}

	/**
	 * Image 32x32 image
	 * 
	 * @return jp.co.sra.smalltalk.StOpaqueImage
	 * @category Image icons
	 */
	public static StOpaqueImage Image32x32() {
		if (Image32x32 == null) {
			Image32x32 = new StOpaqueImage(ImageFigure32x32(), ImageShape32x32());
		}
		return Image32x32;
	}

	/**
	 * ImageFigure 32x32 image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Image icons
	 */
	public static StImage ImageFigure32x32() {
		return new StImage(SystemResourceSupport.createImage("/jp/co/sra/jun/goodies/icon/ImageFigure32x32.png"));
	}

	/**
	 * ImageShape 32x32 image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Image icons
	 */
	public static StImage ImageShape32x32() {
		return MakeShape_seedColor_(ImageFigure32x32(), Color.red);
	}

	/**
	 * Image 64x64 image
	 * 
	 * @return jp.co.sra.smalltalk.StOpaqueImage
	 * @category Image icons
	 */
	public static StOpaqueImage Image64x64() {
		if (Image64x64 == null) {
			Image64x64 = new StOpaqueImage(ImageFigure64x64(), ImageShape64x64());
		}
		return Image64x64;
	}

	/**
	 * ImageFigure 64x64 image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Image icons
	 */
	public static StImage ImageFigure64x64() {
		return new StImage(SystemResourceSupport.createImage("/jp/co/sra/jun/goodies/icon/ImageFigure64x64.png"));
	}

	/**
	 * ImageShape 64x64 image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Image icons
	 */
	public static StImage ImageShape64x64() {
		return MakeShape_seedColor_(ImageFigure64x64(), Color.red);
	}

	/**
	 * Movie 16x16 image
	 * 
	 * @return jp.co.sra.smalltalk.StOpaqueImage
	 * @category Movie icons
	 */
	public static StOpaqueImage Movie16x16() {
		if (Movie16x16 == null) {
			Movie16x16 = new StOpaqueImage(MovieFigure16x16(), MovieShape16x16());
		}
		return Movie16x16;
	}

	/**
	 * MovieFigure 16x16 image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Movie icons
	 */
	public static StImage MovieFigure16x16() {
		return new StImage(SystemResourceSupport.createImage("/jp/co/sra/jun/goodies/icon/MovieFigure16x16.png"));
	}

	/**
	 * MovieShape 16x16 image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Movie icons
	 */
	public static StImage MovieShape16x16() {
		return MakeShape_seedColor_(MovieFigure16x16(), Color.red);
	}

	/**
	 * Movie 32x32 image
	 * 
	 * @return jp.co.sra.smalltalk.StOpaqueImage
	 * @category Movie icons
	 */
	public static StOpaqueImage Movie32x32() {
		if (Movie32x32 == null) {
			Movie32x32 = new StOpaqueImage(MovieFigure32x32(), MovieShape32x32());
		}
		return Movie32x32;
	}

	/**
	 * MovieFigure 32x32 image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Movie icons
	 */
	public static StImage MovieFigure32x32() {
		return new StImage(SystemResourceSupport.createImage("/jp/co/sra/jun/goodies/icon/MovieFigure32x32.png"));
	}

	/**
	 * MovieShape 32x32 image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Movie icons
	 */
	public static StImage MovieShape32x32() {
		return MakeShape_seedColor_(MovieFigure32x32(), Color.red);
	}

	/**
	 * Movie 64x64 image
	 * 
	 * @return jp.co.sra.smalltalk.StOpaqueImage
	 * @category Movie icons
	 */
	public static StOpaqueImage Movie64x64() {
		if (Movie64x64 == null) {
			Movie64x64 = new StOpaqueImage(MovieFigure64x64(), MovieShape64x64());
		}
		return Movie64x64;
	}

	/**
	 * MovieFigure 64x64 image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Movie icons
	 */
	public static StImage MovieFigure64x64() {
		return new StImage(SystemResourceSupport.createImage("/jp/co/sra/jun/goodies/icon/MovieFigure64x64.png"));
	}

	/**
	 * MovieShape 64x64 image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Movie icons
	 */
	public static StImage MovieShape64x64() {
		return MakeShape_seedColor_(MovieFigure64x64(), Color.red);
	}

	/**
	 * Sound 16x16 image
	 * 
	 * @return jp.co.sra.smalltalk.StOpaqueImage
	 * @category Sound icons
	 */
	public static StOpaqueImage Sound16x16() {
		if (Sound16x16 == null) {
			Sound16x16 = new StOpaqueImage(SoundFigure16x16(), SoundShape16x16());
		}
		return Sound16x16;
	}

	/**
	 * SoundFigure 16x16 image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Sound icons
	 */
	public static StImage SoundFigure16x16() {
		return new StImage(SystemResourceSupport.createImage("/jp/co/sra/jun/goodies/icon/SoundFigure16x16.png"));
	}

	/**
	 * SoundShape 16x16 image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Sound icons
	 */
	public static StImage SoundShape16x16() {
		return MakeShape_seedColor_(SoundFigure16x16(), Color.red);
	}

	/**
	 * Sound 32x32 image
	 * 
	 * @return jp.co.sra.smalltalk.StOpaqueImage
	 * @category Sound icons
	 */
	public static StOpaqueImage Sound32x32() {
		if (Sound32x32 == null) {
			Sound32x32 = new StOpaqueImage(SoundFigure32x32(), SoundShape32x32());
		}
		return Sound32x32;
	}

	/**
	 * SoundFigure 32x32 image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Sound icons
	 */
	public static StImage SoundFigure32x32() {
		return new StImage(SystemResourceSupport.createImage("/jp/co/sra/jun/goodies/icon/SoundFigure32x32.png"));
	}

	/**
	 * SoundShape 32x32 image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Sound icons
	 */
	public static StImage SoundShape32x32() {
		return MakeShape_seedColor_(SoundFigure32x32(), Color.red);
	}

	/**
	 * Sound 64x64 image
	 * 
	 * @return jp.co.sra.smalltalk.StOpaqueImage
	 * @category Sound icons
	 */
	public static StOpaqueImage Sound64x64() {
		if (Sound64x64 == null) {
			Sound64x64 = new StOpaqueImage(SoundFigure64x64(), SoundShape64x64());
		}
		return Sound64x64;
	}

	/**
	 * SoundFigure 64x64 image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Sound icons
	 */
	public static StImage SoundFigure64x64() {
		return new StImage(SystemResourceSupport.createImage("/jp/co/sra/jun/goodies/icon/SoundFigure64x64.png"));
	}

	/**
	 * SoundShape 64x64 image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Sound icons
	 */
	public static StImage SoundShape64x64() {
		return MakeShape_seedColor_(SoundFigure64x64(), Color.red);
	}

	/**
	 * Text 16x16 image
	 * 
	 * @return jp.co.sra.smalltalk.StOpaqueImage
	 * @category Text icons
	 */
	public static StOpaqueImage Text16x16() {
		if (Text16x16 == null) {
			Text16x16 = new StOpaqueImage(TextFigure16x16(), TextShape16x16());
		}
		return Text16x16;
	}

	/**
	 * TextFigure 16x16 image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Text icons
	 */
	public static StImage TextFigure16x16() {
		return new StImage(SystemResourceSupport.createImage("/jp/co/sra/jun/goodies/icon/TextFigure16x16.png"));
	}

	/**
	 * TextShape 16x16 image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Text icons
	 */
	public static StImage TextShape16x16() {
		return MakeShape_seedColor_(TextFigure16x16(), Color.red);
	}

	/**
	 * Text 32x32 image
	 * 
	 * @return jp.co.sra.smalltalk.StOpaqueImage
	 * @category Text icons
	 */
	public static StOpaqueImage Text32x32() {
		if (Text32x32 == null) {
			Text32x32 = new StOpaqueImage(TextFigure32x32(), TextShape32x32());
		}
		return Text32x32;
	}

	/**
	 * TextFigure 32x32 image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Text icons
	 */
	public static StImage TextFigure32x32() {
		return new StImage(SystemResourceSupport.createImage("/jp/co/sra/jun/goodies/icon/TextFigure32x32.png"));
	}

	/**
	 * TextShape 32x32 image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Text icons
	 */
	public static StImage TextShape32x32() {
		return MakeShape_seedColor_(TextFigure32x32(), Color.red);
	}

	/**
	 * Text 64x64 image
	 * 
	 * @return jp.co.sra.smalltalk.StOpaqueImage
	 * @category Text icons
	 */
	public static StOpaqueImage Text64x64() {
		if (Text64x64 == null) {
			Text64x64 = new StOpaqueImage(TextFigure64x64(), TextShape64x64());
		}
		return Text64x64;
	}

	/**
	 * TextFigure 64x64 image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Text icons
	 */
	public static StImage TextFigure64x64() {
		return new StImage(SystemResourceSupport.createImage("/jp/co/sra/jun/goodies/icon/TextFigure64x64.png"));
	}

	/**
	 * TextShape 64x64 image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Text icons
	 */
	public static StImage TextShape64x64() {
		return MakeShape_seedColor_(TextFigure64x64(), Color.red);
	}

	/**
	 * Body 16x16 image
	 * 
	 * @return jp.co.sra.smalltalk.StOpaqueImage
	 * @category Body icons
	 */
	public static StOpaqueImage Body16x16() {
		if (Body16x16 == null) {
			Body16x16 = new StOpaqueImage(BodyFigure16x16(), BodyShape16x16());
		}
		return Body16x16;
	}

	/**
	 * BodyFigure 16x16 image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Body icons
	 */
	public static StImage BodyFigure16x16() {
		return new StImage(SystemResourceSupport.createImage("/jp/co/sra/jun/goodies/icon/BodyFigure16x16.png"));
	}

	/**
	 * BodyShape 16x16 image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Body icons
	 */
	public static StImage BodyShape16x16() {
		return MakeShape_seedColor_(BodyFigure16x16(), Color.green);
	}

	/**
	 * Body 32x32 image
	 * 
	 * @return jp.co.sra.smalltalk.StOpaqueImage
	 * @category Body icons
	 */
	public static StOpaqueImage Body32x32() {
		if (Body32x32 == null) {
			Body32x32 = new StOpaqueImage(BodyFigure32x32(), BodyShape32x32());
		}
		return Body32x32;
	}

	/**
	 * BodyFigure 32x32 image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Body icons
	 */
	public static StImage BodyFigure32x32() {
		return new StImage(SystemResourceSupport.createImage("/jp/co/sra/jun/goodies/icon/BodyFigure32x32.png"));
	}

	/**
	 * BodyShape 32x32 image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Body icons
	 */
	public static StImage BodyShape32x32() {
		return MakeShape_seedColor_(BodyFigure32x32(), Color.green);
	}

	/**
	 * Body 64x64 image
	 * 
	 * @return jp.co.sra.smalltalk.StOpaqueImage
	 * @category Body icons
	 */
	public static StOpaqueImage Body64x64() {
		if (Body64x64 == null) {
			Body64x64 = new StOpaqueImage(BodyFigure64x64(), BodyShape64x64());
		}
		return Body64x64;
	}

	/**
	 * BodyFigure 64x64 image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Body icons
	 */
	public static StImage BodyFigure64x64() {
		return new StImage(SystemResourceSupport.createImage("/jp/co/sra/jun/goodies/icon/BodyFigure64x64.png"));
	}

	/**
	 * BodyShape 64x64 image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Body icons
	 */
	public static StImage BodyShape64x64() {
		return MakeShape_seedColor_(BodyFigure64x64(), Color.green);
	}

	/**
	 * Other 16x16 image
	 * 
	 * @return jp.co.sra.smalltalk.StOpaqueImage
	 * @category Other icons
	 */
	public static StOpaqueImage Other16x16() {
		if (Other16x16 == null) {
			Other16x16 = new StOpaqueImage(OtherFigure16x16(), OtherShape16x16());
		}
		return Other16x16;
	}

	/**
	 * OtherFigure 16x16 image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Other icons
	 */
	public static StImage OtherFigure16x16() {
		return new StImage(SystemResourceSupport.createImage("/jp/co/sra/jun/goodies/icon/OtherFigure16x16.png"));
	}

	/**
	 * OtherShape 16x16 image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Other icons
	 */
	public static StImage OtherShape16x16() {
		return MakeShape_seedColor_(OtherFigure16x16(), Color.red);
	}

	/**
	 * Other 32x32 image
	 * 
	 * @return jp.co.sra.smalltalk.StOpaqueImage
	 * @category Other icons
	 */
	public static StOpaqueImage Other32x32() {
		if (Other32x32 == null) {
			Other32x32 = new StOpaqueImage(OtherFigure32x32(), OtherShape32x32());
		}
		return Other32x32;
	}

	/**
	 * OtherFigure 32x32 image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Other icons
	 */
	public static StImage OtherFigure32x32() {
		return new StImage(SystemResourceSupport.createImage("/jp/co/sra/jun/goodies/icon/OtherFigure32x32.png"));
	}

	/**
	 * OtherShape 32x32 image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Other icons
	 */
	public static StImage OtherShape32x32() {
		return MakeShape_seedColor_(OtherFigure32x32(), Color.red);
	}

	/**
	 * Other 64x64 image
	 * 
	 * @return jp.co.sra.smalltalk.StOpaqueImage
	 * @category Other icons
	 */
	public static StOpaqueImage Other64x64() {
		if (Other64x64 == null) {
			Other64x64 = new StOpaqueImage(OtherFigure64x64(), OtherShape64x64());
		}
		return Other64x64;
	}

	/**
	 * OtherFigure 64x64 image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Other icons
	 */
	public static StImage OtherFigure64x64() {
		return new StImage(SystemResourceSupport.createImage("/jp/co/sra/jun/goodies/icon/OtherFigure64x64.png"));
	}

	/**
	 * OtherShape 64x64 image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Other icons
	 */
	public static StImage OtherShape64x64() {
		return MakeShape_seedColor_(OtherFigure64x64(), Color.red);
	}

	/**
	 * Empty 16x16 image
	 * 
	 * @return jp.co.sra.smalltalk.StOpaqueImage
	 * @category Empty icons
	 */
	public static StOpaqueImage Empty16x16() {
		if (Empty16x16 == null) {
			Empty16x16 = new StOpaqueImage(EmptyFigure16x16(), EmptyShape16x16());
		}
		return Empty16x16;
	}

	/**
	 * EmptyFigure 16x16 image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Empty icons
	 */
	public static StImage EmptyFigure16x16() {
		StImage anImage = new StImage(16, 16);
		JunImageProcessor.Fill_color_(anImage, Color.white);
		return anImage;
	}

	/**
	 * EmptyShape 16x16 image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Empty icons
	 */
	public static StImage EmptyShape16x16() {
		return MakeShape_seedColor_(EmptyFigure16x16(), Color.red);
	}

	/**
	 * Empty 32x32 image
	 * 
	 * @return jp.co.sra.smalltalk.StOpaqueImage
	 * @category Empty icons
	 */
	public static StOpaqueImage Empty32x32() {
		if (Empty32x32 == null) {
			Empty32x32 = new StOpaqueImage(EmptyFigure32x32(), EmptyShape32x32());
		}
		return Empty32x32;
	}

	/**
	 * EmptyFigure 32x32 image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Empty icons
	 */
	public static StImage EmptyFigure32x32() {
		StImage anImage = new StImage(32, 32);
		JunImageProcessor.Fill_color_(anImage, Color.white);
		return anImage;
	}

	/**
	 * EmptyShape 32x32 image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Empty icons
	 */
	public static StImage EmptyShape32x32() {
		return MakeShape_seedColor_(EmptyFigure32x32(), Color.red);
	}

	/**
	 * Empty 64x64 image
	 * 
	 * @return jp.co.sra.smalltalk.StOpaqueImage
	 * @category Empty icons
	 */
	public static StOpaqueImage Empty64x64() {
		if (Empty64x64 == null) {
			Empty64x64 = new StOpaqueImage(EmptyFigure64x64(), EmptyShape64x64());
		}
		return Empty64x64;
	}

	/**
	 * EmptyFigure 64x64 image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Empty icons
	 */
	public static StImage EmptyFigure64x64() {
		StImage anImage = new StImage(64, 64);
		JunImageProcessor.Fill_color_(anImage, Color.white);
		return anImage;
	}

	/**
	 * EmptyShape 64x64 image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Empty icons
	 */
	public static StImage EmptyShape64x64() {
		return MakeShape_seedColor_(EmptyFigure64x64(), Color.red);
	}

	/**
	 * Triangle 16x16 image
	 * 
	 * @return jp.co.sra.smalltalk.StOpaqueImage
	 * @category Triangle icons
	 */
	public static StOpaqueImage Triangle16x16() {
		if (Triangle16x16 == null) {
			Triangle16x16 = new StOpaqueImage(TriangleFigure16x16(), TriangleShape16x16());
		}
		return Triangle16x16;
	}

	/**
	 * TriangleFigure 16x16 image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Triangle icons
	 */
	public static StImage TriangleFigure16x16() {
		return new StImage(SystemResourceSupport.createImage("/jp/co/sra/jun/goodies/icon/TriangleFigure16x16.png"));
	}

	/**
	 * TriangleShape 16x16 image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Triangle icons
	 */
	public static StImage TriangleShape16x16() {
		return MakeShape_seedColor_(TriangleFigure16x16(), Color.red);
	}

	/**
	 * ConcentricArrangement 32x32 image
	 * 
	 * @return jp.co.sra.smalltalk.StOpaqueImage
	 * @category Arrangement icons
	 */
	public static StOpaqueImage ConcentricArrangement32x32() {
		if (ConcentricArrangement32x32 == null) {
			ConcentricArrangement32x32 = new StOpaqueImage(ConcentricArrangementFigure32x32(), ConcentricArrangementShape32x32());
		}
		return ConcentricArrangement32x32;
	}

	/**
	 * ConcentricArrangementFigure 32x32 image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Arrangement icons
	 */
	public static StImage ConcentricArrangementFigure32x32() {
		return new StImage(SystemResourceSupport.createImage("/jp/co/sra/jun/goodies/icon/ConcentricArrangementFigure32x32.png"));
	}

	/**
	 * ConcentricArrangementShape 32x32 image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Arrangement icons
	 */
	public static StImage ConcentricArrangementShape32x32() {
		StImage anImage = new StImage(SystemResourceSupport.createImage("/jp/co/sra/jun/goodies/icon/ConcentricArrangementShape32x32.png"));
		return anImage.convertToPalette_(StImage.MonoMaskColorModel());
	}

	/**
	 * OriginalArrangement 32x32 image
	 * 
	 * @return jp.co.sra.smalltalk.StOpaqueImage
	 * @category Arrangement icons
	 */
	public static StOpaqueImage OriginalArrangement32x32() {
		if (OriginalArrangement32x32 == null) {
			OriginalArrangement32x32 = new StOpaqueImage(OriginalArrangementFigure32x32(), OriginalArrangementShape32x32());
		}
		return OriginalArrangement32x32;
	}

	/**
	 * OriginalArrangementFigure 32x32 image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Arrangement icons
	 */
	public static StImage OriginalArrangementFigure32x32() {
		return new StImage(SystemResourceSupport.createImage("/jp/co/sra/jun/goodies/icon/OriginalArrangementFigure32x32.png"));
	}

	/**
	 * OriginalArrangementShape 32x32 image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Arrangement icons
	 */
	public static StImage OriginalArrangementShape32x32() {
		return MakeShape_seedColor_(OriginalArrangementFigure32x32(), Color.red);
	}

	/**
	 * TreeArrangement 32x32 image
	 * 
	 * @return jp.co.sra.smalltalk.StOpaqueImage
	 * @category Arrangement icons
	 */
	public static StOpaqueImage TreeArrangement32x32() {
		if (TreeArrangement32x32 == null) {
			TreeArrangement32x32 = new StOpaqueImage(TreeArrangementFigure32x32(), TreeArrangementShape32x32());
		}
		return TreeArrangement32x32;
	}

	/**
	 * TreeArrangementFigure 32x32 image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Arrangement icons
	 */
	public static StImage TreeArrangementFigure32x32() {
		return new StImage(SystemResourceSupport.createImage("/jp/co/sra/jun/goodies/icon/TreeArrangementFigure32x32.png"));
	}

	/**
	 * TreeArrangementShape 32x32 image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Arrangement icons
	 */
	public static StImage TreeArrangementShape32x32() {
		return MakeShape_seedColor_(TreeArrangementFigure32x32(), Color.red);
	}

	/**
	 * DictionaryBlack 32x32 image
	 * 
	 * @return jp.co.sra.smalltalk.StOpaqueImage
	 * @category Dictionary icons
	 */
	public static StOpaqueImage DictionaryBlack32x32() {
		if (DictionaryBlack32x32 == null) {
			DictionaryBlack32x32 = new StOpaqueImage(DictionaryBlackFigure32x32(), DictionaryBlackShape32x32());
		}
		return DictionaryBlack32x32;
	}

	/**
	 * DictionaryBlackFigure 32x32 image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Dictionary icons
	 */
	public static StImage DictionaryBlackFigure32x32() {
		return new StImage(SystemResourceSupport.createImage("/jp/co/sra/jun/goodies/icon/DictionaryBlackFigure32x32.png"));
	}

	/**
	 * DictionaryBlackShape 32x32 image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Dictionary icons
	 */
	public static StImage DictionaryBlackShape32x32() {
		return MakeShape_seedColor_(DictionaryBlackFigure32x32(), Color.red);
	}

	/**
	 * DictionaryWhite 32x32 image
	 * 
	 * @return jp.co.sra.smalltalk.StOpaqueImage
	 * @category Dictionary icons
	 */
	public static StOpaqueImage DictionaryWhite32x32() {
		if (DictionaryWhite32x32 == null) {
			DictionaryWhite32x32 = new StOpaqueImage(DictionaryWhiteFigure32x32(), DictionaryWhiteShape32x32());
		}
		return DictionaryWhite32x32;
	}

	/**
	 * DictionaryWhiteFigure 32x32 image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Dictionary icons
	 */
	public static StImage DictionaryWhiteFigure32x32() {
		return new StImage(SystemResourceSupport.createImage("/jp/co/sra/jun/goodies/icon/DictionaryWhiteFigure32x32.png"));
	}

	/**
	 * DictionaryWhiteShape 32x32 image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Dictionary icons
	 */
	public static StImage DictionaryWhiteShape32x32() {
		return MakeShape_seedColor_(DictionaryWhiteFigure32x32(), Color.red);
	}

	/**
	 * PencilBold 32x32 image
	 * 
	 * @return jp.co.sra.smalltalk.StOpaqueImage
	 * @category Pencil icons
	 */
	public static StOpaqueImage PencilBold32x32() {
		if (PencilBold32x32 == null) {
			PencilBold32x32 = new StOpaqueImage(PencilBoldFigure32x32(), PencilBoldShape32x32());
		}
		return PencilBold32x32;
	}

	/**
	 * PencilBoldFigure 32x32 image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Pencil icons
	 */
	public static StImage PencilBoldFigure32x32() {
		return new StImage(SystemResourceSupport.createImage("/jp/co/sra/jun/goodies/icon/PencilBoldFigure32x32.png"));
	}

	/**
	 * PencilBoldShape 32x32 image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Pencil icons
	 */
	public static StImage PencilBoldShape32x32() {
		return MakeShape_seedColor_(PencilBoldFigure32x32(), Color.red);
	}

	/**
	 * PencilBlack 32x32 image
	 * 
	 * @return jp.co.sra.smalltalk.StOpaqueImage
	 * @category Pencil icons
	 */
	public static StOpaqueImage PencilBlack32x32() {
		if (PencilBlack32x32 == null) {
			PencilBlack32x32 = new StOpaqueImage(PencilBlackFigure32x32(), PencilBlackShape32x32());
		}
		return PencilBlack32x32;
	}

	/**
	 * PencilBlackFigure 32x32 image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Pencil icons
	 */
	public static StImage PencilBlackFigure32x32() {
		return new StImage(SystemResourceSupport.createImage("/jp/co/sra/jun/goodies/icon/PencilBlackFigure32x32.png"));
	}

	/**
	 * PencilBlackShape 32x32 image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Pencil icons
	 */
	public static StImage PencilBlackShape32x32() {
		return MakeShape_seedColor_(PencilBlackFigure32x32(), Color.red);
	}

	/**
	 * PencilWhite 32x32 image
	 * 
	 * @return jp.co.sra.smalltalk.StOpaqueImage
	 * @category Pencil icons
	 */
	public static StOpaqueImage PencilWhite32x32() {
		if (PencilWhite32x32 == null) {
			PencilWhite32x32 = new StOpaqueImage(PencilWhiteFigure32x32(), PencilWhiteShape32x32());
		}
		return PencilWhite32x32;
	}

	/**
	 * PencilWhiteFigure 32x32 image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Pencil icons
	 */
	public static StImage PencilWhiteFigure32x32() {
		return new StImage(SystemResourceSupport.createImage("/jp/co/sra/jun/goodies/icon/PencilWhiteFigure32x32.png"));
	}

	/**
	 * PencilWhiteShape 32x32 image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Pencil icons
	 */
	public static StImage PencilWhiteShape32x32() {
		return MakeShape_seedColor_(PencilWhiteFigure32x32(), Color.red);
	}

	/**
	 * Freehand 32x32 image
	 * 
	 * @return jp.co.sra.smalltalk.StOpaqueImage
	 * @category Operation icons
	 */
	public static StOpaqueImage Freehand32x32() {
		if (Freehand32x32 == null) {
			Freehand32x32 = new StOpaqueImage(FreehandFigure32x32(), FreehandShape32x32());
		}
		return Freehand32x32;
	}

	/**
	 * FreehandFigure 32x32 image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Operation icons
	 */
	public static StImage FreehandFigure32x32() {
		return new StImage(SystemResourceSupport.createImage("/jp/co/sra/jun/goodies/icon/FreehandFigure32x32.png"));
	}

	/**
	 * FreehandShape 32x32 image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Operation icons
	 */
	public static StImage FreehandShape32x32() {
		StImage anImage = new StImage(SystemResourceSupport.createImage("/jp/co/sra/jun/goodies/icon/FreehandShape32x32.png"));
		return anImage.convertToPalette_(StImage.MonoMaskColorModel());
	}

	/**
	 * TextAcceptOK 32x32 image
	 * 
	 * @return jp.co.sra.smalltalk.StOpaqueImage
	 * @category Operation icons
	 */
	public static StOpaqueImage TextAcceptOK32x32() {
		if (TextAcceptOK32x32 == null) {
			TextAcceptOK32x32 = new StOpaqueImage(TextAcceptOKFigure32x32(), TextAcceptOKShape32x32());
		}
		return TextAcceptOK32x32;
	}

	/**
	 * TextAcceptOKFigure 32x32 image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Operation icons
	 */
	public static StImage TextAcceptOKFigure32x32() {
		return new StImage(SystemResourceSupport.createImage("/jp/co/sra/jun/goodies/icon/TextAcceptOKFigure32x32.png"));
	}

	/**
	 * TextAcceptOKShape 32x32 image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Operation icons
	 */
	public static StImage TextAcceptOKShape32x32() {
		return MakeShape_seedColor_(TextAcceptOKFigure32x32(), Color.red);
	}

	/**
	 * TextAcceptThumbUp 32x32 image
	 * 
	 * @return jp.co.sra.smalltalk.StOpaqueImage
	 * @category Operation icons
	 */
	public static StOpaqueImage TextAcceptThumbUp32x32() {
		if (TextAcceptThumbUp32x32 == null) {
			TextAcceptThumbUp32x32 = new StOpaqueImage(TextAcceptThumbUpFigure32x32(), TextAcceptThumbUpShape32x32());
		}
		return TextAcceptThumbUp32x32;
	}

	/**
	 * TextAcceptThumbUpFigure 32x32 image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Operation icons
	 */
	public static StImage TextAcceptThumbUpFigure32x32() {
		return new StImage(SystemResourceSupport.createImage("/jp/co/sra/jun/goodies/icon/TextAcceptThumbUpFigure32x32.png"));
	}

	/**
	 * TextAcceptThumbUpShape 32x32 image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Operation icons
	 */
	public static StImage TextAcceptThumbUpShape32x32() {
		return MakeShape_seedColor_(TextAcceptThumbUpFigure32x32(), Color.red);
	}

	/**
	 * Make a shape image from the image and the seed color.
	 * 
	 * @param anImage jp.co.sra.smalltalk.StImage
	 * @param aColor java.awt.Color
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Utilities
	 */
	protected static StImage MakeShape_seedColor_(StImage anImage, Color aColor) {
		StImage sourceImage = (StImage) anImage.clone();
		StImage destinationImage = new StImage(sourceImage.width() + 2, sourceImage.height() + 2, sourceImage.colorModel());
		JunImageProcessor.Fill_color_(destinationImage, Color.white);
		destinationImage.copy_from_in_rule_(new Rectangle(1, 1, sourceImage.width(), sourceImage.height()), new Point(0, 0), sourceImage, StImage.Over);
		JunImageProcessor.Fill_seed_color_(destinationImage, new Point(0, 0), aColor);
		sourceImage = destinationImage;
		destinationImage = new StImage(sourceImage.width() - 2, sourceImage.height() - 2, sourceImage.colorModel());
		JunImageProcessor.Fill_color_(destinationImage, Color.white);
		destinationImage.copy_from_in_rule_(destinationImage.bounds(), new Point(1, 1), sourceImage, StImage.Over);
		sourceImage = JunImageProcessor.Juice_strongly_color_(destinationImage, 0.99, aColor);
		destinationImage = new StImage(sourceImage.width(), sourceImage.height(), sourceImage.colorModel());
		JunImageProcessor.Fill_color_(destinationImage, Color.black);
		destinationImage.copy_from_in_rule_(destinationImage.bounds(), new Point(0, 0), sourceImage, StImage.Reverse);

		// instead of using CoveragePalette monoMaskPalette.
		BufferedImage shapeImage = new BufferedImage(destinationImage.width(), destinationImage.height(), BufferedImage.TYPE_BYTE_BINARY, StImage.MonoMaskColorModel());
		shapeImage.setData(destinationImage.image().getData());
		destinationImage = new StImage(shapeImage);

		return destinationImage;
	}

}
