package jp.co.sra.jun.goodies.gauge;

import java.awt.Rectangle;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunGaugeModelTestExamples class
 * 
 *  @author    nisinaka
 *  @created   2004/04/13 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun491 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunGaugeModelTestExamples.java,v 8.10 2008/02/20 06:31:34 nisinaka Exp $
 */
public class JunGaugeModelTestExamples extends JunTestExamples {

	/**
	 * Example1: Open a JunGaugeModel.
	 * 
	 * @return boolean
	 */
	public static boolean Example1() {
		JunGaugeModel gaugeModel = new JunGaugeModel(20);
		gaugeModel.compute_(new StBlockClosure() {
			public Object value_(Object newValue) {
				System.out.println(newValue);
				return null;
			}
		});
		gaugeModel.open();

		return true;
	}

	/**
	 * Example2: Open two JunGaugeModels.
	 * 
	 * @return boolean
	 */
	public static boolean Example2() {
		final JunGaugeModel gaugeModel = new JunGaugeModel(-20, new double[] { -100, 100, 10, 1 });
		gaugeModel.openIn_(new Rectangle(200, 200, 100, 200));
		gaugeModel.openIn_(new Rectangle(400, 200, 100, 200));

		(new Thread() {
			public void run() {
				try {
					Thread.sleep(500);
					for (double v = gaugeModel.fromValue(); v <= gaugeModel.toValue(); v += gaugeModel.roundValue()) {
						Thread.sleep(25);
						gaugeModel.value_(v);
					}
					for (double v = gaugeModel.toValue(); v >= gaugeModel.fromValue(); v -= gaugeModel.roundValue()) {
						Thread.sleep(25);
						gaugeModel.value_(v);
					}
				} catch (InterruptedException e) {
					e.printStackTrace();
				}

				gaugeModel.closeRequest();
			}
		}).start();

		return true;
	}

	/**
	 * Example5: Open a JunGaugeModel.
	 * 
	 * @return boolean
	 */
	public static boolean Example5() {
		JunGaugeModel gaugeModel = new JunGaugeModel(0.5, 0, 1, 0.01);
		gaugeModel.compute_(new StBlockClosure() {
			public Object value_(Object newValue) {
				System.out.println(newValue);
				return null;
			}
		});
		gaugeModel.open();

		return true;
	}

	/**
	 * Example6: Open a JunGaugeModel.
	 * 
	 * @return boolean
	 */
	public static boolean Example6() {
		JunGaugeModel gaugeModel = new JunGaugeModel(50, 100, -100, 2);
		gaugeModel.compute_(new StBlockClosure() {
			public Object value_(Object newValue) {
				System.out.println(newValue);
				return null;
			}
		});
		gaugeModel.open();

		return true;
	}

	/**
	 * Execute all examples.
	 *
	 * @param args java.lang.String[]
	 */
	public static void main(String[] args) {
		new JunGaugeModelTestExamples();
	}

}
