package jp.co.sra.jun.goodies.font;

import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ScrollPaneConstants;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

import jp.co.sra.smalltalk.WindowSpecLayout;

import jp.co.sra.jun.goodies.display.JunDisplayViewSwing;
import jp.co.sra.jun.system.framework.JunAbstractViewJPanel;

/**
 * JunFontViewSwing class
 * 
 *  @author    nisinaka
 *  @created   2003/02/28 (by nisinaka)
 *  @updated   2004/09/21 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun642 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunFontViewSwing.java,v 8.12 2008/02/20 06:31:33 nisinaka Exp $
 */
public class JunFontViewSwing extends JunAbstractViewJPanel implements JunFontView {

	protected JunDisplayViewSwing displayView;
	protected JList fontNameList;
	protected JScrollPane fontNameScrollPane;
	protected JList fontSizeList;
	protected JScrollPane fontSizeScrollPane;

	/**
	 * Create a new instance of JunFontViewSwing and initialize it with the JunFontModel.
	 *
	 * @param newFontModel jp.co.sra.jun.goodies.font.JunFontModel
	 * @category Instance creation
	 */
	public JunFontViewSwing(JunFontModel newFontModel) {
		super(newFontModel);
	}

	/**
	 * Build this component.
	 * 
	 * @see jp.co.sra.smalltalk.StViewPanel#buildComponent()
	 * @category initialize-release
	 */
	protected void buildComponent() {
		this.setLayout(new WindowSpecLayout());
		this.add(this.displayView(), WindowSpecLayout.Position(0f, 1, 0f, 1, 1f, -1, 0f, 79));
		this.add(this.fontNameScrollPane(), WindowSpecLayout.Position(0f, 1, 0f, 80, 0.7f, -1, 1f, -1));
		this.add(this.fontSizeScrollPane(), WindowSpecLayout.Position(0.7f, 0, 0f, 80, 1f, -1, 1f, -1));
		this.setPreferredSize(new Dimension(350, 250));
	}

	/**
	 * Add WindowListener to make a selection visible.
	 * JList#ensureIndexIsVisible does not work before a window is opened.
	 * 
	 * @see jp.co.sra.smalltalk.StViewPanel#addNotify()
	 * @category initialize-release
	 */
	public void addNotify() {
		super.addNotify();

		this.topComponent().addWindowListener(new WindowAdapter() {
			public void windowOpened(WindowEvent e) {
				super.windowOpened(e);
				updateFontNameList();
				updateFontSizeList();
			}
		});
	}

	/**
	 * Answer my model as a JunFontModel.
	 *
	 * @return jp.co.sra.jun.goodies.font.JunFontModel
	 * @see jp.co.sra.jun.goodies.font.JunFontView#getFontModel()
	 * @category model accessing
	 */
	public JunFontModel getFontModel() {
		return (JunFontModel) this.model();
	}

	/**
	 * Answer my display view.
	 *
	 * @return jp.co.sra.jun.goodies.display.JunDisplayViewSwing
	 * @category user interface
	 */
	protected JunDisplayViewSwing displayView() {
		if (displayView == null) {
			displayView = new JunDisplayViewSwing(this.getFontModel().displayModel());
		}

		return displayView;
	}

	/**
	 * Answer my font name list.
	 *
	 * @return javax.swing.JList
	 * @category user interface
	 */
	protected JList fontNameList() {
		if (fontNameList == null) {
			fontNameList = new JList(new DefaultListModel());
			fontNameList.addListSelectionListener(new ListSelectionListener() {
				public void valueChanged(ListSelectionEvent e) {
					getFontModel().setFontNameIndex(fontNameList.getSelectedIndex());
				}
			});
		}
		return fontNameList;
	}

	/**
	 * Answer my font name scroll pane.
	 *
	 * @return javax.swing.JScrollPane
	 * @category user interface
	 */
	protected JScrollPane fontNameScrollPane() {
		if (fontNameScrollPane == null) {
			fontNameScrollPane = new JScrollPane(this.fontNameList(), ScrollPaneConstants.VERTICAL_SCROLLBAR_AS_NEEDED, ScrollPaneConstants.HORIZONTAL_SCROLLBAR_AS_NEEDED);
		}
		return fontNameScrollPane;
	}

	/**
	 * Answer my font size list.
	 *
	 * @return javax.swing.JList
	 * @category user interface
	 */
	protected JList fontSizeList() {
		if (fontSizeList == null) {
			fontSizeList = new JList(new DefaultListModel());
			fontSizeList.addListSelectionListener(new ListSelectionListener() {
				public void valueChanged(ListSelectionEvent e) {
					if (e.getValueIsAdjusting()) {
						return;
					}
					getFontModel().setFontSizeIndex(fontSizeList.getSelectedIndex());
				}
			});
		}
		return fontSizeList;
	}

	/**
	 * Answer my font size scroll pane.
	 *
	 * @return javax.swing.JScrollPane
	 * @category user interface
	 */
	protected JScrollPane fontSizeScrollPane() {
		if (fontSizeScrollPane == null) {
			fontSizeScrollPane = new JScrollPane(this.fontSizeList(), ScrollPaneConstants.VERTICAL_SCROLLBAR_AS_NEEDED, ScrollPaneConstants.HORIZONTAL_SCROLLBAR_AS_NEEDED);
		}

		return fontSizeScrollPane;
	}

	/**
	 * Update the font name list.
	 * 
	 * @category updating
	 */
	protected void updateFontNameList() {
		DefaultListModel model = (DefaultListModel) this.fontNameList().getModel();
		model.clear();

		String[] fontNames = this.getFontModel().fontNames();
		for (int i = 0; i < fontNames.length; i++) {
			model.add(i, fontNames[i]);
		}

		int fontNameIndex = this.getFontModel().getFontNameIndex();
		if (fontNameIndex >= 0) {
			this.fontNameList().setSelectedIndex(fontNameIndex);
			this.fontNameList().ensureIndexIsVisible(fontNameIndex);
		}
	}

	/**
	 * Update the font size list.
	 * 
	 * @category updating
	 */
	protected void updateFontSizeList() {
		DefaultListModel model = (DefaultListModel) this.fontSizeList().getModel();
		model.clear();

		int[] fontSizes = this.getFontModel().fontSizes();
		for (int i = 0; i < fontSizes.length; i++) {
			model.add(i, String.valueOf(fontSizes[i]));
		}

		int fontSizeIndex = this.getFontModel().getFontSizeIndex();
		if (fontSizeIndex >= 0) {
			this.fontSizeList().setSelectedIndex(fontSizeIndex);
			this.fontSizeList().ensureIndexIsVisible(fontSizeIndex);
		}
	}

}
