package jp.co.sra.jun.goodies.font;

import java.awt.Dialog;
import java.awt.Font;

import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StSimpleDialog;
import jp.co.sra.smalltalk.StView;

/**
 * JunFontDialog class
 * 
 *  @author    nisinaka
 *  @created   2003/03/03 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun373 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunFontDialog.java,v 8.11 2008/02/20 06:31:33 nisinaka Exp $
 */
public class JunFontDialog extends StSimpleDialog {

	protected JunFontModel fontModel;
	protected StBlockClosure acceptBlock;
	protected StBlockClosure cancelBlock;
	protected Font font;

	/**
	 * Open a font dialog and request to choose a font.
	 *
	 * @return java.awt.Font
	 * @category Utilities
	 */
	public static Font Request() {
		JunFontDialog fontDialog = new JunFontDialog();
		fontDialog.openDialog();
		return fontDialog.font();
	}

	/**
	 * Open a font dialog showing a font and request to choose a font.
	 *
	 * @return java.awt.Font
	 * @param font java.awt.Font
	 * @category Utilities
	 */
	public static Font Request(Font font) {
		JunFontDialog fontDialog = new JunFontDialog();
		fontDialog.fontName_(font.getName());
		fontDialog.fontSize_(font.getSize());
		fontDialog.openDialog();
		return fontDialog.font();
	}

	/**
	 * Initialize the receiver.
	 * 
	 * @see jp.co.sra.smalltalk.StSimpleDialog#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();

		fontModel = null;
		acceptBlock = new StBlockClosure() {
			public Object value() {
				font = fontModel().getFont();
				return null;
			}
		};
		cancelBlock = new StBlockClosure() {
			public Object value() {
				font = null;
				return null;
			}
		};
		font = null;
	}

	/**
	 * Answer the current font model.
	 *
	 * @return jp.co.sra.jun.goodies.font.JunFontModel
	 * @category accessing
	 */
	public JunFontModel fontModel() {
		if (fontModel == null) {
			fontModel = new JunFontModel();
		}
		return fontModel;
	}

	/**
	 * Answer the current font name.
	 *
	 * @return java.lang.String
	 * @category accessing
	 */
	public String fontName() {
		return this.fontModel().fontName();
	}

	/**
	 * Set the new font name.
	 *
	 * @param newFontName java.lang.String
	 * @category accessing
	 */
	public void fontName_(String newFontName) {
		this.fontModel().fontName_(newFontName);
	}

	/**
	 * Answer the current font size.
	 *
	 * @return int
	 * @category accessing
	 */
	public int fontSize() {
		return this.fontModel().fontSize();
	}

	/**
	 * Set the new font size.
	 *
	 * @param newFontSize int
	 * @category accessing
	 */
	public void fontSize_(int newFontSize) {
		this.fontModel().fontSize_(newFontSize);
	}

	/**
	 * Answer the current font.
	 *
	 * @return java.awt.Font
	 * @category accessing
	 */
	public Font font() {
		return font;
	}

	/**
	 * Set the new accept block.
	 *
	 * @param newAcceptBlock jp.co.sra.smalltalk.StBlockClosure
	 * @category accessing
	 */
	protected void acceptBlock_(StBlockClosure newAcceptBlock) {
		acceptBlock = newAcceptBlock;
	}

	/**
	 * Set the new cancel block.
	 *
	 * @param newCancelBlock jp.co.sra.smalltalk.StBlockClosure
	 * @category accessing
	 */
	protected void cancelBlock_(StBlockClosure newCancelBlock) {
		cancelBlock = newCancelBlock;
	}

	/**
	 * Called when an accept button is pressed.
	 *
	 * @return boolean
	 * @category actions
	 */
	public boolean acceptButtonPressed() {
		if (acceptBlock != null) {
			acceptBlock.value();
		}
		return true;
	}

	/**
	 * Called when an cancel button is pressed.
	 *
	 * @return boolean
	 * @category actions
	 */
	public boolean cancelButtonPressed() {
		if (cancelBlock != null) {
			cancelBlock.value();
		}
		return true;
	}

	/**
	 * Answer a default view.
	 * 
	 * @return jp.co.sra.smalltalk.StView
	 * @category interface opening
	 */
	public StView defaultView() {
		if (GetDefaultViewMode() == VIEW_AWT) {
			return new JunFontDialogViewAwt(this);
		} else {
			return new JunFontDialogViewSwing(this);
		}
	}

	/**
	 * Answer a window title.
	 * 
	 * @return java.lang.String
	 * @category interface opening
	 */
	protected String windowTitle() {
		return $String("Font Dialog");
	}

	/**
	 * Do everything short of actually opening the window.
	 *
	 * @return java.awt.Dialog
	 * @category interface opening
	 */
	protected Dialog allButOpenDialog() {
		Dialog aDialog = super.allButOpenDialog();
		this.fontModel().updateVisualObject();
		return aDialog;
	}

}
