package jp.co.sra.jun.goodies.files;

import java.io.File;

import jp.co.sra.smalltalk.StBlockClosure;

import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunFileModelTestExamples class
 * 
 *  @author    nisinaka
 *  @created   2003/03/05 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun433 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunFileModelTestExamples.java,v 8.10 2008/02/20 06:31:33 nisinaka Exp $
 */
public class JunFileModelTestExamples extends JunTestExamples {

	/**
	 * Example1: Open a JunFileModel.
	 * 
	 * @return boolean
	 */
	public static boolean Example1() {
		JunFileModel fileModel = new JunFileModel();
		fileModel.open();
		return true;
	}

	/**
	 * Example2: Create a FileModel with computing a new value and open it.
	 * 
	 * @return boolean
	 */
	public static boolean Example2() {
		JunFileModel fileModel = new JunFileModel();
		fileModel.compute_(new StBlockClosure() {
			public Object value_(Object newValue) {
				System.out.println(newValue);
				return null;
			}
		});
		fileModel.open();
		return true;
	}

	/**
	 * Example3: Create a FileModel with computing a new value, assign an initial value, and open it.
	 * 
	 * @return boolean
	 */
	public static boolean Example3() {
		JunFileModel fileModel = new JunFileModel();
		fileModel.compute_(new StBlockClosure() {
			public Object value_(Object newValue) {
				System.out.println(newValue);
				return null;
			}
		});
		fileModel.value_(new File(JunFileModel.DefaultDirectory(), "zzz.st"));
		fileModel.open();
		return true;
	}

	/**
	 * Example4: Create a FileModel with file type specified, computing a new value, assign an initial value, and open it.
	 * 
	 * @return boolean
	 */
	public static boolean Example4() {
		JunFileModel.FileType[] fileTypes = new JunFileModel.FileType[] {
				JunFileModel.FileType.All("all files (*.*)"),
				new JunFileModel.FileType("java files (*.java)", new String[] { "*.java", "*.JAVA" }),
				new JunFileModel.FileType("text files (*.txt)", new String[] { "*.txt", "*.TXT" }),
				new JunFileModel.FileType("html files (*.html)", new String[] { "*.html", "*.HTML", "*.htm", "*.HTM" }) };
		JunFileModel fileModel = new JunFileModel();
		fileModel.fileTypes_(fileTypes);
		fileModel.fileType().value_(fileTypes[3]);
		fileModel.compute_(new StBlockClosure() {
			public Object value_(Object newValue) {
				System.out.println(newValue);
				return null;
			}
		});
		fileModel.open();
		return true;
	}

	/**
	 * Example5: Create a FileModel with file type specified, computing a new value, assign an initial value, and open it.
	 * 
	 * @return boolean
	 */
	public static boolean Example5() {
		JunFileModel.FileType[] fileTypes = new JunFileModel.FileType[] {
				JunFileModel.FileType.All("all files (*.*)"),
				new JunFileModel.FileType("java files (*.java)", new String[] { "*.java", "*.JAVA" }),
				new JunFileModel.FileType("text files (*.txt)", new String[] { "*.txt", "*.TXT" }),
				new JunFileModel.FileType("html files (*.html)", new String[] { "*.html", "*.HTML", "*.htm", "*.HTM" }) };
		JunFileModel fileModel = new JunFileModel();
		fileModel.value_(new File(JunFileModel.DefaultDirectory(), "zzz.html"));
		fileModel.fileTypes_(fileTypes);
		fileModel.fileType().value_(fileTypes[3]);
		fileModel.compute_(new StBlockClosure() {
			public Object value_(Object newValue) {
				System.out.println(newValue);
				return null;
			}
		});
		fileModel.open();
		return true;
	}

	/**
	 * Execute all examples.
	 *
	 * @param args java.lang.String[]
	 */
	public static void main(String[] args) {
		new JunFileModelTestExamples();
	}
}
