package jp.co.sra.jun.goodies.files;

import java.awt.Button;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import jp.co.sra.smalltalk.StSimpleDialogViewAwt;
import jp.co.sra.smalltalk.WindowSpecLayout;

import jp.co.sra.jun.system.support.JunSystem;

/**
 * JunFileDialogViewAwt class
 * 
 *  @author    nisinaka
 *  @created   2003/03/09 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun433 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunFileDialogViewAwt.java,v 8.11 2008/02/20 06:31:33 nisinaka Exp $
 */
public class JunFileDialogViewAwt extends StSimpleDialogViewAwt implements JunFileDialogView {

	protected JunFileViewAwt fileView;
	protected Button acceptButton;
	protected Button cancelButton;

	/**
	 * Create a new instance of JunFileDialogViewAwt and initialize it.
	 *
	 * @param aFileDialog jp.co.sra.jun.goodies.files.JunFileDialog
	 * @category Instance creation
	 */
	public JunFileDialogViewAwt(JunFileDialog aFileDialog) {
		super(aFileDialog);
	}

	/**
	 * Build this component.
	 * 
	 * @see jp.co.sra.smalltalk.StViewPanel#buildComponent()
	 * @category initialize-release
	 */
	protected void buildComponent() {
		this.setLayout(new WindowSpecLayout());
		this.add(this.fileView(), WindowSpecLayout.Position(0f, 1, 0f, 1, 1f, -97, 1f, -1));
		this.add(this.acceptButton(), WindowSpecLayout.Position(1f, -96, 0f, 16, 1f, -8, 0f, 48));
		this.add(this.cancelButton(), WindowSpecLayout.Position(1f, -96, 0f, 56, 1f, -8, 0f, 88));
		this.setSize(540, 300);

		defaultButton = this.acceptButton();
	}

	/**
	 * Answer my model as JunFileDialog.
	 *
	 * @return jp.co.sra.jun.goodies.files.JunFileDialog
	 * @see jp.co.sra.jun.goodies.files.JunFileDialogView#getFileDialog()
	 * @category model accessing
	 */
	public JunFileDialog getFileDialog() {
		return (JunFileDialog) this.model();
	}

	/**
	 * Answer my file view.
	 *
	 * @return jp.co.sra.jun.goodies.files.JunFileViewAwt
	 * @category user interface
	 */
	protected JunFileViewAwt fileView() {
		if (fileView == null) {
			fileView = new JunFileViewAwt(this.getFileDialog().fileModel());
		}
		return fileView;
	}

	/**
	 * Answer my accept button.
	 *
	 * @return java.awt.Button
	 * @category user interface
	 */
	protected Button acceptButton() {
		if (acceptButton == null) {
			acceptButton = new Button(JunSystem.$String("Accept"));
			acceptButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					if (getFileDialog().acceptButtonPressed()) {
						getFileDialog().accept().value_(true);
					}
				}
			});
		}
		return acceptButton;
	}

	/**
	 * Answer my cancel button.
	 *
	 * @return java.awt.Button
	 * @category user interface
	 */
	protected Button cancelButton() {
		if (cancelButton == null) {
			cancelButton = new Button(JunSystem.$String("Cancel"));
			cancelButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					if (getFileDialog().cancelButtonPressed()) {
						getFileDialog().cancel().value_(true);
					}
				}
			});
		}
		return cancelButton;
	}

}
