package jp.co.sra.jun.goodies.files;

import java.io.File;

import jp.co.sra.smalltalk.StBlockClosure;

import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunFileDialogTestExamples class
 * 
 *  @author    nisinaka
 *  @created   2000/12/18 (by nisinaka)
 *  @updated   2003/03/09 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun513 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunFileDialogTestExamples.java,v 8.11 2008/02/20 06:31:33 nisinaka Exp $
 */
public class JunFileDialogTestExamples extends JunTestExamples {

	/**
	 * Example_RequestDirectory: Call RequestDirectory().
	 * 
	 * @return boolean
	 */
	public static boolean Example_RequestDirectory() {
		File answer = JunFileDialog.RequestDirectory($String("Select a directory."), new File("Jun999"));
		System.out.println(answer);
		return true;
	}

	/**
	 * Example_RequestNewDirectory: Call RequestNewDirectory().
	 * 
	 * @return boolean
	 */
	public static boolean Example_RequestNewDirectory() {
		File answer = JunFileDialog.RequestNewDirectory($String("Select a directory."), new File("Jun999"));
		System.out.println(answer);
		return true;
	}

	/**
	 * Example_RequestNewFile: Call RequestNewFile().
	 * 
	 * @return boolean
	 */
	public static boolean Example_RequestNewFile() {
		File answer = JunFileDialog.RequestNewFile($String("Select a file."), new File("Jun999"));
		System.out.println(answer);
		return true;
	}

	/**
	 * Example1: Call Request().
	 * 
	 * @return boolean
	 */
	public static boolean Example1() {
		File answer = JunFileDialog.Request();
		System.out.println(answer);
		return true;
	}

	/**
	 * Example2: Request to select a file.
	 * 
	 * @return boolean
	 */
	public static boolean Example2() {
		File answer = JunFileDialog.Request($String("Select a file."));
		System.out.println(answer);
		return true;
	}

	/**
	 * Example3: Request to select a file.
	 * 
	 * @return boolean
	 */
	public static boolean Example3() {
		File answer = JunFileDialog.Request(null, new File(JunFileModel.DefaultDirectory(), "zzz.st"), null, null, null, null);
		System.out.println(answer);
		return true;
	}

	/**
	 * Example4: Request to select a file.
	 * 
	 * @return boolean
	 */
	public static boolean Example4() {
		JunFileModel.FileType[] fileTypes = new JunFileModel.FileType[] {
				JunFileModel.FileType.All($String("All files")),
				new JunFileModel.FileType($String("Java files"), new String[] { "*.java", "*.JAVA" }),
				new JunFileModel.FileType($String("Text files"), new String[] { "*.txt", "*.TXT" }) };
		File answer = JunFileDialog.Request($String("Select a file."), fileTypes, fileTypes[2]);
		System.out.println(answer);
		return true;
	}

	/**
	 * Example5: Request to select a file.
	 * 
	 * @return boolean
	 */
	public static boolean Example5() {
		JunFileModel.FileType[] fileTypes = new JunFileModel.FileType[] {
				JunFileModel.FileType.All($String("All files")),
				new JunFileModel.FileType($String("Java files"), new String[] { "*.java", "*.JAVA" }),
				new JunFileModel.FileType($String("Text files"), new String[] { "*.txt", "*.TXT" }) };
		File answer = JunFileDialog.Request($String("Select a file."), JunFileModel.DefaultDirectory(), "zzz.java", fileTypes, fileTypes[2], new StBlockClosure() {
			public Object value_(Object model) {
				System.out.println($String("Accept button was pressed."));
				System.out.println("\t" + ((JunFileModel) model).value());
				return Boolean.TRUE;
			}
		}, new StBlockClosure() {
			public Object value_(Object model) {
				System.out.println($String("Cancel button was pressed."));
				System.out.println("\t" + ((JunFileModel) model).value());
				return Boolean.TRUE;
			}
		});
		System.out.println(answer);
		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args an array of command-line arguments
	 */
	public static void main(java.lang.String[] args) {
		new JunFileDialogTestExamples();
	}

}
