package jp.co.sra.jun.goodies.drawing.properties;

import java.awt.Dimension;
import java.awt.Font;
import javax.swing.JLabel;
import jp.co.sra.smalltalk.DependentEvent;
import jp.co.sra.smalltalk.StSymbol;
import jp.co.sra.smalltalk.WindowSpecLayout;
import jp.co.sra.jun.goodies.colors.JunColorChoiceViewSwing;
import jp.co.sra.jun.goodies.parameter.JunParameterViewSwing;
import jp.co.sra.jun.system.framework.JunAbstractViewJPanel;
import jp.co.sra.jun.system.support.JunSystem;

/**
 * JunVertexesPropertiesViewSwing class
 * 
 *  @author    m-asada
 *  @created   2005/10/21 (by m-asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunVertexesPropertiesViewSwing.java,v 8.10 2008/02/20 06:31:24 nisinaka Exp $
 */
public class JunVertexesPropertiesViewSwing extends JunAbstractViewJPanel implements JunVertexesPropertiesView {
	protected JunColorChoiceViewSwing foregroundColorChoiceView;
	protected JunParameterViewSwing lineWidthParameterView;

	/**
	 * Create a new instance of <code>JunVertexesPropertiesViewSwing</code> and initialize it.
	 * 
	 * @category Instance creation
	 */
	public JunVertexesPropertiesViewSwing() {
		super();
	}

	/**
	 * Create a new instance of <code>JunVertexesPropertiesViewSwing</code> and initialize it.
	 * 
	 * @param newModel jp.co.sra.jun.goodies.drawing.properties.JunVertexesPropertiesModel
	 * @category Instance creation
	 */
	public JunVertexesPropertiesViewSwing(JunVertexesPropertiesModel newModel) {
		super(newModel);
	}

	/**
	 * Answer the model as JunVertexesPropertiesModel.
	 * 
	 * @return jp.co.sra.jun.goodies.drawing.properties.JunVertexesPropertiesModel
	 * @see jp.co.sra.jun.goodies.drawing.properties.JunVertexesPropertiesView#getModel()
	 * @category model accessing
	 */
	public JunVertexesPropertiesModel getModel() {
		return (JunVertexesPropertiesModel) this.model();
	}

	/**
	 * Initialize the JunRectangularShapePropertiesViewAwt.
	 * 
	 * @see jp.co.sra.smalltalk.StViewPanel#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();

		foregroundColorChoiceView = null;
		lineWidthParameterView = null;
	}

	/**
	 * Release the receiver.
	 * 
	 * @see jp.co.sra.smalltalk.StView#release()
	 * @category initialize-release
	 */
	public void release() {
		super.release();

		this.foregroundColorChoiceView().release();
		this.lineWidthParameterView().release();
	}

	/**
	 * Build this component.
	 * 
	 * @see jp.co.sra.smalltalk.StViewJPanel#buildComponent()
	 * @category initialize-release
	 */
	protected void buildComponent() {
		this.setLayout(new WindowSpecLayout());

		JLabel label = new JLabel(JunSystem.$String("Line color") + " :");
		label.setFont(this.font());
		this.add(label, WindowSpecLayout.Position(0f, 0, 0f, 0, 0f, 70, 0f, 30));
		this.add(this.foregroundColorChoiceView(), WindowSpecLayout.Position(0f, 71, 0f, 0, 1f, 0, 0f, 123));
		this.add(this.lineWidthParameterView(), WindowSpecLayout.Position(0f, 0, 0f, 124, 0f, 289, 0f, 165));

		this.setPreferredSize(new Dimension(290, 173));
	}

	/**
	 * Answer the receiver's foreground color choice view.
	 *
	 * @return jp.co.sra.jun.goodies.colors.JunColorChoiceViewSwing
	 * @category interface opening
	 */
	public JunColorChoiceViewSwing foregroundColorChoiceView() {
		if (foregroundColorChoiceView == null) {
			foregroundColorChoiceView = new JunColorChoiceViewSwing(this.getModel().foregroundColorChoiceModel());
		}
		return foregroundColorChoiceView;
	}

	/**
	 * Answer the receiver's line width view.
	 *
	 * @return jp.co.sra.jun.goodies.parameter.JunParameterViewSwing
	 * @category interface opening
	 */
	public JunParameterViewSwing lineWidthParameterView() {
		if (lineWidthParameterView == null) {
			lineWidthParameterView = new JunParameterViewSwing(this.getModel().lineWidthParameterModel());
		}
		return lineWidthParameterView;
	}

	/**
	 * Answer the receiver's font.
	 * 
	 * @return java.awt.Font
	 * @category fonts
	 */
	protected Font font() {
		return new Font("dialog", Font.BOLD, 12);
	}

	/**
	 * Update the receiver according to the change notification from the model.
	 * 
	 * @param evt jp.co.sra.smalltalk.DependentEvent
	 * @see jp.co.sra.smalltalk.DependentListener#update_(jp.co.sra.smalltalk.DependentEvent)
	 * @category updating
	 */
	public void update_(DependentEvent evt) {
		if (this.isShowing() == false) {
			return;
		}

		StSymbol aSymbol = evt.getAspect();
		if (aSymbol == $("foregroundColor") || aSymbol == $("lineWidth")) {
			return;
		}

		super.update_(evt);
	}
}
