package jp.co.sra.jun.goodies.drawing.properties;

import jp.co.sra.smalltalk.DependentEvent;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StView;
import jp.co.sra.jun.goodies.colors.JunColorChoiceHSB;
import jp.co.sra.jun.goodies.colors.JunColorChoiceModel;
import jp.co.sra.jun.goodies.drawing.element.JunDrawingElement;
import jp.co.sra.jun.goodies.drawing.element.JunPathElement;
import jp.co.sra.jun.goodies.drawing.element.JunVertexesElement;
import jp.co.sra.jun.goodies.parameter.JunParameter;
import jp.co.sra.jun.goodies.parameter.JunParameterModel;
import jp.co.sra.jun.system.support.JunSystem;

/**
 * JunVertexesPropertiesModel class
 * 
 *  @author    m-asada
 *  @created   2005/10/21 (by m-asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunVertexesPropertiesModel.java,v 8.10 2008/02/20 06:31:24 nisinaka Exp $
 */
public class JunVertexesPropertiesModel extends JunDrawingElementPropertiesModel {
	protected JunColorChoiceModel foregroundColorChoiceModel;
	protected JunParameterModel lineWidthParameterModel;


	/**
	 * Create a new instance of <code>JunVertexesPropertiesModel</code> and initialize it.
	 * 
	 * @param vertexesElement jp.co.sra.jun.goodies.drawing.element.JunVertexesElement
	 * @category Instance creation
	 */
	public JunVertexesPropertiesModel(JunVertexesElement vertexesElement) {
		super(vertexesElement);
	}

	/**
	 * Initialize the ApplicationModel when created.
	 * 
	 * @see jp.co.sra.smalltalk.StApplicationModel#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();

		foregroundColorChoiceModel = null;
		lineWidthParameterModel = null;
	}

	/**
	 * Answer the receiver's vertexes element.
	 * 
	 * @return jp.co.sra.jun.goodies.drawing.element.JunVertexesElement
	 * @category accessing
	 */
	public JunVertexesElement vertexesElement() {
		return (JunVertexesElement) this.drawingElement();
	}

	/**
	 * Set the receiver's rectangular shape element.
	 * 
	 * @param newDrawingElement jp.co.sra.jun.goodies.drawing.element.JunDrawingElement
	 * @see jp.co.sra.jun.goodies.drawing.properties.JunDrawingElementPropertiesModel#drawingElement_(jp.co.sra.jun.goodies.drawing.element.JunDrawingElement)
	 * @category accessing
	 */
	protected void drawingElement_(JunDrawingElement newDrawingElement) {
		if (newDrawingElement == null) {
			return;
		}
		super.drawingElement_(newDrawingElement);

		JunVertexesElement newVertexesElement = (JunVertexesElement) newDrawingElement;
		this.foregroundColorChoiceModel().color_(newVertexesElement.foregroundColor());
		this.lineWidthParameterModel().parameter().value_(newVertexesElement.lineWidth());
	}

	/**
	 * Answer the receiver's choice model of foreground color.
	 * 
	 * @return jp.co.sra.jun.goodies.colors.JunColorChoiceModel
	 * @category aspects
	 */
	public JunColorChoiceModel foregroundColorChoiceModel() {
		if (foregroundColorChoiceModel == null) {
			foregroundColorChoiceModel = new JunColorChoiceHSB();
			foregroundColorChoiceModel.compute_(new StBlockClosure() {
				public Object value() {
					JunVertexesPropertiesModel.this.updateForegroundColor();
					return null;
				}
			});
		}
		return foregroundColorChoiceModel;
	}

	/**
	 * Answer the receiver's parameter model of line width.
	 * 
	 * @return jp.co.sra.jun.goodies.parameter.JunParameterModel
	 * @category aspects
	 */
	public JunParameterModel lineWidthParameterModel() {
		if (lineWidthParameterModel == null) {
			lineWidthParameterModel = new JunParameterModel(new JunParameter(JunSystem.$String("Line width"), 1, JunPathElement.MIN_LINE_WIDTH, JunPathElement.MAX_LINE_WIDTH, 1));
			lineWidthParameterModel.addDependent_(this);
		}
		return lineWidthParameterModel;
	}

	/**
	 * Answer the default view of the model.
	 * 
	 * @return jp.co.sra.smalltalk.StView
	 * @see jp.co.sra.smalltalk.StApplicationModel#defaultView()
	 * @category defaults
	 */
	public StView defaultView() {
		if (GetDefaultViewMode() == VIEW_AWT) {
			return new JunVertexesPropertiesViewAwt(this);
		} else {
			return new JunVertexesPropertiesViewSwing(this);
		}
	}

	/**
	 * Receive a change notice from an object of whom the receiver is a
	 * dependent.  The argument evt.getAspect() is typically a Symbol that
	 * indicates what change has occurred.
	 * 
	 * @param event jp.co.sra.smalltalk.DependentEvent
	 * @see jp.co.sra.smalltalk.DependentListener#update_(jp.co.sra.smalltalk.DependentEvent)
	 * @category updating
	 */
	public void update_(DependentEvent event) {
		if (event.getAspect() == $("value")) {
			this.updateLineWidth();
		}
	}

	/**
	 * Called when the foreground color is changed.
	 * 
	 * @category updating
	 */
	protected void updateForegroundColor() {
		if (this.foregroundColorChoiceModel().color().equals(this.vertexesElement().foregroundColor()) == false) {
			this.vertexesElement().foregroundColor_(this.foregroundColorChoiceModel().color());
			this.vertexesElement().map().changed_with_($("redisplay"), this.vertexesElement().bounds());
			this.changed_($("foregroundColor"));
		}
	}

	/**
	 * Called when the line width is changed.
	 * 
	 * @category updating
	 */
	protected void updateLineWidth() {
		int value = (int) this.lineWidthParameterModel().parameter().value();
		if (this.vertexesElement().lineWidth() != value) {
			this.vertexesElement().lineWidth_(value);
			this.vertexesElement().map().changed_with_($("redisplay"), this.vertexesElement().bounds());
			this.changed_($("lineWidth"));
		}
	}

}
