package jp.co.sra.jun.goodies.drawing.properties;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Label;
import jp.co.sra.smalltalk.WindowSpecLayout;
import jp.co.sra.jun.goodies.colors.JunColorChoiceViewAwt;
import jp.co.sra.jun.goodies.texteditor.JunTextEditorView;
import jp.co.sra.jun.goodies.texteditor.JunTextEditorViewAwt;
import jp.co.sra.jun.system.framework.JunAbstractViewPanel;
import jp.co.sra.jun.system.support.JunSystem;

/**
 * JunTextPropertiesViewAwt class
 * 
 *  @author    m-asada
 *  @created   2005/05/11 (by Mitsuhiro Asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunTextPropertiesViewAwt.java,v 8.10 2008/02/20 06:31:24 nisinaka Exp $
 */
public class JunTextPropertiesViewAwt extends JunAbstractViewPanel implements JunTextPropertiesView {
	protected JunTextEditorViewAwt textEditorView;
	protected JunColorChoiceViewAwt foregroundColorChoiceView;

	/**
	 * Create a new instance of JunTextPropertiesViewAwt and initialize it.
	 * 
	 * @category Instance creation
	 */
	public JunTextPropertiesViewAwt() {
		super();
	}

	/**
	 * Create a new instance of JunTextPropertiesViewAwt and initialize it.
	 * 
	 * @param newModel jp.co.sra.jun.goodies.drawing.properties.JunTextPropertiesModel
	 * @category Instance creation
	 */
	public JunTextPropertiesViewAwt(JunTextPropertiesModel newModel) {
		super(newModel);
	}

	/**
	 * Initialize the receiver.
	 * 
	 * @see jp.co.sra.smalltalk.StViewPanel#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();
		textEditorView = null;
		foregroundColorChoiceView = null;
	}

	/**
	 * Release the receiver.
	 * 
	 * @see jp.co.sra.smalltalk.StView#release()
	 * @category initialize-release
	 */
	public void release() {
		super.release();

		this.textEditorView().release();
		this.foregroundColorChoiceView().release();
	}

	/**
	 * Build the component.
	 * 
	 * @see jp.co.sra.smalltalk.StViewPanel#buildComponent()
	 * @category initialize-release
	 */
	protected void buildComponent() {
		this.setLayout(new WindowSpecLayout());

		Label label = new Label(JunSystem.$String("Font color") + " :");
		label.setFont(this.font());
		this.add(label, WindowSpecLayout.Position(0f, 1, 0f, 1, 0f, 90, 0f, 30));
		this.add(this.foregroundColorChoiceView().toComponent(), WindowSpecLayout.Position(0f, 91, 0f, 1, 1f, 0, 0f, 123));

		this.add(this.textEditorView().toComponent(), WindowSpecLayout.Position(0f, 0, 0f, 125, 1f, 0, 1f, 0));
		this.setSize(new Dimension(313, 320));
	}

	/**
	 * Answer the model as JunTextPropertiesModel.
	 * 
	 * @return jp.co.sra.jun.goodies.drawing.properties.JunTextPropertiesModel
	 * @see jp.co.sra.jun.goodies.drawing.properties.JunTextPropertiesView#getModel()
	 * @category model accessing
	 */
	public JunTextPropertiesModel getModel() {
		return (JunTextPropertiesModel) this.model();
	}

	/**
	 * Answer the text editor view.
	 * 
	 * @return jp.co.sra.jun.goodies.texteditor.JunTextEditorViewAwt
	 * @see jp.co.sra.jun.goodies.drawing.properties.JunTextPropertiesView#textEditorView()
	 * @category interface opening
	 */
	public JunTextEditorView textEditorView() {
		if (textEditorView == null) {
			textEditorView = new JunTextEditorViewAwt(this.getModel().textEditor());
		}
		return textEditorView;
	}

	/**
	 * Answer the receiver's foreground color choice view.
	 *
	 * @return jp.co.sra.jun.goodies.colors.JunColorChoiceViewAwt
	 * @category interface opening
	 */
	public JunColorChoiceViewAwt foregroundColorChoiceView() {
		if (foregroundColorChoiceView == null) {
			foregroundColorChoiceView = new JunColorChoiceViewAwt(this.getModel().foregroundColorChoiceModel());
		}
		return foregroundColorChoiceView;
	}

	/**
	 * Answer the text in text area.
	 * 
	 * @return java.lang.String
	 * @see jp.co.sra.jun.goodies.drawing.properties.JunTextPropertiesView#getText()
	 * @category text accessing
	 */
	public String getText() {
		return this.textEditorView().getText();
	}

	/**
	 * Answer the receiver's font.
	 * 
	 * @return java.awt.Font
	 * @category fonts
	 */
	protected Font font() {
		return new Font("dialog", Font.BOLD, 12);
	}
}
