package jp.co.sra.jun.goodies.drawing.map;

import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import jp.co.sra.smalltalk.StImage;
import jp.co.sra.jun.goodies.drawing.element.JunEllipseElement;
import jp.co.sra.jun.goodies.drawing.element.JunImageElement;
import jp.co.sra.jun.goodies.drawing.element.JunLabelElement;
import jp.co.sra.jun.goodies.drawing.element.JunLinkElement;
import jp.co.sra.jun.goodies.drawing.element.JunPathElement;
import jp.co.sra.jun.goodies.drawing.element.JunRectangleElement;
import jp.co.sra.jun.goodies.drawing.element.JunRoundRectangleElement;
import jp.co.sra.jun.goodies.drawing.element.JunTextElement;
import jp.co.sra.jun.goodies.drawing.element.JunTextboxElement;
import jp.co.sra.jun.system.support.JunSystem;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunDrawingMapModelTestExamples class
 * 
 *  @author    m-asada
 *  @created   2005/03/01 (by Mitsuhiro Asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunDrawingMapModelTestExamples.java,v 8.10 2008/02/20 06:31:24 nisinaka Exp $
 */
public class JunDrawingMapModelTestExamples extends JunTestExamples {
	/**
	 * Example1: 
	 *  
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		JunDrawingMapModel aModel = new JunDrawingMapModel(new JunDrawingMap());
		aModel.open();

		return true;
	}

	/**
	 * Example2: 
	 *  
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example2() {
		JunDrawingMapModel aModel = new JunDrawingMapModel(MapExample1());
		aModel.open();

		return true;
	}

	/**
	 * Example3: 
	 *  
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example3() {
		JunDrawingMapModel aModel = new JunDrawingMapModel(MapExample2());
		aModel.open();

		return true;
	}

	/**
	 * Answer the sample map as JunDrawingMap.
	 * 
	 * @return jp.co.sra.jun.goodies.drawing.map.JunDrawingMap
	 * @category Private
	 */
	public static JunDrawingMap MapExample1() {
		JunDrawingMap aMap = new JunDrawingMap();

		JunRectangleElement rectangle1 = new JunRectangleElement();
		rectangle1.location_(75, 140);
		rectangle1.extent_(60, 20);
		rectangle1.foregroundColor_(Color.pink);
		rectangle1.backgroundColor_(Color.pink);
		aMap.addElement_(rectangle1);

		JunRectangleElement rectangle2 = new JunRectangleElement();
		rectangle2.location_(550, 10);
		rectangle2.extent_(30, 150);
		rectangle2.foregroundColor_(Color.green);
		rectangle2.lineWidth_(5);
		aMap.addElement_(rectangle2);

		JunTextElement text1 = new JunTextElement();
		text1.text_(JunSystem.FullName());
		text1.foregroundColor_(Color.blue);
		text1.location_(30, 20);
		text1.extent_(200, 30);
		aMap.addElement_(text1);

		JunPathElement path1 = new JunPathElement();
		path1.foregroundColor_(Color.red);
		path1.add_(new Point(10, 10));
		path1.add_(new Point(10, 150));
		path1.beginStyle_(JunPathElement.ARROW_STYLE_ARROW);
		path1.endStyle_(JunPathElement.ARROW_STYLE_DIAMOND);
		aMap.addElement_(path1);

		JunPathElement path2 = new JunPathElement();
		path2.add_(new Point(210, 10));
		path2.add_(new Point(300, 100));
		path2.add_(new Point(300, 10));
		aMap.addElement_(path2);

		JunPathElement path3 = new JunPathElement();
		path3.lineWidth_(5);
		path3.foregroundColor_(Color.magenta);
		path3.add_(new Point(100, 50));
		path3.add_(new Point(50, 100));
		path3.add_(new Point(100, 120));
		path3.add_(new Point(50, 120));
		path3.endStyle_(JunPathElement.ARROW_STYLE_ARROW);
		aMap.addElement_(path3);

		JunRoundRectangleElement roundRect1 = new JunRoundRectangleElement();
		roundRect1.location_(180, 75);
		roundRect1.extent_(50, 70);
		roundRect1.foregroundColor_(Color.orange);
		roundRect1.backgroundColor_(Color.lightGray);
		roundRect1.lineWidth_(1);
		aMap.addElement_(roundRect1);

		JunRoundRectangleElement roundRect2 = new JunRoundRectangleElement();
		roundRect2.location_(350, 0);
		roundRect2.extent_(150, 150);
		roundRect2.foregroundColor_(Color.cyan);
		roundRect2.lineWidth_(20);
		aMap.addElement_(roundRect2);

		JunEllipseElement ellipse = new JunEllipseElement();
		ellipse.location_(210, 170);
		ellipse.extent_(120, 30);
		ellipse.foregroundColor_(Color.darkGray);
		ellipse.backgroundColor_(Color.yellow);
		ellipse.lineWidth_(5);
		aMap.addElement_(ellipse);

		JunImageElement image = new JunImageElement();
		image.location_(50, 180);
		image.extent_(100, 64);
		image.image_(new StImage(JunSystem.LogoImage()));
		aMap.addElement_(image);

		aMap.addSelectedElement_(path1);
		return aMap;
	}

	/**
	 * Answer the sample map as JunDrawingMap.
	 * 
	 * @return jp.co.sra.jun.goodies.drawing.map.JunDrawingMap
	 * @category Private
	 */
	public static JunDrawingMap MapExample2() {
		JunDrawingMap aMap = new JunDrawingMap();

		JunTextboxElement textbox1 = new JunTextboxElement();
		textbox1.location_(10, 10);
		textbox1.extent_(200, 20);
		textbox1.text_(JunSystem.FullName());
		textbox1.foregroundColor_(Color.blue);
		textbox1.backgroundColor_(Color.pink);
		textbox1.borderColor_(Color.blue);
		aMap.addElement_(textbox1);

		JunTextboxElement textbox2 = new JunTextboxElement();
		textbox2.location_(50, 150);
		textbox2.extent_(150, 30);
		textbox2.text_(JunSystem.Date());
		textbox2.fontName_("Times New Roman");
		textbox2.fontSize_(18);
		textbox2.fontStyle_(Font.BOLD);
		textbox2.lineWidth_(2);
		textbox2.foregroundColor_(Color.magenta);
		textbox2.backgroundColor_(Color.lightGray);
		textbox2.borderColor_(Color.magenta);
		aMap.addElement_(textbox2);

		JunPathElement path = new JunPathElement();
		path.add_(textbox1.center());
		path.add_(new Point(100, 90));
		path.add_(new Point(200, 90));
		path.add_(textbox2.center());
		path.beginStyle_(JunPathElement.ARROW_STYLE_ARROW);
		path.endStyle_(JunPathElement.ARROW_STYLE_ARROW);
		JunLinkElement link = new JunLinkElement(textbox1, textbox2, path);
		aMap.addElement_(link);

		JunLabelElement label = new JunLabelElement();
		label.text_("label");
		label.location_(120, 80);
		label.extent_(60, 20);
		link.labelElement_(label);
		aMap.addElement_(label);

		return aMap;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(String[] args) {
		new JunDrawingMapModelTestExamples();
	}
}
