package jp.co.sra.jun.goodies.drawing.element;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.datatransfer.DataFlavor;
import java.awt.geom.Ellipse2D;
import jp.co.sra.jun.goodies.lisp.JunLispList;

/**
 * JunEllipseElement class
 * 
 *  @author    m-asada
 *  @created   2005/04/11 (by Mitsuhiro Asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunEllipseElement.java,v 8.11 2008/02/20 06:31:23 nisinaka Exp $
 */
public class JunEllipseElement extends JunRectangularShapeElement {
	public static DataFlavor DataFlavor = new DataFlavor(JunEllipseElement.class, "JunEllipseElement");

	/**
	 * Create a new instance of JunEllipseElement and initialize it.
	 *
	 * @category Instance creation
	 */
	public JunEllipseElement() {
		super();
	}

	/**
	 * Create a new instance of JunEllipseElement and initialize it.
	 *
	 * @param aList jp.co.sra.jun.goodies.lisp.JunLispList
	 * @category Instance creation
	 */
	public JunEllipseElement(JunLispList aList) {
		super(aList);
	}

	/**
	 * Get the default extent.
	 *
	 * @return java.awt.Dimension
	 * @see jp.co.sra.jun.goodies.drawing.element.JunDrawingVisual#defaultExtent()
	 * @category defaults
	 */
	public Dimension defaultExtent() {
		return new Dimension(48, 48);
	}

	/**
	 * Display the receiver on the graphics.
	 * 
	 * @param aGraphics java.awt.Graphics
	 * @see jp.co.sra.smalltalk.StDisplayable#displayOn_(java.awt.Graphics)
	 * @category displaying
	 */
	public void displayOn_(Graphics aGraphics) {
		Graphics2D graphicsContext = (Graphics2D) aGraphics.create();
		try {
			graphicsContext.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
			super.displayOn_(graphicsContext);
		} finally {
			if (graphicsContext != null) {
				graphicsContext.dispose();
			}
		}
	}

	/**
	 * Returns an array of DataFlavor objects indicating the flavors the data can be provided in. The array should be
	 * ordered according to preference for providing the data (from most richly descriptive to least descriptive).
	 * 
	 * @return java.awt.datatransfer.DataFlavor[]
	 * @see java.awt.datatransfer.Transferable#getTransferDataFlavors()
	 * @see jp.co.sra.jun.goodies.drawing.element.JunDrawingVisual#getTransferDataFlavors()
	 * @category transfering
	 */
	public DataFlavor[] getTransferDataFlavors() {
		return new DataFlavor[] { JunEllipseElement.DataFlavor };
	}

	/**
	 * Answer the receiver's shape.
	 * 
	 * @return java.awt.Shape
	 * @see jp.co.sra.jun.goodies.drawing.element.JunRectangularShapeElement#shape()
	 * @category private
	 */
	protected Shape shape() {
		if (shape == null) {
			shape = new Ellipse2D.Double(this.x() + lineWidth / 2, this.y() + lineWidth / 2, this.width() - lineWidth, this.height() - lineWidth);
		}
		return shape;
	}
}
