package jp.co.sra.jun.goodies.drawing;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JToolBar;
import jp.co.sra.jun.goodies.button.JunButtonViewSwing;
import jp.co.sra.jun.goodies.drawing.map.JunDrawingMapView;
import jp.co.sra.jun.goodies.drawing.map.JunDrawingMapViewSwing;
import jp.co.sra.jun.system.framework.JunAbstractViewJPanel;

/**
 * JunDrawingViewSwing class
 * 
 *  @author    m-asada
 *  @created   2005/06/08 (by m-asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunDrawingViewSwing.java,v 8.11 2008/02/20 06:31:23 nisinaka Exp $
 */
public class JunDrawingViewSwing extends JunAbstractViewJPanel implements JunDrawingView {
	protected JToolBar toolBar;
	protected JunDrawingMapViewSwing drawingMapView;
	protected JunButtonViewSwing selectButtonView;
	protected JunButtonViewSwing brushButtonView;
	protected JunButtonViewSwing cameraButtonView;
	protected JunButtonViewSwing ellipseButtonView;
	protected JunButtonViewSwing linkButtonView;
	protected JunButtonViewSwing pathButtonView;
	protected JunButtonViewSwing rectangleButtonView;
	protected JunButtonViewSwing roundRectangleButtonView;
	protected JunButtonViewSwing textButtonView;
	protected JunButtonViewSwing textboxButtonView;

	/**
	 * Create a new instance of <code>JunDrawingViewSwing</code> and initialize it.
	 * 
	 * @category Instance creation
	 */
	public JunDrawingViewSwing() {
		super();
	}

	/**
	 * Create a new instance of <code>JunDrawingViewSwing</code> and initialize it.
	 * 
	 * @param newModel jp.co.sra.jun.goodies.drawing.JunDrawing
	 * @category Instance creation
	 */
	public JunDrawingViewSwing(JunDrawing newModel) {
		super(newModel);
	}

	/**
	 * Answer the receiver's model as JunDrawing.
	 * 
	 * @return jp.co.sra.jun.goodies.drawing.JunDrawing
	 * @see jp.co.sra.jun.goodies.drawing.JunDrawingView#getDrawingModel()
	 * @category model accessing
	 */
	public JunDrawing getDrawingModel() {
		return (JunDrawing) this.model();
	}

	/**
	 * Initialize the JunDrawingViewSwing.
	 * 
	 * @see jp.co.sra.smalltalk.StViewPanel#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();

		drawingMapView = null;
		toolBar = null;
		selectButtonView = null;

		brushButtonView = null;
		cameraButtonView = null;
		ellipseButtonView = null;
		linkButtonView = null;
		pathButtonView = null;
		rectangleButtonView = null;
		roundRectangleButtonView = null;
		textButtonView = null;
		textboxButtonView = null;
	}

	/**
	 * Build the component.
	 * 
	 * @see jp.co.sra.smalltalk.StViewJPanel#buildComponent()
	 * @category interface opening
	 */
	protected void buildComponent() {
		this.setLayout(new BorderLayout());
		this.add(this.toolBar(), BorderLayout.LINE_END);
		this.add(this.drawingMapView().toComponent(), BorderLayout.CENTER);
		this.setPreferredSize(new Dimension(500, 300));
	}

	/**
	 * Answer the receiver's tool bar.
	 * 
	 * @return javax.swing.JToolBar
	 * @category interface opening
	 */
	protected JToolBar toolBar() {
		if (toolBar == null) {
			toolBar = new JToolBar("drawing");
			toolBar.setRollover(true);
			toolBar.setFocusable(false);
			toolBar.setOrientation(JToolBar.VERTICAL);

			toolBar.add(this.selectButtonView());
			toolBar.add(this.textButtonView());
			toolBar.add(this.textboxButtonView());
			toolBar.add(this.cameraButtonView());
			toolBar.add(this.ellipseButtonView());
			toolBar.add(this.rectangleButtonView());
			toolBar.add(this.roundRectangleButtonView());
			toolBar.add(this.pathButtonView());
			toolBar.add(this.brushButtonView());
			toolBar.addSeparator();
			toolBar.add(this.linkButtonView().toComponent());
		}
		return toolBar;
	}

	/**
	 * Answer the drawing map view.
	 * 
	 * @return jp.co.sra.jun.goodies.drawing.map.JunDrawingMapView
	 * @see jp.co.sra.jun.goodies.drawing.JunDrawingView#drawingMapView()
	 * @category interface opening
	 */
	public JunDrawingMapView drawingMapView() {
		if (drawingMapView == null) {
			drawingMapView = new JunDrawingMapViewSwing(this.getDrawingModel().mapModel());
			drawingMapView.toComponent().addPropertyChangeListener(new PropertyChangeListener() {
				public void propertyChange(PropertyChangeEvent evt) {
					if (evt.getPropertyName().equals("editMode")) {
						JunDrawingViewSwing.this.getDrawingModel().updateToolbar_(((Number) evt.getNewValue()).intValue());
					}
				}
			});
		}
		return drawingMapView;
	}

	/**
	 * Answer the brush button view.
	 *
	 * @return jp.co.sra.jun.goodies.button.JunButtonViewSwing
	 * @category interface opening
	 */
	protected JunButtonViewSwing brushButtonView() {
		if (brushButtonView == null) {
			brushButtonView = new JunButtonViewSwing(this.getDrawingModel().brushButton());
			brushButtonView.setPreferredSize(new Dimension(24, 24));
			brushButtonView.setMaximumSize(new Dimension(24, 24));
			brushButtonView.setMinimumSize(new Dimension(24, 24));
			brushButtonView.setToolTipText($String("Freehand"));
		}
		return brushButtonView;
	}

	/**
	 * Answer the camera button view.
	 *
	 * @return jp.co.sra.jun.goodies.button.JunButtonViewSwing
	 * @category interface opening
	 */
	protected JunButtonViewSwing cameraButtonView() {
		if (cameraButtonView == null) {
			cameraButtonView = new JunButtonViewSwing(this.getDrawingModel().cameraButton());
			cameraButtonView.setPreferredSize(new Dimension(24, 24));
			cameraButtonView.setMaximumSize(new Dimension(24, 24));
			cameraButtonView.setMinimumSize(new Dimension(24, 24));
			cameraButtonView.setToolTipText($String("Image"));
		}
		return cameraButtonView;
	}

	/**
	 * Answer the ellipse button view.
	 *
	 * @return jp.co.sra.jun.goodies.button.JunButtonViewSwing
	 * @category interface opening
	 */
	protected JunButtonViewSwing ellipseButtonView() {
		if (ellipseButtonView == null) {
			ellipseButtonView = new JunButtonViewSwing(this.getDrawingModel().ellipseButton());
			ellipseButtonView.setPreferredSize(new Dimension(24, 24));
			ellipseButtonView.setMaximumSize(new Dimension(24, 24));
			ellipseButtonView.setMinimumSize(new Dimension(24, 24));
			ellipseButtonView.setToolTipText($String("Ellipse"));
		}
		return ellipseButtonView;
	}

	/**
	 * Answer the link button view.
	 *
	 * @return jp.co.sra.jun.goodies.button.JunButtonViewSwing
	 * @category interface opening
	 */
	protected JunButtonViewSwing linkButtonView() {
		if (linkButtonView == null) {
			linkButtonView = new JunButtonViewSwing(this.getDrawingModel().linkButton());
			linkButtonView.setPreferredSize(new Dimension(24, 24));
			linkButtonView.setMaximumSize(new Dimension(24, 24));
			linkButtonView.setMinimumSize(new Dimension(24, 24));
			linkButtonView.setToolTipText($String("Link"));
		}
		return linkButtonView;
	}

	/**
	 * Answer the path button view.
	 *
	 * @return jp.co.sra.jun.goodies.button.JunButtonViewSwing
	 * @category interface opening
	 */
	protected JunButtonViewSwing pathButtonView() {
		if (pathButtonView == null) {
			pathButtonView = new JunButtonViewSwing(this.getDrawingModel().pathButton());
			pathButtonView.setPreferredSize(new Dimension(24, 24));
			pathButtonView.setMaximumSize(new Dimension(24, 24));
			pathButtonView.setMinimumSize(new Dimension(24, 24));
			pathButtonView.setToolTipText($String("Path"));
		}
		return pathButtonView;
	}

	/**
	 * Answer the rectangle button view.
	 *
	 * @return jp.co.sra.jun.goodies.button.JunButtonViewSwing
	 * @category interface opening
	 */
	protected JunButtonViewSwing rectangleButtonView() {
		if (rectangleButtonView == null) {
			rectangleButtonView = new JunButtonViewSwing(this.getDrawingModel().rectangleButton());
			rectangleButtonView.setPreferredSize(new Dimension(24, 24));
			rectangleButtonView.setMaximumSize(new Dimension(24, 24));
			rectangleButtonView.setMinimumSize(new Dimension(24, 24));
			rectangleButtonView.setToolTipText($String("Rectangle"));
		}
		return rectangleButtonView;
	}

	/**
	 * Answer the round rectangle button view.
	 *
	 * @return jp.co.sra.jun.goodies.button.JunButtonViewSwing
	 * @category interface opening
	 */
	protected JunButtonViewSwing roundRectangleButtonView() {
		if (roundRectangleButtonView == null) {
			roundRectangleButtonView = new JunButtonViewSwing(this.getDrawingModel().roundRectangleButton());
			roundRectangleButtonView.setPreferredSize(new Dimension(24, 24));
			roundRectangleButtonView.setMaximumSize(new Dimension(24, 24));
			roundRectangleButtonView.setMinimumSize(new Dimension(24, 24));
			roundRectangleButtonView.setToolTipText($String("Round Rectangle"));
		}
		return roundRectangleButtonView;
	}

	/**
	 * Answer the select button view.
	 *
	 * @return jp.co.sra.jun.goodies.button.JunButtonViewSwing
	 * @category interface opening
	 */
	protected JunButtonViewSwing selectButtonView() {
		if (selectButtonView == null) {
			selectButtonView = new JunButtonViewSwing(this.getDrawingModel().selectButton());
			selectButtonView.setPreferredSize(new Dimension(24, 24));
			selectButtonView.setMaximumSize(new Dimension(24, 24));
			selectButtonView.setMinimumSize(new Dimension(24, 24));
			selectButtonView.setToolTipText($String("Select"));
		}
		return selectButtonView;
	}

	/**
	 * Answer the text button view.
	 *
	 * @return jp.co.sra.jun.goodies.button.JunButtonViewSwing
	 * @category interface opening
	 */
	protected JunButtonViewSwing textButtonView() {
		if (textButtonView == null) {
			textButtonView = new JunButtonViewSwing(this.getDrawingModel().textButton());
			textButtonView.setPreferredSize(new Dimension(24, 24));
			textButtonView.setMaximumSize(new Dimension(24, 24));
			textButtonView.setMinimumSize(new Dimension(24, 24));
			textButtonView.setToolTipText($String("Text"));
		}
		return textButtonView;
	}

	/**
	 * Answer the text box button view.
	 *
	 * @return jp.co.sra.jun.goodies.button.JunButtonViewSwing
	 * @category interface opening
	 */
	protected JunButtonViewSwing textboxButtonView() {
		if (textboxButtonView == null) {
			textboxButtonView = new JunButtonViewSwing(this.getDrawingModel().textboxButton());
			textboxButtonView.setPreferredSize(new Dimension(24, 24));
			textboxButtonView.setMaximumSize(new Dimension(24, 24));
			textboxButtonView.setMinimumSize(new Dimension(24, 24));
			textboxButtonView.setToolTipText($String("Textbox"));
		}
		return textboxButtonView;
	}
}
