package jp.co.sra.jun.goodies.display;

import java.awt.Frame;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;

import jp.co.sra.smalltalk.StComposedText;
import jp.co.sra.smalltalk.StDisplayable;
import jp.co.sra.smalltalk.StImage;
import jp.co.sra.smalltalk.StView;
import jp.co.sra.smalltalk.menu.MenuPerformer;
import jp.co.sra.smalltalk.menu.StMenuItem;
import jp.co.sra.smalltalk.menu.StPopupMenu;

import jp.co.sra.jun.system.framework.JunApplicationModel;
import jp.co.sra.jun.system.support.JunSystem;

/**
 * JunDisplayModel class
 * 
 *  @author    nisinaka
 *  @created   1998/11/16 (by nisinaka)
 *  @updated   1999/11/11 (by MATSUDA Ryouichi)
 *  @updated   2002/01/09 (by nisinaka)
 *  @updated   2002/11/21 (by nisinaka)
 *  @updated   2003/03/19 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun580 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunDisplayModel.java,v 8.12 2008/02/20 06:31:22 nisinaka Exp $
 */
public class JunDisplayModel extends JunApplicationModel {

	protected StDisplayable displayObject;
	protected StPopupMenu _popupMenu;
	protected String kindString;
	protected boolean _scrollable;

	/**
	 * Create a new instance of JunDisplayModel, set a visual object, and open it.
	 * 
	 * @param anObject java.lang.Object
	 * @return jp.co.sra.jun.goodies.display.JunDisplayModel
	 * @category Instance creation
	 */
	public static JunDisplayModel OpenVisual_(Object anObject) {
		return OpenVisual_label_(anObject, anObject.getClass().getName());
	}

	/**
	 * Create a new instance of JunDisplayModel, set a visual object, and open it at the specified point.
	 * 
	 * @param anObject java.lang.Object
	 * @param aPoint java.awt.Point
	 * @return jp.co.sra.jun.goodies.display.JunDisplayModel
	 * @category Instance creation
	 */
	public static JunDisplayModel OpenVisual_at_(Object anObject, Point aPoint) {
		JunDisplayModel displayModel = new JunDisplayModel(anObject);
		displayModel.openAt_(aPoint);
		return displayModel;
	}

	/**
	 * Create a new instance of JunDisplayModel, set a visual object, and open it in the specified area.
	 * 
	 * @param anObject java.lang.Object
	 * @param aRectangle java.awt.Rectangle
	 * @return jp.co.sra.jun.goodies.display.JunDisplayModel
	 * @category Instance creation
	 */
	public static JunDisplayModel OpenVisual_in_(Object anObject, Rectangle aRectangle) {
		JunDisplayModel displayModel = new JunDisplayModel(anObject);
		displayModel.openIn_(aRectangle);
		return displayModel;
	}

	/**
	 * Create a new instance of JunDisplayModel, set a visual object and a window title, and open it.
	 * 
	 * @param anObject java.lang.Object
	 * @param aString java.lang.String
	 * @return jp.co.sra.jun.goodies.display.JunDisplayModel
	 * @category Instance creation
	 */
	public static JunDisplayModel OpenVisual_label_(Object anObject, String aString) {
		JunDisplayModel displayModel = new JunDisplayModel(anObject);
		Frame window = displayModel.open();
		if (aString != null) {
			window.setTitle(aString);
		}
		return displayModel;
	}

	/**
	 * Create a new instance of JunDisplayModel, set a visual object and a window title, and open it in the specified area.
	 * 
	 * @param anObject java.lang.Object
	 * @param aString java.lang.String
	 * @param aRectangle java.awt.Rectangle
	 * @return jp.co.sra.jun.goodies.display.JunDisplayModel
	 * @category Instance creation
	 */
	public static JunDisplayModel OpenVisual_label_in_(Object anObject, String aString, Rectangle aRectangle) {
		JunDisplayModel displayModel = new JunDisplayModel(anObject);
		Frame window = displayModel.openIn_(aRectangle);
		if (aString != null) {
			window.setTitle(aString);
		}
		return displayModel;
	}

	/**
	 * Create a new instance of JunDisplayModel and set a visual object.
	 * 
	 * @param anObject java.lang.Object
	 * @return jp.co.sra.jun.goodies.display.JunDisplayModel
	 * @category Instance creation
	 */
	public static JunDisplayModel Visual_(Object anObject) {
		return new JunDisplayModel(anObject);
	}

	/**
	 * Show the object.
	 * 
	 * @param anObject java.lang.Object
	 * @return jp.co.sra.jun.goodies.display.JunDisplayModel
	 * @category Utilities
	 */
	public static JunDisplayModel Show_(Object anObject) {
		return OpenVisual_(anObject);
	}

	/**
	 * Show the object at the specified point..
	 * 
	 * @param anObject java.lang.Object
	 * @param aPoint java.awt.Point
	 * @return jp.co.sra.jun.goodies.display.JunDisplayModel
	 * @category Utilities
	 */
	public static JunDisplayModel Show_at_(Object anObject, Point aPoint) {
		return OpenVisual_at_(anObject, aPoint);
	}

	/**
	 * Show the object at the specified point..
	 * 
	 * @param anObject java.lang.Object
	 * @param aRectangle java.awt.Rectangle
	 * @return jp.co.sra.jun.goodies.display.JunDisplayModel
	 * @category Utilities
	 */
	public static JunDisplayModel Show_in_(Object anObject, Rectangle aRectangle) {
		return OpenVisual_in_(anObject, aRectangle);
	}

	/**
	 * Create a new instance of JunDisplayModel.
	 * 
	 * @category Instance creation
	 */
	public JunDisplayModel() {
		super();
	}

	/**
	 * Create a new instance of JunDisplayModel and set a visual object.
	 * 
	 * @param anObject java.lang.Object
	 * @category Instance creation
	 */
	public JunDisplayModel(Object anObject) {
		this.visual_(anObject);
	}

	/**
	 * Initialize the receiver.
	 * 
	 * @see jp.co.sra.smalltalk.StApplicationModel#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();

		displayObject = null;
		_popupMenu = null;
		kindString = null;
		_scrollable = true;
	}

	/**
	 * Answer my current visual object.
	 * 
	 * @return jp.co.sra.smalltalk.StDisplayable
	 * @category accessing
	 */
	public StDisplayable visual() {
		if (displayObject == null) {
			this.visual_(new String());
		}
		return displayObject;
	}

	/**
	 * Set my new visual object. 
	 * If the visual object is changed, announce it.
	 * 
	 * @param anObject java.lang.Object
	 * @category accessing
	 */
	public void visual_(Object anObject) {
		kindString = anObject.getClass().getName();

		Object visual = anObject;
		if (visual != displayObject) {
			if (visual == null) {
				displayObject = new StComposedText(new String());
			} else if (visual instanceof StDisplayable) {
				displayObject = (StDisplayable) visual;
			} else if (visual instanceof Image) {
				displayObject = new StImage((Image) visual);
			} else {
				String aString = (anObject instanceof String) ? (String) anObject : anObject.toString();
				if (aString.length() == 0) {
					aString = " ";
				}
				displayObject = new StComposedText(aString);
			}
			displayObject = displayObject.asImage();
			this.visualIsChanged();
		}
	}

	/**
	 * Answer whether the view is opened with scrollbars or not.
	 *
	 * @return boolean
	 * @category accessing
	 */
	public boolean _isScrollable() {
		return _scrollable;
	}

	/**
	 * Set whether the view is opened with scrollbars or not.
	 *
	 * @param aBoolean boolean
	 * @category accessing
	 */
	public void _isScrollable(boolean aBoolean) {
		_scrollable = aBoolean;
	}

	/**
	 * Convert the receiver to an image as StImage.
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @see jp.co.sra.jun.system.framework.JunApplicationModel#asImage()
	 * @category converting
	 */
	public StImage asImage() {
		return this.visual().asImage();
	}

	/**
	 * Create a default view.
	 * 
	 * @return jp.co.sra.smalltalk.StView
	 * @see jp.co.sra.smalltalk.StApplicationModel#defaultView()
	 * @category interface opening
	 */
	public StView defaultView() {
		if (GetDefaultViewMode() == VIEW_AWT) {
			return new JunDisplayViewAwt(this, this.visual().bounds().getSize());
		} else {
			return new JunDisplayViewSwing(this, this.visual().bounds().getSize());
		}
	}

	/**
	 * Answer a window title.
	 * 
	 * @return java.lang.String
	 * @see jp.co.sra.smalltalk.StApplicationModel#windowTitle()
	 * @category interface opening
	 */
	protected String windowTitle() {
		if (kindString == null) {
			return JunSystem.$String("Display");
		}
		return kindString;
	}

	/**
	 * Answer my popup menu.
	 * 
	 * @return jp.co.sra.smalltalk.menu.StPopupMenu
	 * @see jp.co.sra.smalltalk.StApplicationModel#_popupMenu()
	 * @category resources
	 */
	public StPopupMenu _popupMenu() {
		if (_popupMenu == null) {
			StPopupMenu aPopupMenu = new StPopupMenu();
			aPopupMenu.add(new StMenuItem(JunSystem.$String("Save as image..."), new MenuPerformer(this, "saveAsImage")));
			_popupMenu = aPopupMenu;
		}
		return _popupMenu;
	}

	/**
	 * Answer a view.
	 * 
	 * @return jp.co.sra.smalltalk.StView
	 * @see jp.co.sra.jun.system.framework.JunApplicationModel#getView()
	 * @category private
	 */
	public StView getView() {
		Object[] dependents = this.dependents();
		for (int i = 0; i < dependents.length; i++) {
			if (dependents[i] instanceof JunDisplayView && ((JunDisplayView) dependents[i]).model() == this) {
				return (JunDisplayView) dependents[i];
			}
		}

		return null;
	}

	/**
	 * Process the change of my visual object.
	 * 
	 * @category private
	 */
	protected void visualIsChanged() {
		this.changed_($("visual"));
		this.updateWindowTitle();
	}

}
