package jp.co.sra.jun.goodies.colors;

import java.awt.Rectangle;
import jp.co.sra.jun.system.framework.JunAbstractView;

/**
 * JunColorChoiceView interface
 * 
 *  @author    MATSUDA Ryouichi
 *  @created   2000/01/21 (by MATSUDA Ryouichi)
 *  @updated   2003/04/02 (by Mitsuhiro Asada)
 *  @updated   2004/09/21 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun473 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunColorChoiceView.java,v 8.10 2008/02/20 06:31:22 nisinaka Exp $
 */
public interface JunColorChoiceView extends JunAbstractView {

	/**
	 * Answer the area of color bar.
	 * 
	 * @return java.awt.Rectangle
	 * @category area accessing
	 */
	public Rectangle barArea();

	/**
	 * Answer the area of color brightness.
	 * 
	 * @return java.awt.Rectangle
	 * @category area accessing
	 */
	public Rectangle brightnessArea();

	/**
	 * Answer the model's brightness string.
	 * 
	 * @return java.lang.String
	 * @category string accessing
	 */
	public String brightnessString();

	/**
	 * Answer the area of color plate.
	 * 
	 * @return java.awt.Rectangle
	 * @category area accessing
	 */
	public Rectangle colorArea();

	/**
	 * Answer the string of a color.
	 * 
	 * @return java.lang.String
	 * @category string accessing
	 */
	public String colorString();

	/**
	 * model property accessing.
	 * 
	 * @return jp.co.sra.jun.goodies.colors.JunColorChoiceModel
	 * @category model accessing
	 */
	public JunColorChoiceModel getModel();

	/**
	 * Answer the area of color hue.
	 * 
	 * @return java.awt.Rectangle
	 * @category area accessing
	 */
	public Rectangle hueArea();

	/**
	 * Answer the model's brightness string.
	 * 
	 * @return java.lang.String
	 * @category string accessing
	 */
	public String hueString();

	/**
	 * Answer the area of plate.
	 * 
	 * @return java.awt.Rectangle
	 * @category area accessing
	 */
	public Rectangle plateArea();

	/**
	 * Answer the area of saturation.
	 * 
	 * @return java.awt.Rectangle
	 * @category area accessing
	 */
	public Rectangle saturationArea();

	/**
	 * Answer the model's saturation string.
	 * 
	 * @return java.lang.String
	 * @category string accessing
	 */
	public String saturationString();

	/**
	 * model property accessing.
	 * 
	 * @param aModel jp.co.sra.jun.goodies.colors.JunColorChoiceModel
	 * @category model accessing
	 */
	public void setModel(JunColorChoiceModel aModel);

	/**
	 * Answer the area of squit.
	 * 
	 * @return java.awt.Rectangle
	 * @category area accessing
	 */
	public Rectangle spuitArea();

}