package jp.co.sra.jun.goodies.colors;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import jp.co.sra.smalltalk.StSimpleDialogViewSwing;
import jp.co.sra.jun.system.support.JunSystem;

/**
 * JunColorChoiceDialogViewSwing class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2003/04/02 (by Mitsuhiro Asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun490 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunColorChoiceDialogViewSwing.java,v 8.10 2008/02/20 06:31:22 nisinaka Exp $
 */
public class JunColorChoiceDialogViewSwing extends StSimpleDialogViewSwing implements JunColorChoiceDialogView {
	protected JunColorChoiceViewSwing colorChoiceView;
	protected JButton acceptButton;
	protected JButton cancelButton;

	/**
	 * Create a new instance of JunColorChoiceDialogViewSwing and initialize it with the JunColorChoiceDialog.
	 * 
	 * @param newColorChoiceDialog jp.co.sra.jun.goodies.colors.JunColorChoiceDialog
	 * @category Instance creation
	 */
	public JunColorChoiceDialogViewSwing(JunColorChoiceDialog newColorChoiceDialog) {
		super(newColorChoiceDialog);
	}

	/**
	 * Answer my model as a JunColorChoiceDialog.
	 * 
	 * @return jp.co.sra.jun.goodies.colors.JunColorChoiceDialog
	 * @category model accessing
	 */
	public JunColorChoiceDialog getColorChoiceDialog() {
		return (JunColorChoiceDialog) this.model();
	}

	/**
	 * Answer the panel on accept/cancel buttons.
	 * 
	 * @return javax.swing.JPanel
	 * @category interface opening
	 */
	protected JPanel _acceptCancelButtons() {
		JPanel panel = new JPanel();
		panel.setLayout(new FlowLayout());
		panel.add(this.acceptButton());
		panel.add(this.cancelButton());

		return panel;
	}

	/**
	 * Answer my accpet button.
	 *
	 * @return javax.swing.JButton
	 * @category interface opening
	 */
	protected JButton acceptButton() {
		if (acceptButton == null) {
			acceptButton = new JButton(JunSystem.$String("Accept"));
			acceptButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					if (getColorChoiceDialog().acceptButtonPressed()) {
						getColorChoiceDialog().accept().value_(true);
					}
				}
			});
		}
		return acceptButton;
	}

	/**
	 * Build this component.
	 * 
	 * @category interface opening
	 */
	protected void buildComponent() {
		this.setLayout(new BorderLayout());
		this.add(this.colorChoiceView(), BorderLayout.CENTER);
		this.add(this._acceptCancelButtons(), BorderLayout.SOUTH);

		defaultButton = this.acceptButton();
	}

	/**
	 * Answer my cancel button.
	 *
	 * @return javax.swing.JButton
	 * @category interface opening
	 */
	protected JButton cancelButton() {
		if (cancelButton == null) {
			cancelButton = new JButton(JunSystem.$String("Cancel"));
			cancelButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					if (getColorChoiceDialog().cancelButtonPressed()) {
						getColorChoiceDialog().cancel().value_(true);
					}
				}
			});
		}
		return cancelButton;
	}

	/**
	 * Answer my color choice view.
	 *
	 * @return jp.co.sra.jun.goodies.colors.JunColorChoiceViewSwing
	 * @category interface opening
	 */
	protected JunColorChoiceViewSwing colorChoiceView() {
		if (colorChoiceView == null) {
			colorChoiceView = new JunColorChoiceViewSwing(this.getColorChoiceDialog().colorChoiceModel());
		}
		return colorChoiceView;
	}
}
