package jp.co.sra.jun.goodies.colors;

import java.awt.Color;
import jp.co.sra.jun.system.support.JunTestExamples;
import jp.co.sra.smalltalk.StBlockClosure;

/**
 * JunColorChoiceDialogTestExamples class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2003/04/02 (by Mitsuhiro Asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun490 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunColorChoiceDialogTestExamples.java,v 8.10 2008/02/20 06:31:22 nisinaka Exp $
 */
public class JunColorChoiceDialogTestExamples extends JunTestExamples {

	/**
	 * Example1: Call Request().
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		Color color = JunColorChoiceDialog.Request();
		System.out.println(color);
		return true;
	}

	/**
	 * Example2: Request to select a color.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example2() {
		Color color = JunColorChoiceDialog.Request_("Select a color");
		System.out.println(color);
		return true;
	}

	/**
	 * Example3: Request to select a color with color value.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example3() {
		Color color = JunColorChoiceDialog.Request_color_("Select a color", Color.green);
		System.out.println(color);
		return true;
	}

	/**
	 * Example4: Request to select a color with color choice model.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example4() {
		Color color = JunColorChoiceDialog.Request_colorChoice_("Select a color", new JunColorChoiceHSB());
		System.out.println(color);
		return true;
	}

	/**
	 * Example5: Request to select a color.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example5() {
		Color color = JunColorChoiceDialog.Request_colorChoice_onAccept_onCancel_("Select a color", new JunColorChoiceSBH(), new StBlockClosure() {
			public Object value_(Object model) {
				System.out.println("Accept button was pressed.");
				System.out.println("\t" + ((JunColorChoiceModel) model).color());
				return Boolean.TRUE;
			}
		}, new StBlockClosure() {
			public Object value_(Object model) {
				System.out.println("Cancel button was pressed.");
				System.out.println("\t" + ((JunColorChoiceModel) model).color());
				return Boolean.TRUE;
			}
		});
		System.out.println(color);
		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args an array of command-line arguments
	 * @category Main
	 */
	public static void main(java.lang.String[] args) {
		new JunColorChoiceDialogTestExamples();
	}
}