package jp.co.sra.jun.goodies.colors;

import java.awt.*;
import jp.co.sra.smalltalk.*;
import jp.co.sra.jun.system.support.JunSystem;

/**
 * JunColorChoiceDialog class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2003/04/02 (by Mitsuhiro Asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun490 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunColorChoiceDialog.java,v 8.11 2008/02/20 06:31:22 nisinaka Exp $
 */
public class JunColorChoiceDialog extends StSimpleDialog {
	protected JunColorChoiceModel colorChoiceModel;
	protected StBlockClosure acceptBlock;
	protected StBlockClosure cancelBlock;

	/**
	 * Open a color choice dialog and let a user to choose.
	 * 
	 * @return java.awt.Color
	 * @category Utilities
	 */
	public static Color Request() {
		return Request_(null);
	}

	/**
	 * Open a color choice dialog and let a user to choose.
	 * 
	 * @return java.awt.Color
	 * @param messageString java.lang.String
	 * @category Utilities
	 */
	public static Color Request_(String messageString) {
		return Request_colorChoice_(messageString, new JunColorChoiceSBH());
	}

	/**
	 * Open a color choice dialog and let a user to choose.
	 * 
	 * @return java.awt.Color
	 * @param messageString java.lang.String
	 * @param colorValue java.lang.Color
	 * @category Utilities
	 */
	public static Color Request_color_(String messageString, Color colorValue) {
		JunColorChoiceModel colorChoiceModel = new JunColorChoiceSBH();
		colorChoiceModel.color_(colorValue);
		return Request_colorChoice_onAccept_onCancel_(messageString, colorChoiceModel, null, null);
	}

	/**
	 * Open a color choice dialog and let a user to choose.
	 * 
	 * @return java.awt.Color
	 * @param messageString java.lang.String
	 * @param colorChoiceModel jp.co.sra.jun.goodies.colors.JunColorChoiceModel
	 * @category Utilities
	 */
	public static Color Request_colorChoice_(String messageString, JunColorChoiceModel colorChoiceModel) {
		return Request_colorChoice_onAccept_onCancel_(messageString, colorChoiceModel, null, null);
	}

	/**
	 * Open a color choice dialog and let a user to choose.
	 * 
	 * @return java.awt.Color
	 * @param messageString java.lang.String
	 * @param colorChoiceModel jp.co.sra.jun.goodies.colors.JunColorChoiceModel
	 * @param acceptBlock jp.co.sra.smalltalk.StBlockClosure
	 * @param cancelBlock jp.co.sra.smalltalk.StBlockClosure
	 * @category Utilities
	 */
	public static Color Request_colorChoice_onAccept_onCancel_(String messageString, JunColorChoiceModel colorChoiceModel, StBlockClosure acceptBlock, StBlockClosure cancelBlock) {
		JunColorChoiceDialog colorChoiceDialog = new JunColorChoiceDialog();
		if (colorChoiceModel != null) {
			colorChoiceDialog.colorChoiceModel_(colorChoiceModel);
		}
		Dialog dialog = colorChoiceDialog.allButOpenDialog();
		if (messageString != null) {
			dialog.setTitle(messageString);
		}
		if (acceptBlock != null) {
			colorChoiceDialog.acceptBlock_(acceptBlock);
		}
		if (cancelBlock != null) {
			colorChoiceDialog.cancelBlock_(cancelBlock);
		}

		_ShowAtMousePoint(dialog);
		if (colorChoiceDialog.accept()._booleanValue()) {
			return colorChoiceDialog.colorChoiceModel().color();
		} else {
			return null;
		}
	}

	/**
	 * Called when an accept button is pressed.
	 *
	 * @return boolean
	 * @category actions
	 */
	public boolean acceptButtonPressed() {
		if (acceptBlock != null) {
			return ((Boolean) acceptBlock.value_(this.colorChoiceModel())).booleanValue();
		}
		return true;
	}

	/**
	 * Called when an cancel button is pressed.
	 *
	 * @return boolean
	 * @category actions
	 */
	public boolean cancelButtonPressed() {
		if (cancelBlock != null) {
			return ((Boolean) cancelBlock.value_(this.colorChoiceModel())).booleanValue();
		}
		return true;
	}

	/**
	 * Answer the current color choice model.
	 *
	 * @return jp.co.sra.jun.goodies.colors.JunColorChoiceModel
	 * @category accessing
	 */
	public JunColorChoiceModel colorChoiceModel() {
		if (colorChoiceModel == null) {
			colorChoiceModel = new JunColorChoiceSBH();
		}
		return colorChoiceModel;
	}

	/**
	 * Set the current color choice model.
	 *
	 * @param choiceModel jp.co.sra.jun.goodies.colors.JunColorChoiceModel
	 * @category accessing
	 */
	public void colorChoiceModel_(JunColorChoiceModel choiceModel) {
		colorChoiceModel = choiceModel;
	}

	/**
	 * Answer a default view.
	 * 
	 * @return jp.co.sra.smalltalk.StView
	 * @see jp.co.sra.smalltalk.StSimpleDialog#defaultView()
	 * @category interface opening
	 */
	public StView defaultView() {
		if (GetDefaultViewMode() == VIEW_AWT) {
			return new JunColorChoiceDialogViewAwt(this);
		} else {
			return new JunColorChoiceDialogViewSwing(this);
		}
	}

	/**
	 * Set the new accept block.
	 *
	 * @param newAcceptBlock jp.co.sra.smalltalk.StBlockClosure
	 * @category accessing
	 */
	protected void acceptBlock_(StBlockClosure newAcceptBlock) {
		acceptBlock = newAcceptBlock;
	}

	/**
	 * Set the new cancel block.
	 *
	 * @param newCancelBlock jp.co.sra.smalltalk.StBlockClosure
	 * @category accessing
	 */
	protected void cancelBlock_(StBlockClosure newCancelBlock) {
		cancelBlock = newCancelBlock;
	}

	/**
	 * Initialize the ApplicationModel when created.
	 * 
	 * @see jp.co.sra.smalltalk.StSimpleDialog#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();

		acceptBlock = null;
		cancelBlock = null;
	}

	/**
	 * Answer a window title.
	 * 
	 * @return java.lang.String
	 * @see jp.co.sra.smalltalk.StSimpleDialog#windowTitle()
	 * @category interface opening
	 */
	protected String windowTitle() {
		return JunSystem.$String("Color Choice Dialog");
	}
}