package jp.co.sra.jun.goodies.colors;

import java.awt.Color;
import java.awt.Point;
import jp.co.sra.smalltalk.StColorValue;
import jp.co.sra.smalltalk.StRectangle;
import jp.co.sra.jun.system.framework.JunAbstractView;

/**
 * JunColorBarView interface
 * 
 *  @author    nisinaka
 *  @created   2004/06/10 (by nisinaka)
 *  @updated   2004/09/21 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun473 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunColorBarView.java,v 8.10 2008/02/20 06:31:22 nisinaka Exp $
 */
public interface JunColorBarView extends JunAbstractView {

	public static final Color Gray20 = StColorValue.Brightness_(0.2);
	public static final Color Gray40 = StColorValue.Brightness_(0.4);
	public static final Color Gray70 = StColorValue.Brightness_(0.7);
	public static final Color Gray80 = StColorValue.Brightness_(0.8);

	/**
	 * Answer my model as JunColorBarModel.
	 * 
	 * @return jp.co.sra.jun.goodies.colors.JunColorBarModel
	 * @category model accessing
	 */
	public JunColorBarModel getColorBarModel();

	/**
	 * Answer my current first marker rectangle.
	 * 
	 * @return jp.co.sra.smalltalk.StRectangle
	 * @category accessing
	 */
	public StRectangle firstMarkerRectangle();

	/**
	 * Answer my current first marker rectangle.
	 * 
	 * @return jp.co.sra.smalltalk.StRectangle
	 * @category accessing
	 */
	public StRectangle lastMarkerRectangle();

	/**
	 * Answer my current slider rectangle.
	 * 
	 * @return jp.co.sra.smalltalk.StRectangle
	 * @category accessing
	 */
	public StRectangle sliderRectangle();

	/**
	 * Answer my current another interval rectangle.
	 * 
	 * @return jp.co.sra.smalltalk.StRectangle
	 * @category accessing
	 */
	public StRectangle anotherIntervalRectangle();

	/**
	 * Answer my current range area.
	 * 
	 * @return jp.co.sra.smalltalk.StRectangle
	 * @category area accessing
	 */
	public StRectangle rangeArea();

	/**
	 * Answer true if the view is for a vertical bar, otherwise false.
	 * 
	 * @return boolean
	 * @category testing
	 */
	public boolean isVertical();

	/**
	 * Set the slider at the point.
	 * 
	 * @param aPoint java.awt.Point
	 * @category setting
	 */
	public void setSliderAt(Point aPoint);

	/**
	 * Set the first marker at the point.
	 * 
	 * @param aPoint java.awt.Point
	 * @category setting
	 */
	public void setFirstMarkerAt(Point aPoint);

	/**
	 * Set the last marker at the point.
	 * 
	 * @param aPoint java.awt.Point
	 * @category setting
	 */
	public void setLastMarkerAt(Point aPoint);

	/**
	 * Set the interval at the point.
	 * 
	 * @param aPoint java.awt.Point
	 * @category setting
	 */
	public void setIntervalAt(Point aPoint);

}
