package jp.co.sra.jun.goodies.colors;

import java.awt.Color;

/**
 * JunColorBarRGB class
 * 
 *  @author    nisinaka
 *  @created   2004/06/14 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun452 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunColorBarRGB.java,v 8.10 2008/02/20 06:31:22 nisinaka Exp $
 */
public class JunColorBarRGB extends JunColorBarModel {

	protected double[] redBounds;
	protected double[] greenBounds;
	protected double[] blueBounds;

	/**
	 * Initialize the receiver.
	 * 
	 * @see jp.co.sra.smalltalk.StApplicationModel#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();
		redBounds = null;
		greenBounds = null;
		blueBounds = null;
	}

	/**
	 * Answer my current red bounds.
	 * 
	 * @return double[]
	 * @category color accessing
	 */
	public double[] redBounds() {
		if (redBounds == null) {
			redBounds = new double[] { 0, 1 };
		}
		return redBounds;
	}

	/**
	 * Set my new red bounds.
	 * 
	 * @param newBounds double[]
	 * @category color accessing
	 */
	public void redBounds_(double[] newBounds) {
		redBounds = this.adjustInterval_(newBounds);
		this.changed_($("color"));
	}

	/**
	 * Answer my current green bounds.
	 * 
	 * @return double[]
	 * @category color accessing
	 */
	public double[] greenBounds() {
		if (greenBounds == null) {
			greenBounds = new double[] { 0, 1 };
		}
		return greenBounds;
	}

	/**
	 * Set my new green bounds.
	 * 
	 * @param newBounds double[]
	 * @category color accessing
	 */
	public void greenBounds_(double[] newBounds) {
		greenBounds = this.adjustInterval_(newBounds);
		this.changed_($("color"));
	}

	/**
	 * Answer my current blue bounds.
	 * 
	 * @return double[]
	 * @category color accessing
	 */
	public double[] blueBounds() {
		if (blueBounds == null) {
			blueBounds = new double[] { 0, 1 };
		}
		return blueBounds;
	}

	/**
	 * Set my new blue bounds.
	 * 
	 * @param newBounds double[]
	 * @category color accessing
	 */
	public void blueBounds_(double[] newBounds) {
		blueBounds = this.adjustInterval_(newBounds);
		this.changed_($("color"));
	}

	/**
	 * Answer the color which correspond to the normalized value.
	 * 
	 * @param normalizedValue double
	 * @return java.awt.Color
	 * @see jp.co.sra.jun.goodies.colors.JunColorBarModel#getColor_(double)
	 * @category private
	 */
	protected Color getColor_(double normalizedValue) {
		double red = (this.redBounds()[1] - this.redBounds()[0]) * normalizedValue + this.redBounds[0];
		double green = (this.greenBounds()[1] - this.greenBounds()[0]) * normalizedValue + this.greenBounds[0];
		double blue = (this.blueBounds()[1] - this.blueBounds()[0]) * normalizedValue + this.blueBounds[0];
		return new Color((float) red, (float) green, (float) blue);
	}

}
