package jp.co.sra.jun.goodies.colors;

import java.awt.Color;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StColorValue;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunColorBarModelTestExamples class
 * 
 *  @author    nisinaka
 *  @created   2004/06/10 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun462 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunColorBarModelTestExamples.java,v 8.10 2008/02/20 06:31:22 nisinaka Exp $
 */
public class JunColorBarModelTestExamples extends JunTestExamples {

	/**
	 * Example1: Open a default JunColorBarModel.
	 * 
	 * @return boolean
	 */
	public static boolean Example1() {
		JunColorBarModel colorBar = new JunColorBarModel();
		colorBar.open();

		return true;
	}

	/**
	 * Example2: Open a JunColorBarModel with some attributes.
	 * 
	 * @return boolean
	 */
	public static boolean Example2() {
		JunColorBarModel colorBar = new JunColorBarModel();
		colorBar.firstMarker_(0);
		colorBar.lastMarker_(1);
		colorBar.value_(0.5);
		colorBar.compute_(new StBlockClosure() {
			public Object value_(Object color) {
				System.out.println(StColorValue._PrintStringOf((Color) color));
				return null;
			}
		});
		colorBar.open();

		return true;
	}

	/**
	 * Example3: Open a JunColorBarModel with some attributes.
	 * 
	 * @return boolean
	 */
	public static boolean Example3() {
		JunColorBarModel colorBar = new JunColorBarModel();
		colorBar.firstMarker_(0.2);
		colorBar.lastMarker_(0.7);
		colorBar.value_(0.5);
		colorBar.valueCompute_(new StBlockClosure() {
			public Object value_(Object n) {
				System.out.println(n);
				return null;
			}
		});
		colorBar.open();

		return true;
	}

	/**
	 * Example4: Open a JunColorBarModel with some attributes.
	 * 
	 * @return boolean
	 */
	public static boolean Example4() {
		JunColorBarModel colorBar = new JunColorBarModel();
		colorBar.firstMarker_(0.2);
		colorBar.lastMarker_(0.7);
		colorBar.value_(0.5);
		colorBar.intervalCompute_(new StBlockClosure() {
			public Object value_(Object obj) {
				double[] interval = (double[]) obj;
				System.out.println(interval[0] + " " + interval[1]);
				return null;
			}
		});
		colorBar.open();

		return true;
	}

	/**
	 * Example5: Open a JunColorBarModel with some attributes.
	 * 
	 * @return boolean
	 */
	public static boolean Example5() {
		JunColorBarModel colorBar = new JunColorBarModel();
		colorBar.firstMarker_(0.2);
		colorBar.lastMarker_(0.7);
		colorBar.value_(0.5);
		colorBar.ultraFirstColor_(Color.blue);
		colorBar.ultraLastColor_(Color.red);
		colorBar.open();

		return true;
	}

	/**
	 * Example6: Open a JunColorBarModel with a vertical view.
	 * 
	 * @return boolean
	 */
	public static boolean Example6() {
		JunColorBarModel colorBar = new JunColorBarModel();
		colorBar.firstMarker_(0);
		colorBar.lastMarker_(1);
		colorBar.value_(0.5);
		colorBar.compute_(new StBlockClosure() {
			public Object value_(Object color) {
				System.out.println(StColorValue._PrintStringOf((Color) color));
				return null;
			}
		});
		colorBar.openVertical();

		return true;
	}

	/**
	 * Example_CMY1: Open a JunColorBarCMY with some attributes.
	 * 
	 * @return boolean
	 */
	public static boolean Example_CMY1() {
		JunColorBarCMY colorBar = new JunColorBarCMY();
		colorBar.firstMarker_(0.2);
		colorBar.lastMarker_(0.7);
		colorBar.value_(0.5);
		colorBar.compute_(new StBlockClosure() {
			public Object value_(Object color) {
				System.out.println(StColorValue._PrintStringOf((Color) color));
				return null;
			}
		});
		colorBar.open();

		return true;
	}

	/**
	 * Example_CMY2: Open a JunColorBarCMY with some attributes.
	 * 
	 * @return boolean
	 */
	public static boolean Example_CMY2() {
		JunColorBarCMY colorBar = new JunColorBarCMY();
		colorBar.firstMarker_(0.2);
		colorBar.lastMarker_(0.7);
		colorBar.value_(0.5);
		colorBar.cyanBounds_(new double[] { 0, 1 });
		colorBar.magentaBounds_(new double[] { 0, 0 });
		colorBar.yellowBounds_(new double[] { 0, 0 });
		colorBar.open();

		return true;
	}

	/**
	 * Example_CMY3: Open a JunColorBarCMY with some attributes.
	 * 
	 * @return boolean
	 */
	public static boolean Example_CMY3() {
		JunColorBarCMY colorBar = new JunColorBarCMY();
		colorBar.firstMarker_(0.2);
		colorBar.lastMarker_(0.7);
		colorBar.value_(0.5);
		colorBar.cyanBounds_(new double[] { 0, 0 });
		colorBar.magentaBounds_(new double[] { 0, 1 });
		colorBar.yellowBounds_(new double[] { 0, 0 });
		colorBar.open();

		return true;
	}

	/**
	 * Example_CMY4: Open a JunColorBarCMY with some attributes.
	 * 
	 * @return boolean
	 */
	public static boolean Example_CMY4() {
		JunColorBarCMY colorBar = new JunColorBarCMY();
		colorBar.firstMarker_(0.2);
		colorBar.lastMarker_(0.7);
		colorBar.value_(0.5);
		colorBar.cyanBounds_(new double[] { 0, 0 });
		colorBar.magentaBounds_(new double[] { 0, 0 });
		colorBar.yellowBounds_(new double[] { 0, 1 });
		colorBar.open();

		return true;
	}

	/**
	 * Example_HSB1: Open a JunColorBarHSB with some attributes.
	 * 
	 * @return boolean
	 */
	public static boolean Example_HSB1() {
		JunColorBarHSB colorBar = new JunColorBarHSB();
		colorBar.firstMarker_(0.2);
		colorBar.lastMarker_(0.7);
		colorBar.value_(0.5);
		colorBar.compute_(new StBlockClosure() {
			public Object value_(Object color) {
				System.out.println(StColorValue._PrintStringOf((Color) color));
				return null;
			}
		});
		colorBar.open();

		return true;
	}

	/**
	 * Example_HSB2: Open a JunColorBarHSB with some attributes.
	 * 
	 * @return boolean
	 */
	public static boolean Example_HSB2() {
		JunColorBarHSB colorBar = new JunColorBarHSB();
		colorBar.firstMarker_(0.2);
		colorBar.lastMarker_(0.7);
		colorBar.value_(0.5);
		colorBar.hueBounds_(new double[] { 0, (double) 4 / 6 });
		colorBar.saturationBounds_(new double[] { 1, 1 });
		colorBar.brightnessBounds_(new double[] { 1, 1 });
		colorBar.open();

		return true;
	}

	/**
	 * Example_HSB3: Open a JunColorBarHSB with some attributes.
	 * 
	 * @return boolean
	 */
	public static boolean Example_HSB3() {
		JunColorBarHSB colorBar = new JunColorBarHSB();
		colorBar.firstMarker_(0.2);
		colorBar.lastMarker_(0.7);
		colorBar.value_(0.5);
		colorBar.hueBounds_(new double[] { 1, 1 });
		colorBar.saturationBounds_(new double[] { 0, 1 });
		colorBar.brightnessBounds_(new double[] { 1, 1 });
		colorBar.open();

		return true;
	}

	/**
	 * Example_HSB4: Open a JunColorBarHSB with some attributes.
	 * 
	 * @return boolean
	 */
	public static boolean Example_HSB4() {
		JunColorBarHSB colorBar = new JunColorBarHSB();
		colorBar.firstMarker_(0.2);
		colorBar.lastMarker_(0.7);
		colorBar.value_(0.5);
		colorBar.hueBounds_(new double[] { 1, 1 });
		colorBar.saturationBounds_(new double[] { 0, 0 });
		colorBar.brightnessBounds_(new double[] { 0, 1 });
		colorBar.open();

		return true;
	}

	/**
	 * Example_RGB1: Open a JunColorBarRGB with some attributes.
	 * 
	 * @return boolean
	 */
	public static boolean Example_RGB1() {
		JunColorBarRGB colorBar = new JunColorBarRGB();
		colorBar.firstMarker_(0.2);
		colorBar.lastMarker_(0.7);
		colorBar.value_(0.5);
		colorBar.compute_(new StBlockClosure() {
			public Object value_(Object color) {
				System.out.println(StColorValue._PrintStringOf((Color) color));
				return null;
			}
		});
		colorBar.open();

		return true;
	}

	/**
	 * Example_RGB2: Open a JunColorBarRGB with some attributes.
	 * 
	 * @return boolean
	 */
	public static boolean Example_RGB2() {
		JunColorBarRGB colorBar = new JunColorBarRGB();
		colorBar.firstMarker_(0.2);
		colorBar.lastMarker_(0.7);
		colorBar.value_(0.5);
		colorBar.redBounds_(new double[] { 0, 1 });
		colorBar.greenBounds_(new double[] { 0, 0 });
		colorBar.blueBounds_(new double[] { 0, 0 });
		colorBar.open();

		return true;
	}

	/**
	 * Example_RGB3: Open a JunColorBarRGB with some attributes.
	 * 
	 * @return boolean
	 */
	public static boolean Example_RGB3() {
		JunColorBarRGB colorBar = new JunColorBarRGB();
		colorBar.firstMarker_(0.2);
		colorBar.lastMarker_(0.7);
		colorBar.value_(0.5);
		colorBar.redBounds_(new double[] { 0, 0 });
		colorBar.greenBounds_(new double[] { 0, 1 });
		colorBar.blueBounds_(new double[] { 0, 0 });
		colorBar.open();

		return true;
	}

	/**
	 * Example_RGB4: Open a JunColorBarRGB with some attributes.
	 * 
	 * @return boolean
	 */
	public static boolean Example_RGB4() {
		JunColorBarRGB colorBar = new JunColorBarRGB();
		colorBar.firstMarker_(0.2);
		colorBar.lastMarker_(0.7);
		colorBar.value_(0.5);
		colorBar.redBounds_(new double[] { 0, 0 });
		colorBar.greenBounds_(new double[] { 0, 0 });
		colorBar.blueBounds_(new double[] { 0, 1 });
		colorBar.open();

		return true;
	}

	/**
	 * Example_Collection1: Open a JunColorBarCollection with some attributes.
	 * 
	 * @return boolean
	 */
	public static boolean Example_Collection1() {
		JunColorBarCollection colorBar = new JunColorBarCollection();
		colorBar.firstMarker_(0.2);
		colorBar.lastMarker_(0.7);
		colorBar.value_(0.5);
		colorBar.compute_(new StBlockClosure() {
			public Object value_(Object color) {
				System.out.println(StColorValue._PrintStringOf((Color) color));
				return null;
			}
		});
		colorBar.open();

		return true;
	}

	/**
	 * Example_Collection2: Open a JunColorBarCollection with some attributes.
	 * 
	 * @return boolean
	 */
	public static boolean Example_Collection2() {
		JunColorBarCollection colorBar = new JunColorBarCollection();
		colorBar.firstMarker_(0.2);
		colorBar.lastMarker_(0.7);
		colorBar.value_(0.5);
		colorBar.colorCollection_(new Color[] { Color.red, Color.green, Color.blue, Color.cyan, Color.magenta, Color.yellow });
		colorBar.open();

		return true;
	}

	/**
	 * Example_Collection3: Open a JunColorBarCollection with some attributes.
	 * 
	 * @return boolean
	 */
	public static boolean Example_Collection3() {
		JunColorBarCollection colorBar = new JunColorBarCollection();
		colorBar.firstMarker_(0.2);
		colorBar.lastMarker_(0.7);
		colorBar.value_(0.5);
		colorBar.colorCollection_(new Color[] { Color.red, Color.green, Color.blue, Color.cyan, Color.magenta, Color.yellow });
		colorBar.compute_(new StBlockClosure() {
			public Object value_(Object color) {
				System.out.println(StColorValue._PrintStringOf((Color) color));
				return null;
			}
		});
		colorBar.open();

		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args an array of command-line arguments
	 */
	public static void main(java.lang.String[] args) {
		new JunColorBarModelTestExamples();
	}

}
