package jp.co.sra.jun.goodies.colors;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import jp.co.sra.smalltalk.StSimpleDialogViewSwing;
import jp.co.sra.smalltalk.WindowSpecLayout;
import jp.co.sra.jun.system.support.JunSystem;

/**
 * JunColorBarDialogViewSwing class
 * 
 *  @author    nisinaka
 *  @created   2004/06/14 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun492 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunColorBarDialogViewSwing.java,v 8.10 2008/02/20 06:31:22 nisinaka Exp $
 */
public class JunColorBarDialogViewSwing extends StSimpleDialogViewSwing implements JunColorBarDialogView {

	protected JunColorBarViewSwing colorBarView;
	protected JButton acceptButton;
	protected JButton cancelButton;

	/**
	 * Create a new instance of JunColorBarDialogViewSwing and initialize it.
	 * 
	 * @param aColorBarDialog jp.co.sra.jun.goodies.colors.JunColorBarDialog
	 * @category Instance creation
	 */
	public JunColorBarDialogViewSwing(JunColorBarDialog aColorBarDialog) {
		super(aColorBarDialog);
	}

	/**
	 * Answer my model as JunColorBarDialog.
	 * 
	 * @return jp.co.sra.jun.goodies.colors.JunColorBarDialog
	 * @see jp.co.sra.jun.goodies.colors.JunColorBarDialogView#getColorBarDialog()
	 * @category model accessing
	 */
	public JunColorBarDialog getColorBarDialog() {
		return (JunColorBarDialog) this.model();
	}

	/**
	 * Build this component.
	 * 
	 * @see jp.co.sra.smalltalk.StViewPanel#buildComponent()
	 * @category initialize-release
	 */
	protected void buildComponent() {
		this.setLayout(new WindowSpecLayout());
		this.add(this.colorBarView(), WindowSpecLayout.Position(0f, 0, 0f, 0, 1f, 0, 1f, -50));
		this.add(this.acceptButton(), WindowSpecLayout.Position(0.25f, -44, 1f, -40, 0.25f, 44, 1f, -8));
		this.add(this.cancelButton(), WindowSpecLayout.Position(0.75f, -44, 1f, -40, 0.75f, 44, 1f, -8));
		this.setPreferredSize(new Dimension(238, 100));

		defaultButton = this.acceptButton();
	}

	/**
	 * Answer my color bar view.
	 * 
	 * @return jp.co.sra.jun.goodies.colors.JunColorBarViewSwing
	 * @category user interface
	 */
	protected JunColorBarViewSwing colorBarView() {
		if (colorBarView == null) {
			colorBarView = new JunColorBarViewSwing(this.getColorBarDialog().colorBarModel());
		}
		return colorBarView;
	}

	/**
	 * Answer my accpet button.
	 *
	 * @return javax.swing.JButton
	 * @category user interface
	 */
	protected JButton acceptButton() {
		if (acceptButton == null) {
			acceptButton = new JButton(JunSystem.$String("Accept"));
			acceptButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					if (JunColorBarDialogViewSwing.this.getColorBarDialog().acceptButtonPressed()) {
						JunColorBarDialogViewSwing.this.getColorBarDialog().accept().value_(true);
					}
				}
			});
		}
		return acceptButton;
	}

	/**
	 * Answer my cancel button.
	 *
	 * @return javax.swing.JButton
	 * @category user interface
	 */
	protected JButton cancelButton() {
		if (cancelButton == null) {
			cancelButton = new JButton(JunSystem.$String("Cancel"));
			cancelButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					if (JunColorBarDialogViewSwing.this.getColorBarDialog().cancelButtonPressed()) {
						JunColorBarDialogViewSwing.this.getColorBarDialog().cancel().value_(true);
					}
				}
			});
		}
		return cancelButton;
	}

}
