package jp.co.sra.jun.goodies.calendar;

import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.util.Calendar;

import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StView;
import jp.co.sra.smalltalk.menu.MenuPerformer;
import jp.co.sra.smalltalk.menu.StMenuItem;
import jp.co.sra.smalltalk.menu.StPopupMenu;

import jp.co.sra.jun.system.support.JunSystem;

/**
 * JunCalendarTimeModel class
 * 
 *  @author    Nobuto Matsubara
 *  @created   2003/10/06 (by Nobuto Matsubara)
 *  @updated   2005/03/03 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun472 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunCalendarTimeModel.java,v 8.12 2008/02/20 06:31:13 nisinaka Exp $
 */
public class JunCalendarTimeModel extends JunCalendarModel {

	protected Calendar calendarTime;
	protected Calendar originalTime;
	protected StBlockClosure validateBlock;
	protected StPopupMenu _popupMenu;

	/**
	 * JunCalendarTimeModel.Hours_minutes_seconds_(new Integer(23), new Integer(59), new Integer(59)) *
	 *
	 * @param hour int
	 * @param minute int
	 * @param second int
	 * @return JunCalendarTimeModel
	 * @category Utilities
	 */
	public static JunCalendarTimeModel Hours_minutes_seconds_(int hour, int minute, int second) {
		Calendar aTime = Calendar.getInstance();
		aTime.set(aTime.get(Calendar.YEAR), aTime.get(Calendar.MONTH), aTime.get(Calendar.DATE), Math.max(0, Math.min(hour, 23)), Math.max(0, Math.min(minute, 59)), Math.max(0, Math.min(second, 59)));
		return JunCalendarTimeModel.Time_(aTime);
	}

	/**
	 * JunCalendarTimeModel.time_(Calendar.getInstance())
	 *
	 * @param aTime java.util.Calendar
	 * @return JunCalendarTimeModel
	 * @category Utilities
	 */
	public static JunCalendarTimeModel Time_(Calendar aTime) {
		return new JunCalendarTimeModel(aTime);
	}

	/**
	 * Create a new instance of <code>JunCalendarTimeModel</code> and initialize it.
	 * 
	 * @category Instance creation
	 */
	public JunCalendarTimeModel() {
		this.initialize();
	}

	/**
	 * Create instance and set time aTime.
	 *
	 * @param aTime java.util.Calendar
	 * @category Instance creation
	 */
	public JunCalendarTimeModel(Calendar aTime) {
		this.initialize_(aTime);
	}

	/**
	 * Copy time.
	 * @category menu messages
	 */
	public void copyTime() {
		Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(toString()), null);
	}

	/**
	 * Return default view.
	 *
	 * @return JunCalendarTimeView
	 * @category defaults
	 */
	public StView defaultView() {
		JunCalendarTimeView aView;
		if (GetDefaultViewMode() == VIEW_AWT) {
			aView = new JunCalendarTimeViewAwt(this);
		} else {
			aView = new JunCalendarTimeViewSwing(this);
		}
		return aView;
	}

	/**
	 * Action hour down.
	 * @category menu messages
	 */
	public void hourDown() {
		Calendar newTime;
		newTime = JunCalendarTimeModel.Hours_minutes_seconds_(this.hours() - 1 < 0 ? 23 : this.hours() - 1, this.minutes(), this.seconds()).time();
		this.time_(newTime);
	}

	/**
	 * Return hour.
	 *
	 * @return int
	 * @category accessing
	 */
	public int hours() {
		return this.time().get(Calendar.HOUR_OF_DAY);
	}

	/**
	 * Set hours.
	 *
	 * @param hour int
	 * @category accessing
	 */
	public void hours_(int hour) {
		Calendar newTime;
		if (!(0 <= hour && hour <= 23)) {
			return;
		}
		newTime = JunCalendarTimeModel.Hours_minutes_seconds_(hour, this.minutes(), this.seconds()).time();
		this.time_(newTime);
	}

	/**
	 * Action hour up.
	 * @category menu messages
	 */
	public void hourUp() {
		Calendar newTime;
		newTime = JunCalendarTimeModel.Hours_minutes_seconds_(this.hours() + 1 > 23 ? 0 : this.hours() + 1, this.minutes(), this.seconds()).time();
		this.time_(newTime);
	}

	/**
	 * Initialize and set time today.
	 * 
	 * @see jp.co.sra.jun.system.framework.JunApplicationModel#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		this.initialize_(Calendar.getInstance());
	}

	/**
	 * Initialize and set time aTime.
	 *
	 * @param aTime java.util.Calendar
	 * @category initialize-release
	 */
	private void initialize_(Calendar aTime) {
		super.initialize();
		this.time_(aTime);
		originalTime = aTime;
	}

	/**
	 * Action minute down.
	 * @category menu messages
	 */
	public void minuteDown() {
		Calendar newTime;
		newTime = JunCalendarTimeModel.Hours_minutes_seconds_(this.minutes() - 1 < 0 ? (this.hours() - 1 < 0 ? 23 : this.hours() - 1) : this.hours(), this.minutes() - 1 < 0 ? 59 : this.minutes() - 1, this.seconds()).time();
		this.time_(newTime);
	}

	/**
	 * Return minutes.
	 * 
	 * @return int
	 * @category accessing
	 */
	public int minutes() {
		return this.time().get(Calendar.MINUTE);
	}

	/**
	 * Set minutes.
	 *
	 * @param minute int
	 * @category accessing
	 */
	public void minutes_(int minute) {
		Calendar newTime;
		if (!(0 <= minute && minute <= 59)) {
			return;
		}
		newTime = JunCalendarTimeModel.Hours_minutes_seconds_(this.hours(), minute, this.seconds()).time();
		this.time_(newTime);
	}

	/**
	 * Action minute up.
	 * @category menu messages
	 */
	public void minuteUp() {
		Calendar newTime;
		newTime = JunCalendarTimeModel.Hours_minutes_seconds_(this.minutes() + 1 > 59 ? (this.hours() + 1 > 23 ? 0 : this.hours() + 1) : this.hours(), this.minutes() + 1 > 59 ? 0 : this.minutes() + 1, this.seconds()).time();
		this.time_(newTime);
	}

	/**
	 * Set to now time.
	 * @category menu messages
	 */
	public void nowTime() {
		this.time_(Calendar.getInstance());
	}

	/**
	 * Return Original time.
	 *
	 * @return java.util.Calendar
	 * @category menu messages
	 */
	public Calendar original() {
		return originalTime;
	}

	/**
	 * Set to original time.
	 * 
	 * @category accessing
	 */
	public void originalTime() {
		this.time_(this.original());
	}

	/**
	 * Answer my popup menu.
	 * 
	 * @return jp.co.sra.smalltalk.menu.StPopupMenu
	 * @see jp.co.sra.smalltalk.StApplicationModel#_popupMenu()
	 * @category resources
	 */
	public StPopupMenu _popupMenu() {
		if (_popupMenu == null) {
			_popupMenu = new StPopupMenu();
			_popupMenu.add(new StMenuItem(JunSystem.$String("Copy"), new MenuPerformer(this, "copyTime")));
			_popupMenu.addSeparator();
			_popupMenu.add(new StMenuItem(JunSystem.$String("Current time", "Now"), new MenuPerformer(this, "nowTime")));
			_popupMenu.add(new StMenuItem(JunSystem.$String("Original time"), new MenuPerformer(this, "originalTime")));
			_popupMenu.addSeparator();
			_popupMenu.add(new StMenuItem(JunSystem.$String("Hour down"), new MenuPerformer(this, "hourDown")));
			_popupMenu.add(new StMenuItem(JunSystem.$String("Hour up"), new MenuPerformer(this, "hourUp")));
			_popupMenu.addSeparator();
			_popupMenu.add(new StMenuItem(JunSystem.$String("Minute down"), new MenuPerformer(this, "minuteDown")));
			_popupMenu.add(new StMenuItem(JunSystem.$String("Minute up"), new MenuPerformer(this, "minuteUp")));
			_popupMenu.addSeparator();
			_popupMenu.add(new StMenuItem(JunSystem.$String("Second down"), new MenuPerformer(this, "secondDown")));
			_popupMenu.add(new StMenuItem(JunSystem.$String("Second up"), new MenuPerformer(this, "secondUp")));
		}
		return _popupMenu;
	}

	/**
	 * Action second down.
	 * @category menu messages
	 */
	public void secondDown() {
		Calendar newTime;
		newTime = JunCalendarTimeModel.Hours_minutes_seconds_(this.seconds() - 1 < 0 && this.minutes() - 1 < 0 ? (this.hours() - 1 < 0 ? 23 : this.hours() - 1) : this.hours(),
				this.seconds() - 1 < 0 ? (this.minutes() - 1 < 0 ? 59 : this.minutes() - 1) : this.minutes(), this.seconds() - 1 < 0 ? 59 : this.seconds() - 1).time();
		this.time_(newTime);
	}

	/**
	 * Return seconds.
	 *
	 * @return int
	 * @category accessing
	 */
	public int seconds() {
		return this.time().get(Calendar.SECOND);
	}

	/**
	 * Set seconds.
	 *
	 * @param second int
	 * @category accessing
	 */
	public void seconds_(int second) {
		Calendar newTime;
		if (!(0 <= second && second <= 59)) {
			return;
		}
		newTime = JunCalendarTimeModel.Hours_minutes_seconds_(this.hours(), this.minutes(), second).time();
		this.time_(newTime);
	}

	/**
	 * Action second up.
	 * @category menu messages
	 */
	public void secondUp() {
		Calendar newTime;
		newTime = JunCalendarTimeModel.Hours_minutes_seconds_(this.seconds() + 1 > 59 && this.minutes() + 1 > 59 ? (this.hours() + 1 > 23 ? 0 : this.hours() + 1) : this.hours(),
				this.seconds() + 1 > 59 ? (this.minutes() + 1 > 59 ? 0 : this.minutes() + 1) : this.minutes(), this.seconds() + 1 > 59 ? 0 : this.seconds() + 1).time();
		this.time_(newTime);
	}

	/**
	 * Set time.
	 *
	 * @param aTime java.util.Calendar
	 * @category accessing
	 */
	public void setTime_(Calendar aTime) {
		calendarTime = aTime;
	}

	/**
	 * Return time.
	 *
	 * @return java.util.Calendar
	 * @category accessing
	 */
	public Calendar time() {
		return calendarTime;
	}

	/**
	 * Set time.
	 *
	 * @param aTime java.util.Calendar
	 * @category accessing
	 */
	public void time_(Calendar aTime) {
		Calendar oldTime = this.time() == null ? null : (Calendar) this.time().clone();
		Calendar newTime = (Calendar) this.validateBlock().value_value_(oldTime, aTime);
		if (newTime == null) {
			return;
		}
		calendarTime = newTime;

		if (oldTime == null) {
			this.changed_($("time"));
			return;
		}
		if (!(oldTime.get(Calendar.HOUR_OF_DAY) == calendarTime.get(Calendar.HOUR_OF_DAY))) {
			this.changed_($("hours"));
			return;
		}
		if (!(oldTime.get(Calendar.MINUTE) == calendarTime.get(Calendar.MINUTE))) {
			this.changed_($("minutes"));
			return;
		}
		if (!(oldTime.get(Calendar.SECOND) == calendarTime.get(Calendar.SECOND))) {
			this.changed_($("seconds"));
			return;
		}
	}

	/**
	 * Return current time info.
	 *
	 * @return java.lang.String
	 * @category printing
	 */
	public String toString() {
		StringBuffer buf = new StringBuffer();
		buf.append(this.hours());
		buf.append(":");
		buf.append(this.minutes());
		buf.append(":");
		buf.append(this.seconds());
		if (this.time().get(Calendar.AM_PM) == 1) {
			buf.append(" PM");
		} else {
			buf.append(" AM");
		}
		return buf.toString();
	}

	/**
	 * Return aBlock.
	 *
	 * @return jp.co.sra.smalltalk.StBlockClosure
	 * @category accessing
	 */
	public StBlockClosure validateBlock() {
		if (validateBlock == null) {
			validateBlock = new StBlockClosure() {
				public Object value_value_(Object oldTime, Object newTime) {
					return newTime;
				}
			};
		}
		return validateBlock;
	}

	/**
	 * Set aBlock.
	 *
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * @category accessing
	 */
	public void validateBlock_(StBlockClosure aBlock) {
		validateBlock = aBlock;
	}

	/**
	 * Answer a window title.
	 * 
	 * @return java.lang.String
	 * @category interface opening
	 */
	protected String windowTitle() {
		return JunSystem.$String("HHMMSS", "Time");
	}
}
