package jp.co.sra.jun.goodies.calendar;

import java.awt.Button;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import jp.co.sra.jun.system.support.JunSystem;
import jp.co.sra.smalltalk.StSimpleDialogViewAwt;
import jp.co.sra.smalltalk.WindowSpecLayout;

/**
 * JunCalendarTimeDialogViewAwt class
 * 
 *  @author    Nobuto Matsubara
 *  @created   2003/10/06 (by Nobuto Matsubara)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun472 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunCalendarTimeDialogViewAwt.java,v 8.12 2008/02/20 06:31:12 nisinaka Exp $
 */
public class JunCalendarTimeDialogViewAwt extends StSimpleDialogViewAwt implements JunCalendarTimeDialogView {
	protected JunCalendarTimeViewAwt calendarTimeView;
	protected Button acceptButton;
	protected Button cancelButton;

	/**
	 * Create a new instance of <code>JunCalendarTimeDialogViewAwt</code> and initialize it.
	 * 
	 * @param newCalendarTimeDialog JunCalendarTimeDialog
	 * @category Instance creation
	 */
	public JunCalendarTimeDialogViewAwt(JunCalendarTimeDialog newCalendarTimeDialog) {
		super(newCalendarTimeDialog);
	}

	/**
	 * Answer the default dialog.
	 *
	 * @return java.awt.Dialog
	 * @category accessing
	 */
	public Dialog defaultDialog() {
		Dialog aDialog = new Dialog(new Frame(), this.getCalendarTimeDialog().windowTitle(), true);
		aDialog.add(this);
		aDialog.pack();
		return aDialog;
	}

	/**
	 * Answer my model as a JunCalendarTimeDialog.
	 * @return JunCalendarTimeDialog
	 * @category accessing
	 */
	public JunCalendarTimeDialog getCalendarTimeDialog() {
		return (JunCalendarTimeDialog) this.model();
	}

	/**
	 * Answer my accept button.
	 * @return java.awt.Button
	 * @category accessing
	 */
	protected Button acceptButton() {
		if (acceptButton == null) {
			acceptButton = new Button(JunSystem.$String("Accept"));
			acceptButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					if (((Boolean) getCalendarTimeDialog().acceptButtonPressed()).booleanValue()) {
						getCalendarTimeDialog().accept().value_(true);
					}
				}
			});
		}
		return acceptButton;
	}

	/**
	 * Build this component.
	 * @category interface opening
	 */
	protected void buildComponent() {
		this.setLayout(new WindowSpecLayout());
		this.add(this.calendarTimeView(), WindowSpecLayout.Position(0f, 1, 0f, 1, 1f, -102, 1f, -1));
		this.add(this.cancelButton(), WindowSpecLayout.Position(1f, -96, 0f, 56, 1f, -8, 0f, 88));
		this.add(this.acceptButton(), WindowSpecLayout.Position(1f, -96, 0f, 16, 1f, -8, 0f, 48));
		defaultButton = this.acceptButton();
		this.setSize(250, 200);
	}

	/**
	 * Answer my cancel button.
	 *
	 * @return java.awt.Button
	 * @category accessing
	 */
	protected Button cancelButton() {
		if (cancelButton == null) {
			cancelButton = new Button(JunSystem.$String("Cancel"));
			cancelButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					if (((Boolean) getCalendarTimeDialog().cancelButtonPressed()).booleanValue()) {
						getCalendarTimeDialog().cancel().value_(true);
					}
				}
			});
		}
		return cancelButton;
	}

	/**
	 * Answer my calendar date view.
	 *
	 * @return JunCalendarTimeViewAwt
	 * @category accessing
	 */
	protected JunCalendarTimeViewAwt calendarTimeView() {
		if (calendarTimeView == null) {
			calendarTimeView = new JunCalendarTimeViewAwt(this.getCalendarTimeDialog().calendarTimeModel());
		}
		return calendarTimeView;
	}
}
