package jp.co.sra.jun.goodies.calendar;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import jp.co.sra.smalltalk.StInterval;
import jp.co.sra.smalltalk.StView;
import jp.co.sra.jun.system.framework.JunApplicationModel;

/**
 * JunCalendarModel class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2003/03/03 (by Mitsuhiro Asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun469 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunCalendarModel.java,v 8.12 2008/02/20 06:31:12 nisinaka Exp $
 */
public class JunCalendarModel extends JunApplicationModel {

	/**
	 * Create a new instance of <code>JunCalendarModel</code> and initialize it.
	 * 
	 * @category Instance creation
	 */
	public JunCalendarModel() {
		super();
	}

	/**
	 * Answer the clock number from a string.
	 * 
	 * @return int
	 * @param aString java.lang.String
	 * @category Utilities
	 */
	public static int ClockFromString_(String aString) {
		return Integer.parseInt(aString);
	}

	/**
	 * Answer the date, time and clock from string.
	 * 
	 * @return java.util.Date
	 * @param aString java.lang.String
	 * @category Utilities
	 */
	public static Date DateAndTimeAndClockFromString_(String aString) {
		SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss SSS");
		try {
			return format.parse(aString);
		} catch (ParseException e) {
			System.out.println(e.getMessage());
			e.printStackTrace();
		}
		return null;
	}

	/**
	 * Answer the date and time from string.
	 * 
	 * @return java.util.Date
	 * @param aString java.lang.String
	 * @category Utilities
	 */
	public static Date DateAndTimeFromString_(String aString) {
		SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
		try {
			return format.parse(aString);
		} catch (ParseException e) {
			System.out.println(e.getMessage());
			e.printStackTrace();
		}
		return null;
	}

	/**
	 * Answer the date from string.
	 * 
	 * @return java.util.Date
	 * @param aString java.lang.String
	 * @category Utilities
	 */
	public static Date DateFromString_(String aString) {
		SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd");
		try {
			return format.parse(aString);
		} catch (ParseException e) {
			System.out.println(e.getMessage());
			e.printStackTrace();
		}
		return null;
	}

	/**
	 * Answer separated strings.
	 *
	 * @return java.lang.String[]
	 * @param separateCollection java.lang.String
	 * @param dividerCollection java.util.Vector
	 * @category Utilities
	 */
	public static String[] Separate_dividers_(String separateCollection, char[] dividerCollection) {
		Vector indexCollection = new Vector();
		indexCollection.add(new Integer(-1));
		for (int index = 0; index < separateCollection.length(); index++) {
			char each = separateCollection.charAt(index);
			for (int j = 0; j < dividerCollection.length; j++) {
				if (dividerCollection[j] == each) {
					indexCollection.add(new Integer(index));
				}
			}
		}
		indexCollection.add(new Integer(separateCollection.length()));

		Vector intervalCollection = new Vector();
		for (int i = 0; i < indexCollection.size() - 1; i++) {
			int s = ((Integer) indexCollection.get(i)).intValue();
			int e = ((Integer) indexCollection.get(i + 1)).intValue();
			intervalCollection.add(new StInterval(s + 1, e - 1));
		}

		Vector result = new Vector();
		for (int i = 0; i < intervalCollection.size(); i++) {
			StInterval interval = (StInterval) intervalCollection.get(i);
			if (interval.size() > 0) {
				String part = separateCollection.substring((int) interval.first(), (int) interval.last() + 1);
				result.add(part);
			}
		}

		String[] strings = new String[result.size()];
		result.copyInto(strings);
		return strings;
	}

	/**
	 * Answer the separator charactors.
	 *
	 * @return char[]
	 * @category Utilities
	 */
	public static char[] Separators() {
		char[] separators = new char[5];
		separators[0] = ' ';
		separators[1] = '\t';
		separators[2] = '\r';
		separators[3] = '\f';
		separators[4] = '\n';
		return separators;
	}

	/**
	 * Answer the string from now clock value.
	 * 
	 * @return java.lang.String
	 * @category Utilities
	 */
	public static String StringFromClock() {
		SimpleDateFormat format = new SimpleDateFormat("SSS");
		return format.format(new Date());
	}

	/**
	 * Answer the string from clock value.
	 * 
	 * @return java.lang.String
	 * @param clockValue int
	 * @category Utilities
	 */
	public static String StringFromClock_(int clockValue) {
		return String.valueOf(clockValue);
	}

	/**
	 * Answer the string from today.
	 * 
	 * @return java.lang.String
	 * @category Utilities
	 */
	public static String StringFromDate() {
		return JunCalendarModel.StringFromDate_(new Date());
	}

	/**
	 * Answer the string from date.
	 * 
	 * @return java.lang.String
	 * @param aDate java.util.Date
	 * @category Utilities
	 */
	public static String StringFromDate_(Date aDate) {
		SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd");
		return format.format(aDate);
	}

	/**
	 * Answer the string from now date and time.
	 * 
	 * @return java.lang.String
	 * @category Utilities
	 */
	public static String StringFromDateAndTime() {
		return JunCalendarModel.StringFromDateAndTime_(new Date());
	}

	/**
	 * Answer the string from date and time.
	 * 
	 * @return java.lang.String
	 * @param dateAndTime java.util.Date
	 * @category Utilities
	 */
	public static String StringFromDateAndTime_(Date dateAndTime) {
		SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
		return format.format(dateAndTime);
	}

	/**
	 * Answer the string from now date, time and clock.
	 * 
	 * @return java.lang.String
	 * @category Utilities
	 */
	public static String StringFromDateAndTimeAndClock() {
		return JunCalendarModel.StringFromDateAndTimeAndClock_(new Date());
	}

	/**
	 * Answer the string from date, time and clock.
	 * 
	 * @return java.lang.String
	 * @param dateAndTimeAndClock java.util.Date
	 * @category Utilities
	 */
	public static String StringFromDateAndTimeAndClock_(Date dateAndTimeAndClock) {
		SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss SSS");
		return format.format(dateAndTimeAndClock);
	}

	/**
	 * Answer the string from now time.
	 * 
	 * @return java.lang.String
	 * @category Utilities
	 */
	public static String StringFromTime() {
		return JunCalendarModel.StringFromTime_(new Date());
	}

	/**
	 * Answer the string from time.
	 * 
	 * @return java.lang.String
	 * @param aTime java.util.Date
	 * @category Utilities
	 */
	public static String StringFromTime_(Date aTime) {
		SimpleDateFormat format = new SimpleDateFormat("HH:mm:ss");
		return format.format(aTime);
	}

	/**
	 * Answer the time from string.
	 * 
	 * @return java.util.Date
	 * @param aString java.lang.String
	 * @category Utilities
	 */
	public static Date TimeFromString_(String aString) {
		SimpleDateFormat format = new SimpleDateFormat("HH:mm:ss");
		try {
			return format.parse(aString);
		} catch (ParseException e) {
			System.out.println(e.getMessage());
			e.printStackTrace();
		}
		return null;
	}

	/**
	 * Answer a default view.
	 * 
	 * @return jp.co.sra.smalltalk.StView
	 * @see jp.co.sra.smalltalk.StApplicationModel#defaultView()
	 * @category interface opening
	 */
	public StView defaultView() {
		return null;
	}
}
