package jp.co.sra.jun.goodies.calendar;

import java.util.Calendar;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunCalendarDateIntervalModelTestExamples class
 * 
 *  @author    Nobuto Matsubara
 *  @created   2003/10/06 (by Nobuto Matsubara)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun472 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunCalendarDateIntervalModelTestExamples.java,v 8.11 2008/02/20 06:31:12 nisinaka Exp $
 */
public class JunCalendarDateIntervalModelTestExamples extends JunTestExamples {
	/**
	 * Example1: Open a JunCalendarDateIntervalModel.
	 *
	 * @return boolean
	 */
	public static boolean Example1() {
		JunCalendarDateIntervalModel calendarDateIntervalModel = new JunCalendarDateIntervalModel();
		calendarDateIntervalModel.open();
		return true;
	}

	/**
	 * Example2: Set time and open a JunCalendarDateIntervalModel.
	 *
	 * @return boolean
	 */
	public static boolean Example2() {
		Calendar now = Calendar.getInstance();
		Calendar after7days = Calendar.getInstance();
		after7days.add(Calendar.DATE, 7);
		JunCalendarDateIntervalModel calendarDateIntervalModel = JunCalendarDateIntervalModel.From_to_(now, after7days);
		calendarDateIntervalModel.open();
		return true;
	}

	/**
	 * Example3: Set time and open a JunCalendarDateIntervalModel.
	 *
	 * @return true
	 */
	public static boolean Example3() {
		Calendar now = Calendar.getInstance();
		Calendar before14days = Calendar.getInstance();
		before14days.add(Calendar.DATE, -14); // error setting
		JunCalendarDateIntervalModel calendarDateIntervalModel = JunCalendarDateIntervalModel.From_to_(now, before14days);
		calendarDateIntervalModel.open();
		return true;
	}

	/**
	 * Execute all examples.
	 *
	 * @param args an array of command-line arguments
	 */
	public static void main(String args[]) {
		new JunCalendarDateIntervalModelTestExamples();
	}
}
